/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.junit.JUnit4AnnotatedMethodInJUnit3TestCaseInspectionBase;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JUnit4AnnotatedMethodInJUnit3TestCaseInspection
extends JUnit4AnnotatedMethodInJUnit3TestCaseInspectionBase {
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>(3);
        PsiMethod method = (PsiMethod)infos[1];
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Ignore", (boolean)false)) {
            fixes.add(new RemoveIgnoreAndRename(method));
        }
        if (TestUtils.isJUnit4TestMethod(method)) {
            String newMethodName;
            String methodName = method.getName();
            if (methodName.startsWith("test")) {
                newMethodName = null;
            } else {
                boolean lowCaseStyle = methodName.contains("_");
                newMethodName = "test" + (lowCaseStyle ? "_" + methodName : StringUtil.capitalize((String)methodName));
            }
            fixes.add(new RemoveTestAnnotationFix(newMethodName));
        }
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        fixes.add(new ConvertToJUnit4Fix(className));
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(new InspectionGadgetsFix[fixes.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    private static void deleteAnnotation(ProblemDescriptor descriptor, String qualifiedName) {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiModifierListOwner)) {
            return;
        }
        PsiModifierListOwner method = (PsiModifierListOwner)parent;
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiAnnotation annotation = modifierList.findAnnotation(qualifiedName);
        if (annotation == null) {
            return;
        }
        annotation.delete();
    }

    private static class RemoveTestAnnotationFix
    extends RenameFix {
        private final String myNewName;

        public RemoveTestAnnotationFix(String newName) {
            super(newName);
            this.myNewName = newName;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("remove.junit4.test.annotation.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$RemoveTestAnnotationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myNewName == null ? this.getFamilyName() : InspectionGadgetsBundle.message("remove.junit4.test.annotation.and.rename.quickfix", this.myNewName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$RemoveTestAnnotationFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            JUnit4AnnotatedMethodInJUnit3TestCaseInspection.deleteAnnotation(descriptor, "org.junit.Test");
            if (this.myNewName != null) {
                super.doFix(project2, descriptor);
            }
        }
    }

    private static class ConvertToJUnit4Fix
    extends InspectionGadgetsFix {
        private final String className;

        ConvertToJUnit4Fix(String className) {
            this.className = className;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("convert.junit3.test.class.quickfix", this.className);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$ConvertToJUnit4Fix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Convert JUnit 3 class to JUnit 4" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$ConvertToJUnit4Fix", "getFamilyName"));
            }
            return "Convert JUnit 3 class to JUnit 4";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiMethod[] methods;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMember)) {
                return;
            }
            PsiMember member = (PsiMember)parent;
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiReferenceList extendsList = containingClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            for (PsiMethod method : methods = containingClass.getMethods()) {
                PsiType returnType;
                String name = method.getName();
                if (method.hasModifierProperty("static") || !PsiType.VOID.equals((Object)(returnType = method.getReturnType()))) continue;
                PsiModifierList modifierList = method.getModifierList();
                if (name.startsWith("test")) {
                    ConvertToJUnit4Fix.addAnnotationIfNotPresent(modifierList, "org.junit.Test");
                } else if (name.equals("setUp")) {
                    ConvertToJUnit4Fix.transformSetUpOrTearDownMethod(method);
                    ConvertToJUnit4Fix.addAnnotationIfNotPresent(modifierList, "org.junit.Before");
                } else if (name.equals("tearDown")) {
                    ConvertToJUnit4Fix.transformSetUpOrTearDownMethod(method);
                    ConvertToJUnit4Fix.addAnnotationIfNotPresent(modifierList, "org.junit.After");
                }
                method.accept((PsiElementVisitor)new MethodCallModifier());
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                referenceElement.delete();
            }
        }

        private static void addAnnotationIfNotPresent(PsiModifierList modifierList, String qualifiedAnnotationName) {
            if (modifierList.findAnnotation(qualifiedAnnotationName) != null) {
                return;
            }
            PsiAnnotation annotation = modifierList.addAnnotation(qualifiedAnnotationName);
            Project project2 = modifierList.getProject();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            codeStyleManager.shortenClassReferences((PsiElement)annotation);
        }

        private static void transformSetUpOrTearDownMethod(PsiMethod method) {
            PsiAnnotation overrideAnnotation;
            PsiModifierList modifierList = method.getModifierList();
            if (modifierList.hasModifierProperty("protected")) {
                modifierList.setModifierProperty("protected", false);
            }
            if (!modifierList.hasModifierProperty("public")) {
                modifierList.setModifierProperty("public", true);
            }
            if ((overrideAnnotation = modifierList.findAnnotation("java.lang.Override")) != null) {
                overrideAnnotation.delete();
            }
            method.accept((PsiElementVisitor)new SuperLifeCycleCallRemover(method.getName()));
        }

        private static class MethodCallModifier
        extends JavaRecursiveElementVisitor {
            private MethodCallModifier() {
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                if (methodExpression.getQualifierExpression() != null) {
                    return;
                }
                PsiMethod method = expression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                String name = aClass.getQualifiedName();
                if (!"junit.framework.Assert".equals(name)) {
                    return;
                }
                String newExpressionText = "org.junit.Assert." + expression.getText();
                Project project2 = expression.getProject();
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
                PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression);
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
                PsiElement replacedExpression = expression.replace((PsiElement)newExpression);
                codeStyleManager.shortenClassReferences(replacedExpression);
            }
        }

        private static class SuperLifeCycleCallRemover
        extends JavaRecursiveElementVisitor {
            @NotNull
            private final String myLifeCycleMethodName;

            private SuperLifeCycleCallRemover(@NotNull String lifeCycleMethodName) {
                if (lifeCycleMethodName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lifeCycleMethodName", "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$ConvertToJUnit4Fix$SuperLifeCycleCallRemover", "<init>"));
                }
                this.myLifeCycleMethodName = lifeCycleMethodName;
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!this.myLifeCycleMethodName.equals(methodName)) {
                    return;
                }
                PsiExpression target = methodExpression.getQualifierExpression();
                if (!(target instanceof PsiSuperExpression)) {
                    return;
                }
                expression.delete();
            }
        }
    }

    private static class RemoveIgnoreAndRename
    extends RenameFix {
        public RemoveIgnoreAndRename(@NonNls PsiMethod method) {
            super("_" + method.getName());
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("ignore.test.method.in.class.extending.junit3.testcase.quickfix", this.getTargetName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspection$RemoveIgnoreAndRename", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            JUnit4AnnotatedMethodInJUnit3TestCaseInspection.deleteAnnotation(descriptor, "org.junit.Ignore");
            super.doFix(project2, descriptor);
        }
    }
}

