/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

class ReturnPointCountVisitor
extends JavaRecursiveElementWalkingVisitor {
    private int m_count;
    private final boolean ignoreGuardClauses;
    private boolean previousWasGuardClause = true;

    ReturnPointCountVisitor(boolean ignoreGuardClauses) {
        this.ignoreGuardClauses = ignoreGuardClauses;
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/methodmetrics/ReturnPointCountVisitor", "visitAnonymousClass"));
        }
    }

    public void visitReturnStatement(@NotNull PsiReturnStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/ReturnPointCountVisitor", "visitReturnStatement"));
        }
        super.visitReturnStatement(statement2);
        if (this.ignoreGuardClauses && this.previousWasGuardClause) {
            return;
        }
        ++this.m_count;
    }

    public void visitStatement(PsiStatement statement2) {
        super.visitStatement(statement2);
        if (!this.previousWasGuardClause) {
            return;
        }
        if (statement2 instanceof PsiDeclarationStatement) {
            return;
        }
        PsiElement parent = statement2.getParent();
        if (!(parent instanceof PsiCodeBlock)) {
            return;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiMethod)) {
            return;
        }
        this.previousWasGuardClause = ReturnPointCountVisitor.isGuardClause(statement2);
    }

    private static boolean isGuardClause(PsiStatement statement2) {
        if (!(statement2 instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)statement2;
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch instanceof PsiReturnStatement) {
            return true;
        }
        if (!(thenBranch instanceof PsiBlockStatement)) {
            return false;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement containedStatement = ControlFlowUtils.getOnlyStatementInBlock(codeBlock);
        return containedStatement instanceof PsiReturnStatement;
    }

    public int getCount() {
        return this.m_count;
    }

    public void visitLambdaExpression(PsiLambdaExpression expression) {
    }

    public void visitClass(PsiClass aClass) {
    }
}

