/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class DollarSignInNameInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("dollar.sign.in.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/DollarSignInNameInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("dollar.sign.in.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/DollarSignInNameInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DollarSignInNameVisitor();
    }

    private static class DollarSignInNameVisitor
    extends BaseInspectionVisitor {
        private DollarSignInNameVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/naming/DollarSignInNameInspectionBase$DollarSignInNameVisitor", "visitVariable"));
            }
            super.visitVariable(variable);
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (name.indexOf(36) < 0) {
                return;
            }
            this.registerVariableError(variable, new Object[0]);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/DollarSignInNameInspectionBase$DollarSignInNameVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            String name = method.getName();
            if (name.indexOf(36) < 0) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/naming/DollarSignInNameInspectionBase$DollarSignInNameVisitor", "visitClass"));
            }
            String name = aClass.getName();
            if (name == null) {
                return;
            }
            if (name.indexOf(36) < 0) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

