/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAtomicOperationOnVolatileFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.atomic.operation.on.volatile.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.atomic.operation.on.volatile.field.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonAtomicOperationOnVolatileFieldVisitor();
    }

    private static class NonAtomicOperationOnVolatileFieldVisitor
    extends BaseInspectionVisitor {
        private NonAtomicOperationOnVolatileFieldVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection$NonAtomicOperationOnVolatileFieldVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression);
            PsiExpression rhs = expression.getRExpression();
            if (rhs == null) {
                return;
            }
            PsiExpression lhs = expression.getLExpression();
            PsiField volatileField = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileField(lhs);
            if (volatileField == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSEQ) || tokenType.equals(JavaTokenType.MINUSEQ) || tokenType.equals(JavaTokenType.ASTERISKEQ) || tokenType.equals(JavaTokenType.DIVEQ) || tokenType.equals(JavaTokenType.ANDEQ) || tokenType.equals(JavaTokenType.OREQ) || tokenType.equals(JavaTokenType.XOREQ) || tokenType.equals(JavaTokenType.PERCEQ) || tokenType.equals(JavaTokenType.LTLTEQ) || tokenType.equals(JavaTokenType.GTGTEQ) || tokenType.equals(JavaTokenType.GTGTGTEQ)) {
                this.registerError((PsiElement)lhs, new Object[0]);
                return;
            }
            if (VariableAccessUtils.variableIsUsed((PsiVariable)volatileField, (PsiElement)rhs)) {
                this.registerError((PsiElement)lhs, new Object[0]);
            }
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.PLUS.equals(tokenType) || JavaTokenType.MINUS.equals(tokenType) || JavaTokenType.EXCL.equals(tokenType)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiField volatileField = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileField(operand);
            if (volatileField == null) {
                return;
            }
            this.registerError((PsiElement)operand, new Object[0]);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            super.visitPostfixExpression(expression);
            PsiExpression operand = expression.getOperand();
            PsiField volatileField = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileField(operand);
            if (volatileField == null) {
                return;
            }
            this.registerError((PsiElement)operand, new Object[0]);
        }

        @Nullable
        private static PsiField findNonSynchronizedVolatileField(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("volatile")) {
                return null;
            }
            if (SynchronizationUtil.isInSynchronizedContext((PsiElement)reference)) {
                return null;
            }
            return field;
        }
    }
}

