/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.CommentOnLineWithSourcePredicate;
import org.jetbrains.annotations.NotNull;

public class MoveCommentToSeparateLineIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        CommentOnLineWithSourcePredicate commentOnLineWithSourcePredicate = new CommentOnLineWithSourcePredicate();
        if (commentOnLineWithSourcePredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/comment/MoveCommentToSeparateLineIntention", "getElementPredicate"));
        }
        return commentOnLineWithSourcePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiComment selectedComment;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/comment/MoveCommentToSeparateLineIntention", "processIntention"));
        }
        PsiComment elementToCheck = selectedComment = (PsiComment)element;
        do {
            if ((elementToCheck = PsiTreeUtil.prevLeaf((PsiElement)elementToCheck)) != null) continue;
            return;
        } while (!MoveCommentToSeparateLineIntention.isLineBreakWhiteSpace((PsiElement)elementToCheck));
        PsiWhiteSpace whiteSpace = (PsiWhiteSpace)elementToCheck;
        PsiElement copyWhiteSpace = whiteSpace.copy();
        PsiElement parent = whiteSpace.getParent();
        assert (parent != null);
        PsiManager manager = selectedComment.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String commentText = selectedComment.getText();
        PsiComment newComment = factory.createCommentFromText(commentText, parent);
        PsiElement insertedComment = parent.addBefore((PsiElement)newComment, (PsiElement)whiteSpace);
        parent.addBefore(copyWhiteSpace, insertedComment);
        selectedComment.delete();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        codeStyleManager.reformat(insertedComment);
    }

    private static boolean isLineBreakWhiteSpace(PsiElement element) {
        if (!(element instanceof PsiWhiteSpace)) {
            return false;
        }
        String text = element.getText();
        return MoveCommentToSeparateLineIntention.containsLineBreak(text);
    }

    private static boolean containsLineBreak(String text) {
        return text.indexOf(10) >= 0 || text.indexOf(13) >= 0;
    }
}

