/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.OperatorAssignmentPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceOperatorAssignmentWithAssignmentIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        OperatorAssignmentPredicate operatorAssignmentPredicate = new OperatorAssignmentPredicate();
        if (operatorAssignmentPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/opassign/ReplaceOperatorAssignmentWithAssignmentIntention", "getElementPredicate"));
        }
        return operatorAssignmentPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        String operator = sign.getText();
        return IntentionPowerPackBundle.message("replace.operator.assignment.with.assignment.intention.name", operator);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/opassign/ReplaceOperatorAssignmentWithAssignmentIntention", "processIntention"));
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        String operator = sign.getText();
        String newOperator = operator.substring(0, operator.length() - 1);
        String lhsText = lhs.getText();
        String rhsText = rhs == null ? "" : rhs.getText();
        boolean parentheses = ParenthesesUtils.areParenthesesNeeded(sign, rhs);
        String cast = ReplaceOperatorAssignmentWithAssignmentIntention.getCastString(lhs, rhs);
        StringBuilder newExpression = new StringBuilder(lhsText);
        newExpression.append('=').append(cast);
        if (!cast.isEmpty()) {
            newExpression.append('(');
        }
        newExpression.append(lhsText).append(newOperator);
        if (parentheses) {
            newExpression.append('(').append(rhsText).append(')');
        } else {
            newExpression.append(rhsText);
        }
        if (!cast.isEmpty()) {
            newExpression.append(')');
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)assignmentExpression, newExpression.toString());
    }

    private static String getCastString(PsiExpression lhs, PsiExpression rhs) {
        if (lhs == null || rhs == null) {
            return "";
        }
        PsiType lType = lhs.getType();
        PsiType rType = rhs.getType();
        if (TypeConversionUtil.isNumericType((PsiType)rType)) {
            rType = TypeConversionUtil.binaryNumericPromotion((PsiType)lType, (PsiType)rType);
        }
        if (lType == null || rType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType) || !TypeConversionUtil.areTypesConvertible((PsiType)lType, (PsiType)rType)) {
            return "";
        }
        return '(' + lType.getCanonicalText() + ')';
    }
}

