/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.CharsetToolkit;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.debugger.LogEntry;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.io.CharSequenceBackedByChars;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"createDebugLogger", "Lorg/jetbrains/debugger/MessagingLogger;", "key", "", "script-debugger-backend"})
public final class UtilKt {
    @Nullable
    public static final MessagingLogger createDebugLogger(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String debugFile = Registry.stringValue((String)key);
        CharSequence $receiver$iv = debugFile;
        if ($receiver$iv == null || $receiver$iv.length() == 0) {
            return null;
        }
        ConcurrentLinkedQueue<LogEntry> queue = new ConcurrentLinkedQueue<LogEntry>();
        MessagingLogger logger = new MessagingLogger(queue);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(debugFile, queue, logger){
            final /* synthetic */ String $debugFile;
            final /* synthetic */ ConcurrentLinkedQueue $queue;
            final /* synthetic */ MessagingLogger $logger;

            public final void run() {
                OutputStreamWriter writer;
                FileOutputStream out;
                block7: {
                    File file2 = new File(FileUtil.expandUserHome((String)this.$debugFile));
                    out = new FileOutputStream(file2);
                    OutputStream outputStream = out;
                    Charset charset = null;
                    boolean bl = true;
                    Object var7_7 = null;
                    if (var7_7 != null) {
                        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writer");
                    }
                    if (bl & true) {
                        charset = Charsets.UTF_8;
                    }
                    writer = new OutputStreamWriter(outputStream, charset);
                    writer.write("[\n");
                    writer.flush();
                    FileChannel fileChannel = out.getChannel();
                    SimpleDateFormat dateFormatter = new SimpleDateFormat("HH.mm.ss,SSS");
                    while (true) {
                        Object message;
                        LogEntry entry;
                        if ((LogEntry)this.$queue.poll() == null) {
                            if (!this.$logger.getClosed$script_debugger_backend()) continue;
                            break block7;
                        }
                        writer.write("{" + "\"" + "timestamp" + "\"" + ": " + "\"" + dateFormatter.format(entry.getTime$script_debugger_backend()) + "\"" + ", ");
                        Object object = message = entry.getMessage();
                        if (object instanceof CharSequence) {
                            writer.write("\"" + entry.getMarker() + "\"" + ": ");
                            writer.flush();
                            if (message instanceof CharSequenceBackedByChars) {
                                fileChannel.write(((CharSequenceBackedByChars)((Object)message)).getByteBuffer());
                            } else {
                                fileChannel.write(CharsetToolkit.UTF8_CHARSET.encode(CharBuffer.wrap((CharSequence)message)));
                            }
                            writer.write("},\n");
                            writer.flush();
                            continue;
                        }
                        if (!(object instanceof ByteBuf)) break;
                        writer.write("\"" + entry.getMarker() + "\"" + ": ");
                        writer.flush();
                        ((ByteBuf)message).getBytes(((ByteBuf)message).readerIndex(), (OutputStream)out, ((ByteBuf)message).readableBytes());
                        ((ByteBuf)message).release();
                        writer.write("},\n");
                        writer.flush();
                    }
                    throw (Throwable)new RuntimeException("Unknown message type");
                }
                writer.write("]");
                out.close();
            }
            {
                this.$debugFile = string;
                this.$queue = concurrentLinkedQueue;
                this.$logger = messagingLogger;
            }
        });
        return logger;
    }
}

