/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEditorsProvider
extends XDebuggerEditorsProviderBase {
    @NotNull
    public FileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "getFileType"));
        }
        return javaFileType;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project2, @NotNull String text, @Nullable PsiElement context, boolean isPhysical) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        return JavaCodeFragmentFactory.getInstance((Project)project2).createExpressionCodeFragment(text, context, null, isPhysical);
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project2, @Nullable XSourcePosition sourcePosition) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "getSupportedLanguages"));
        }
        if (sourcePosition != null) {
            PsiElement context = this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project2);
            Collection collection = DebuggerUtilsEx.getCodeFragmentFactories(context).stream().map(factory -> factory.getFileType().getLanguage()).collect(Collectors.toList());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "getSupportedLanguages"));
            }
            return collection;
        }
        List<Language> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "getSupportedLanguages"));
        }
        return list;
    }

    @NotNull
    public XExpression createExpression(@NotNull Project project2, @NotNull Document document, @Nullable Language language, @NotNull EvaluationMode mode) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpression"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpression"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpression"));
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (psiFile != null) {
            XExpressionImpl xExpressionImpl = new XExpressionImpl(psiFile.getText(), language, ((JavaCodeFragment)psiFile).importsToString(), mode);
            if (xExpressionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpression"));
            }
            return xExpressionImpl;
        }
        XExpression xExpression = super.createExpression(project2, document, language, mode);
        if (xExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpression"));
        }
        return xExpression;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project2, @NotNull XExpression expression, @Nullable PsiElement context, boolean isPhysical) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        TextWithImports text = TextWithImportsImpl.fromXExpression(expression);
        if (text != null && context != null) {
            CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text, context);
            JavaCodeFragment codeFragment = factory.createPresentationCodeFragment(text, context, project2);
            codeFragment.forceResolveScope(GlobalSearchScope.allScope((Project)project2));
            PsiClass contextClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiClass.class});
            if (contextClass != null) {
                PsiClassType contextType = JavaPsiFacade.getInstance((Project)codeFragment.getProject()).getElementFactory().createType(contextClass);
                codeFragment.setThisType((PsiType)contextType);
            }
            return codeFragment;
        }
        return super.createExpressionCodeFragment(project2, expression, context, isPhysical);
    }
}

