/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.config;

import org.jetbrains.java.generate.config.DuplicationPolicy;
import org.jetbrains.java.generate.config.FilterPattern;
import org.jetbrains.java.generate.config.InsertWhere;

public class Config {
    public boolean useFullyQualifiedName = false;
    public InsertWhere insertNewMethodOption = InsertWhere.AT_CARET;
    public DuplicationPolicy whenDuplicatesOption = DuplicationPolicy.ASK;
    public boolean filterConstantField = true;
    public boolean filterEnumField = false;
    public boolean filterTransientModifier = false;
    public boolean filterStaticModifier = true;
    public String filterFieldName = null;
    public String filterMethodName = null;
    public String filterMethodType = null;
    public String filterFieldType = null;
    public boolean filterLoggers = true;
    public boolean addImplementSerializable = false;
    public boolean enableMethods = false;
    public boolean jumpToMethod = true;
    public int sortElements = 0;
    private FilterPattern myPattern = null;

    public boolean isUseFullyQualifiedName() {
        return this.useFullyQualifiedName;
    }

    public void setUseFullyQualifiedName(boolean useFullyQualifiedName) {
        this.useFullyQualifiedName = useFullyQualifiedName;
    }

    public DuplicationPolicy getReplaceDialogInitialOption() {
        return this.whenDuplicatesOption;
    }

    public void setReplaceDialogInitialOption(DuplicationPolicy option) {
        this.whenDuplicatesOption = option;
    }

    public InsertWhere getInsertNewMethodInitialOption() {
        return this.insertNewMethodOption;
    }

    public void setInsertNewMethodInitialOption(InsertWhere where) {
        this.insertNewMethodOption = where;
    }

    public boolean isFilterConstantField() {
        return this.filterConstantField;
    }

    public void setFilterConstantField(boolean filterConstantField) {
        this.filterConstantField = filterConstantField;
    }

    public boolean isFilterTransientModifier() {
        return this.filterTransientModifier;
    }

    public void setFilterTransientModifier(boolean filterTransientModifier) {
        this.filterTransientModifier = filterTransientModifier;
    }

    public boolean isFilterStaticModifier() {
        return this.filterStaticModifier;
    }

    public void setFilterStaticModifier(boolean filterStaticModifier) {
        this.filterStaticModifier = filterStaticModifier;
    }

    public String getFilterFieldName() {
        if (this.filterFieldName == null) {
            return "";
        }
        return this.filterFieldName;
    }

    public void setFilterFieldName(String filterFieldName) {
        this.filterFieldName = filterFieldName;
    }

    public boolean isEnableMethods() {
        return this.enableMethods;
    }

    public void setEnableMethods(boolean enableMethods) {
        this.enableMethods = enableMethods;
    }

    public String getFilterMethodName() {
        if (this.filterMethodName == null) {
            return "";
        }
        return this.filterMethodName;
    }

    public void setFilterMethodName(String filterMethodName) {
        this.filterMethodName = filterMethodName;
    }

    public boolean isJumpToMethod() {
        return this.jumpToMethod;
    }

    public void setJumpToMethod(boolean jumpToMethod) {
        this.jumpToMethod = jumpToMethod;
    }

    public boolean isFilterEnumField() {
        return this.filterEnumField;
    }

    public void setFilterEnumField(boolean filterEnumField) {
        this.filterEnumField = filterEnumField;
    }

    public int getSortElements() {
        return this.sortElements;
    }

    public void setSortElements(int sortElements) {
        this.sortElements = sortElements;
    }

    public String getFilterFieldType() {
        if (this.filterFieldType == null) {
            return "";
        }
        return this.filterFieldType;
    }

    public void setFilterFieldType(String filterFieldType) {
        this.filterFieldType = filterFieldType;
    }

    public boolean isFilterLoggers() {
        return this.filterLoggers;
    }

    public void setFilterLoggers(boolean filterLoggers) {
        this.filterLoggers = filterLoggers;
    }

    public String getFilterMethodType() {
        if (this.filterMethodType == null) {
            return "";
        }
        return this.filterMethodType;
    }

    public void setFilterMethodType(String filterMethodType) {
        this.filterMethodType = filterMethodType;
    }

    public FilterPattern getFilterPattern() {
        FilterPattern pattern = this.myPattern;
        if (pattern != null) {
            return pattern;
        }
        pattern = new FilterPattern();
        pattern.setConstantField(this.filterConstantField);
        pattern.setTransientModifier(this.filterTransientModifier);
        pattern.setStaticModifier(this.filterStaticModifier);
        pattern.setFieldName(this.filterFieldName);
        pattern.setFieldType(this.filterFieldType);
        pattern.setMethodName(this.filterMethodName);
        pattern.setMethodType(this.filterMethodType);
        pattern.setEnumField(this.filterEnumField);
        pattern.setLoggers(this.filterLoggers);
        this.myPattern = pattern;
        return this.myPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        if (this.addImplementSerializable != config.addImplementSerializable) {
            return false;
        }
        if (this.enableMethods != config.enableMethods) {
            return false;
        }
        if (this.filterConstantField != config.filterConstantField) {
            return false;
        }
        if (this.filterEnumField != config.filterEnumField) {
            return false;
        }
        if (this.filterStaticModifier != config.filterStaticModifier) {
            return false;
        }
        if (this.filterTransientModifier != config.filterTransientModifier) {
            return false;
        }
        if (this.jumpToMethod != config.jumpToMethod) {
            return false;
        }
        if (this.sortElements != config.sortElements) {
            return false;
        }
        if (this.useFullyQualifiedName != config.useFullyQualifiedName) {
            return false;
        }
        if (this.filterFieldName != null ? !this.filterFieldName.equals(config.filterFieldName) : config.filterFieldName != null) {
            return false;
        }
        if (this.filterFieldType != null ? !this.filterFieldType.equals(config.filterFieldType) : config.filterFieldType != null) {
            return false;
        }
        if (this.filterMethodName != null ? !this.filterMethodName.equals(config.filterMethodName) : config.filterMethodName != null) {
            return false;
        }
        if (this.filterMethodType != null ? !this.filterMethodType.equals(config.filterMethodType) : config.filterMethodType != null) {
            return false;
        }
        if (!this.whenDuplicatesOption.equals((Object)config.whenDuplicatesOption)) {
            return false;
        }
        return this.insertNewMethodOption.equals((Object)config.insertNewMethodOption);
    }

    public int hashCode() {
        int result = this.useFullyQualifiedName ? 1 : 0;
        result = 29 * result + this.whenDuplicatesOption.hashCode();
        result = 29 * result + this.insertNewMethodOption.hashCode();
        result = 29 * result + (this.filterConstantField ? 1 : 0);
        result = 29 * result + (this.filterEnumField ? 1 : 0);
        result = 29 * result + (this.filterTransientModifier ? 1 : 0);
        result = 29 * result + (this.filterStaticModifier ? 1 : 0);
        result = 29 * result + (this.filterFieldName != null ? this.filterFieldName.hashCode() : 0);
        result = 29 * result + (this.filterFieldType != null ? this.filterFieldType.hashCode() : 0);
        result = 29 * result + (this.filterMethodName != null ? this.filterMethodName.hashCode() : 0);
        result = 29 * result + (this.filterMethodType != null ? this.filterMethodType.hashCode() : 0);
        result = 29 * result + (this.addImplementSerializable ? 1 : 0);
        result = 29 * result + (this.enableMethods ? 1 : 0);
        result = 29 * result + (this.jumpToMethod ? 1 : 0);
        result = 29 * result + this.sortElements;
        return result;
    }

    public String toString() {
        return "Config{useFullyQualifiedName=" + this.useFullyQualifiedName + ", replaceDialogOption=" + (Object)((Object)this.whenDuplicatesOption) + ", insertNewMethodOption=" + (Object)((Object)this.insertNewMethodOption) + ", filterConstantField=" + this.filterConstantField + ", filterEnumField=" + this.filterEnumField + ", filterTransientModifier=" + this.filterTransientModifier + ", filterStaticModifier=" + this.filterStaticModifier + ", filterFieldName='" + this.filterFieldName + "'" + ", filterFieldType='" + this.filterFieldType + "'" + ", filterMethodName='" + this.filterMethodName + "'" + ", filterMethodType='" + this.filterMethodType + "'" + ", addImplementSerializable=" + this.addImplementSerializable + ", enableMethods=" + this.enableMethods + ", jumpToMethod=" + this.jumpToMethod + ", sortElements=" + this.sortElements + "}";
    }
}

