/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.config;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.config.ConflictResolutionPolicy;
import org.jetbrains.java.generate.config.InsertAtCaretStrategy;
import org.jetbrains.java.generate.config.InsertNewMethodStrategy;

public class DuplicatePolicy
implements ConflictResolutionPolicy {
    private static final DuplicatePolicy instance = new DuplicatePolicy();
    private InsertNewMethodStrategy newMethodStrategy = InsertAtCaretStrategy.getInstance();

    private DuplicatePolicy() {
    }

    public static DuplicatePolicy getInstance() {
        return instance;
    }

    @Override
    public void setNewMethodStrategy(InsertNewMethodStrategy strategy) {
        this.newMethodStrategy = strategy;
    }

    @Override
    public PsiMethod applyMethod(PsiClass clazz, PsiMethod existingMethod, @NotNull PsiMethod newMethod, Editor editor) {
        if (newMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMethod", "org/jetbrains/java/generate/config/DuplicatePolicy", "applyMethod"));
        }
        return this.newMethodStrategy.insertNewMethod(clazz, newMethod, editor);
    }

    public String toString() {
        return "Duplicate";
    }
}

