/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionListener;

public final class SessionEventSupport {
    private final List<SessionListener> listeners = new ArrayList<SessionListener>();

    public void addSessionListener(SessionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeSessionListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasSessionListener(SessionListener listener) {
        return this.listeners.contains(listener);
    }

    public void fireSessionDisconnected(SessionEvent sessionEvent) {
        for (SessionListener listener : this.listeners) {
            listener.sessionDisconnected(sessionEvent);
        }
    }

    public void fireSessionDisconnecting(SessionEvent sessionEvent) {
        for (SessionListener listener : this.listeners) {
            listener.sessionDisconnecting(sessionEvent);
        }
    }

    public void fireSessionLoggedIn(SessionEvent sessionEvent) {
        for (SessionListener listener : this.listeners) {
            listener.sessionLoggedIn(sessionEvent);
        }
    }

    public void fireSessionLoggedOff(SessionEvent sessionEvent) {
        for (SessionListener listener : this.listeners) {
            listener.sessionLoggedOff(sessionEvent);
        }
    }

    public void fireSessionOpened(SessionEvent sessionEvent) {
        for (SessionListener listener : this.listeners) {
            listener.sessionOpened(sessionEvent);
        }
    }

    public void fireSessionOpening(SessionEvent sessionEvent) {
        for (SessionListener listener : this.listeners) {
            listener.sessionOpening(sessionEvent);
        }
    }

    public void fireSessionConnectionRefused(SessionEvent sessionEvent) {
        for (SessionListener listener : this.listeners) {
            listener.sessionConnectionRefused(sessionEvent);
        }
    }

    public void fireDebug(String message) {
        for (SessionListener listener : this.listeners) {
            listener.debug(message);
        }
    }

    public void fireSessionError(SessionEvent sessionEvent) {
        for (SessionListener listener : this.listeners) {
            listener.sessionError(sessionEvent);
        }
    }
}

