/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.archetype.common.ArchetypeFilesResolver;
import org.apache.maven.archetype.common.util.ListScanner;
import org.apache.maven.archetype.common.util.PathUtils;
import org.apache.maven.archetype.metadata.FileSet;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DefaultArchetypeFilesResolver
extends AbstractLogEnabled
implements ArchetypeFilesResolver {
    public List getFilesWithExtension(List files, String extension) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("");
        scanner.setIncludes("**/*." + extension);
        scanner.setExcludes("");
        return scanner.scan(files);
    }

    public List getFilteredFiles(List files, String filtered) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("");
        scanner.setIncludes(filtered);
        scanner.setExcludes("");
        List result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " filtered files in " + files.size() + " files");
        return result;
    }

    public List filterFiles(String moduleOffset, FileSet fileSet, List archetypeResources) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir((StringUtils.isEmpty((String)moduleOffset) ? "" : moduleOffset + File.separatorChar) + fileSet.getDirectory());
        scanner.setIncludes(fileSet.getIncludes());
        scanner.setExcludes(fileSet.getExcludes());
        scanner.setCaseSensitive(true);
        return scanner.scan(archetypeResources);
    }

    public List findOtherResources(int level, List files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("");
        String includes = "";
        for (int i = 0; i < level; ++i) {
            includes = includes + "*/";
        }
        scanner.setIncludes(includes + "**");
        scanner.setExcludes(languages);
        List result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " other resources in " + files.size() + " files at level " + level);
        return result;
    }

    public List findOtherResources(int level, List files, List sourcesFiles, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("");
        HashSet<String> selectedDirectories = new HashSet<String>();
        ArrayList<String> includes = new ArrayList<String>();
        Iterator sourcesFilesIterator = sourcesFiles.iterator();
        while (sourcesFilesIterator.hasNext()) {
            String sourcesFile = (String)sourcesFilesIterator.next();
            String directory = PathUtils.getDirectory(sourcesFile, level - 1);
            if (!selectedDirectories.contains(directory)) {
                includes.add(directory + "/**");
            }
            selectedDirectories.add(directory);
        }
        scanner.setExcludes(languages);
        List result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " other resources in " + files.size() + " files at level " + level);
        return result;
    }

    public List findOtherSources(int level, List files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("");
        String levelDirectory = "";
        for (int i = 0; i < level - 1; ++i) {
            levelDirectory = levelDirectory + "*/";
        }
        String includes = "";
        String[] languagesAsArray = StringUtils.split((String)languages);
        for (int i = 0; i < languagesAsArray.length; ++i) {
            includes = includes + levelDirectory + languagesAsArray[i];
        }
        scanner.setIncludes(includes);
        List result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " other sources in " + files.size() + " files at level " + level);
        return result;
    }

    public List findResourcesMainFiles(List files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("src/main");
        scanner.setIncludes("**");
        scanner.setExcludes(languages);
        List result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " resources in " + files.size() + " files");
        return result;
    }

    public List findResourcesTestFiles(List files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("src/test");
        scanner.setIncludes("**");
        scanner.setExcludes(languages);
        List result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " test resources in " + files.size() + " files");
        return result;
    }

    public List findSiteFiles(List files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("src/site");
        scanner.setIncludes("**");
        scanner.setExcludes(languages);
        List result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " site resources in " + files.size() + " files");
        return result;
    }

    public List findSourcesMainFiles(List files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("src/main");
        scanner.setIncludes(languages);
        List result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " sources in " + files.size() + " files");
        return result;
    }

    public List findSourcesTestFiles(List files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("src/test");
        scanner.setIncludes(languages);
        List result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " test sources in " + files.size() + " files");
        return result;
    }

    public List getPackagedFiles(List files, String packageName) {
        ArrayList<String> packagedFiles = new ArrayList<String>();
        Iterator filesIterator = files.iterator();
        while (filesIterator.hasNext()) {
            String file = (String)filesIterator.next();
            if (!file.startsWith(packageName)) continue;
            packagedFiles.add(file.substring(packageName.length() + 1));
        }
        this.getLogger().debug("Scanned " + packagedFiles.size() + " packaged files in " + files.size() + " files");
        return packagedFiles;
    }

    public String resolvePackage(File basedir, List languages) throws IOException {
        this.getLogger().debug("Resolving package in " + basedir + " using languages " + languages);
        List files = this.resolveFiles(basedir, languages);
        return this.resolvePackage(files);
    }

    public List getUnpackagedFiles(List files, String packageName) {
        ArrayList<String> unpackagedFiles = new ArrayList<String>();
        Iterator filesIterator = files.iterator();
        while (filesIterator.hasNext()) {
            String file = (String)filesIterator.next();
            if (file.startsWith(packageName)) continue;
            unpackagedFiles.add(file);
        }
        this.getLogger().debug("Scanned " + unpackagedFiles.size() + " unpackaged files in " + files.size() + " files");
        return unpackagedFiles;
    }

    private String getCommonPackage(String packageName, String templatePackage) {
        String common = "";
        String difference = StringUtils.difference((String)packageName, (String)templatePackage);
        if (StringUtils.isNotEmpty((String)difference)) {
            String temporaryCommon = StringUtils.substring((String)templatePackage, (int)0, (int)templatePackage.lastIndexOf(difference));
            common = !difference.startsWith(".") ? StringUtils.substring((String)temporaryCommon, (int)0, (int)temporaryCommon.lastIndexOf(".")) : temporaryCommon;
        } else {
            common = packageName;
        }
        return common;
    }

    private List resolveFiles(File basedir, List languages) throws IOException {
        String[] languagesArray = languages.toArray(new String[languages.size()]);
        Object[] languagesPathesArray = new String[languagesArray.length];
        for (int i = 0; i < languagesArray.length; ++i) {
            languagesPathesArray[i] = "**/src/**/" + languagesArray[i] + "/**";
        }
        String excludes = "target";
        Iterator<String> defaultExcludes = Arrays.asList(ListScanner.DEFAULTEXCLUDES).iterator();
        while (defaultExcludes.hasNext()) {
            excludes = excludes + "," + defaultExcludes.next() + "/**";
        }
        List absoluteFiles = FileUtils.getFiles((File)basedir, (String)StringUtils.join((Object[])languagesPathesArray, (String)","), (String)excludes);
        this.getLogger().debug("Found " + absoluteFiles.size() + " potential archetype files");
        ArrayList<String> files = new ArrayList<String>(absoluteFiles.size());
        Iterator filesIterator = absoluteFiles.iterator();
        while (filesIterator.hasNext()) {
            File file = (File)filesIterator.next();
            String filePath = StringUtils.prechomp((String)file.getAbsolutePath(), (String)(basedir.getAbsolutePath() + File.separator));
            String minusSrc = StringUtils.prechomp((String)filePath, (String)("src" + File.separator));
            for (int i = 0; i < languagesArray.length; ++i) {
                String language = languagesArray[i];
                if (StringUtils.countMatches((String)minusSrc, (String)(File.separator + language + File.separator)) <= 0) continue;
                String minusLanguage = StringUtils.prechomp((String)minusSrc, (String)(language + File.separator));
                files.add(this.toUnixPath(minusLanguage));
            }
        }
        this.getLogger().debug("Found " + files.size() + " archetype files for package resolution ");
        return files;
    }

    private String resolvePackage(List files) {
        String packageName = null;
        Iterator minusLanguageIterator = files.iterator();
        while (minusLanguageIterator.hasNext()) {
            String minusLanguage = (String)minusLanguageIterator.next();
            String filePackage = minusLanguage.indexOf("/") >= 0 ? StringUtils.replace((String)minusLanguage.substring(0, minusLanguage.lastIndexOf("/")), (String)"/", (String)".") : "";
            if (packageName == null) {
                packageName = filePackage;
                continue;
            }
            packageName = this.getCommonPackage(packageName, filePackage);
        }
        this.getLogger().debug("Package resolved to " + packageName);
        return packageName;
    }

    private String toUnixPath(String path) {
        return path.replace(File.separatorChar, '/');
    }
}

