/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.BlockInfo;
import org.jetbrains.kotlin.cfg.BreakableBlockInfo;
import org.jetbrains.kotlin.cfg.ControlFlowBuilder;
import org.jetbrains.kotlin.cfg.ControlFlowBuilderAdapter;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.pseudocode.ControlFlowInstructionsGenerator;
import org.jetbrains.kotlin.cfg.pseudocode.ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker$WhenMappings;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValueFactoryImpl;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.LexicalScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.LoadUnitValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.OperationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnNoValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ThrowExceptionInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.UnconditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.MarkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\f\u0010\u001c\u001a\u00060\tR\u00020\u0000H\u0002J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator;", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilderAdapter;", "()V", "allBlocks", "Lcom/intellij/util/containers/Stack;", "Lorg/jetbrains/kotlin/cfg/BlockInfo;", "builder", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "builders", "Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker;", "delegateBuilder", "getDelegateBuilder", "()Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "elementToBlockInfo", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/cfg/BreakableBlockInfo;", "labelCount", "", "lexicalScopes", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/LexicalScope;", "loopInfo", "Lorg/jetbrains/kotlin/cfg/LoopInfo;", "enterSubroutine", "", "subroutine", "exitSubroutine", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "popBuilder", "pushBuilder", "scopingElement", "ControlFlowInstructionsGeneratorWorker", "TryFinallyBlockInfo", "frontend"})
public final class ControlFlowInstructionsGenerator
extends ControlFlowBuilderAdapter {
    private ControlFlowBuilder builder;
    private final Stack<LoopInfo> loopInfo = new Stack();
    private final Stack<LexicalScope> lexicalScopes = new Stack();
    private final HashMap<KtElement, BreakableBlockInfo> elementToBlockInfo = new HashMap();
    private int labelCount;
    private final Stack<ControlFlowInstructionsGeneratorWorker> builders = new Stack();
    private final Stack<BlockInfo> allBlocks = new Stack();

    @Override
    @NotNull
    protected ControlFlowBuilder getDelegateBuilder() {
        ControlFlowBuilder controlFlowBuilder = this.builder;
        if (controlFlowBuilder == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Builder stack is empty in ControlFlowInstructionsGenerator!"));
        }
        return controlFlowBuilder;
    }

    private final void pushBuilder(KtElement scopingElement, KtElement subroutine) {
        ControlFlowInstructionsGeneratorWorker worker2 = new ControlFlowInstructionsGeneratorWorker(scopingElement, subroutine);
        this.builders.push((Object)worker2);
        this.builder = worker2;
    }

    private final ControlFlowInstructionsGeneratorWorker popBuilder() {
        ControlFlowInstructionsGeneratorWorker worker2 = (ControlFlowInstructionsGeneratorWorker)this.builders.pop();
        this.builder = !this.builders.isEmpty() ? (ControlFlowBuilder)this.builders.peek() : (ControlFlowBuilder)null;
        ControlFlowInstructionsGeneratorWorker controlFlowInstructionsGeneratorWorker = worker2;
        Intrinsics.checkExpressionValueIsNotNull((Object)controlFlowInstructionsGeneratorWorker, (String)"worker");
        return controlFlowInstructionsGeneratorWorker;
    }

    @Override
    public void enterSubroutine(@NotNull KtElement subroutine) {
        Intrinsics.checkParameterIsNotNull((Object)subroutine, (String)"subroutine");
        ControlFlowBuilder builder = this.builder;
        if (builder != null && subroutine instanceof KtFunctionLiteral) {
            this.pushBuilder(subroutine, builder.getReturnSubroutine());
        } else {
            this.pushBuilder(subroutine, subroutine);
        }
        this.getDelegateBuilder().enterLexicalScope(subroutine);
        this.getDelegateBuilder().enterSubroutine(subroutine);
    }

    @Override
    @NotNull
    public Pseudocode exitSubroutine(@NotNull KtElement subroutine) {
        Intrinsics.checkParameterIsNotNull((Object)subroutine, (String)"subroutine");
        super.exitSubroutine(subroutine);
        this.getDelegateBuilder().exitLexicalScope(subroutine);
        ControlFlowInstructionsGeneratorWorker worker2 = this.popBuilder();
        if (!this.builders.empty()) {
            ControlFlowInstructionsGeneratorWorker builder = (ControlFlowInstructionsGeneratorWorker)this.builders.peek();
            builder.declareFunction(subroutine, worker2.getPseudocode());
        }
        return worker2.getPseudocode();
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u008b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000*\u0001\u001a\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0012H\u0016J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0016JD\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00032\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020-0,2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020/0,H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002012\u0006\u00102\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u0012H\u0016J\u0010\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u000208H\u0016J\u0018\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u00102\u001a\u00020\u0007H\u0016J\u0010\u0010E\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u0007H\u0016J\u0010\u0010F\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0010\u0010G\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010K\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u0007H\u0016J\u0010\u0010L\u001a\u00020;2\u0006\u0010:\u001a\u00020\u0003H\u0016J\b\u0010M\u001a\u00020\u001dH\u0016J\u0014\u0010N\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010O\u001a\u00020\u00122\u0006\u0010P\u001a\u00020\u0003H\u0016J\u0012\u0010Q\u001a\u0004\u0018\u00010\u00122\u0006\u0010P\u001a\u00020\u0003H\u0016J\u0010\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020\u001d2\u0006\u0010W\u001a\u00020\u0012H\u0002J\u0018\u0010X\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0003H\u0016J\"\u0010Y\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00032\b\u0010Z\u001a\u0004\u0018\u00010$H\u0016J\"\u0010[\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00032\b\u0010Z\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010\\\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u001e\u0010]\u001a\u0002012\u0006\u00102\u001a\u00020^2\f\u0010_\u001a\b\u0012\u0002\b\u0003\u0018\u00010`H\u0016J\u001e\u0010a\u001a\u0002012\u0006\u00102\u001a\u00020b2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020$0dH\u0016J\u0010\u0010e\u001a\u00020\u001d2\u0006\u00102\u001a\u00020^H\u0016J0\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010\u00032\f\u0010c\u001a\b\u0012\u0004\u0012\u00020$0d2\u0006\u0010i\u001a\u00020SH\u0016J\u0010\u0010j\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u001e\u0010k\u001a\u00020l2\u0006\u00102\u001a\u00020^2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020$0dH\u0016J\u0012\u0010m\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0003H\u0016J\u001e\u0010n\u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120d2\u0006\u0010%\u001a\u00020\u0003H\u0016J\"\u0010n\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00032\b\u0010o\u001a\u0004\u0018\u00010$H\u0016J&\u0010p\u001a\u00020q2\u0006\u00102\u001a\u00020^2\u0006\u0010T\u001a\u00020U2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020$0dH\u0016J6\u0010r\u001a\u00020s2\u0006\u00102\u001a\u00020^2\u000e\b\u0002\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010*2\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020-0,H\u0002J0\u0010t\u001a\u00020s2\u0006\u00102\u001a\u00020^2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020-0,H\u0016J\u0018\u0010u\u001a\u00020\u001d2\u0006\u0010v\u001a\u00020\u00122\u0006\u0010w\u001a\u00020\u0012H\u0016J\u0018\u0010x\u001a\u00020\u001d2\u0006\u0010y\u001a\u00020z2\u0006\u0010:\u001a\u00020\u0003H\u0016J \u0010{\u001a\u00020\u001d2\u0006\u0010y\u001a\u00020^2\u0006\u0010{\u001a\u00020$2\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010|\u001a\u00020\u001d2\u0006\u0010}\u001a\u00020~2\u0006\u0010\u007f\u001a\u00020$H\u0016JB\u0010\u0080\u0001\u001a\u00020\u001d2\u0007\u0010\u0081\u0001\u001a\u00020\u00032\u0007\u0010\u0082\u0001\u001a\u00020\u00032\u0007\u0010\u0083\u0001\u001a\u00020$2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020-0,H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006\u0086\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker;", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "scopingElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "returnSubroutine", "(Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtElement;)V", "currentLoop", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "getCurrentLoop", "()Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "currentScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/LexicalScope;", "getCurrentScope", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/LexicalScope;", "currentSubroutine", "getCurrentSubroutine", "()Lorg/jetbrains/kotlin/psi/KtElement;", "error", "Lorg/jetbrains/kotlin/cfg/Label;", "pseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "getPseudocode", "()Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "getReturnSubroutine", "sink", "valueFactory", "org/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker$valueFactory$1", "Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker$valueFactory$1;", "add", "", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "bindLabel", "label", "bindValue", "value", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "element", "call", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/CallInstruction;", "valueElement", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiverValues", "", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "arguments", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "createAnonymousObject", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/InstructionWithValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "createLambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "createUnboundLabel", "name", "", "declareFunction", "subroutine", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "declareParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "declareVariable", "property", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "enterLexicalScope", "enterLoop", "Lorg/jetbrains/kotlin/cfg/LoopInfo;", "enterLoopBody", "enterSubroutine", "enterTryFinally", "trigger", "Lorg/jetbrains/kotlin/cfg/GenerationTrigger;", "exitLexicalScope", "exitLoopBody", "exitSubroutine", "exitTryFinally", "getBoundValue", "getConditionEntryPoint", "labelElement", "getExitPoint", "getMagicKind", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicKind;", "operation", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder$PredefinedOperation;", "handleJumpInsideTryFinally", "jumpTarget", "jump", "jumpOnFalse", "conditionValue", "jumpOnTrue", "jumpToError", "loadConstant", "Lorg/jetbrains/kotlin/psi/KtExpression;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "loadStringTemplate", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "inputValues", "", "loadUnit", "magic", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicInstruction;", "instructionElement", "kind", "mark", "merge", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MergeInstruction;", "newValue", "nondeterministicJump", "inputValue", "predefinedOperation", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/OperationInstruction;", "read", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/ReadValueInstruction;", "readVariable", "repeatPseudocode", "startLabel", "finishLabel", "returnNoValue", "returnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "returnValue", "throwException", "throwExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "thrownValue", "write", "assignment", "lValue", "rValue", "target", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/AccessTarget;", "frontend"})
    private final class ControlFlowInstructionsGeneratorWorker
    implements ControlFlowBuilder {
        @NotNull
        private final PseudocodeImpl pseudocode;
        private final Label error;
        private final Label sink;
        private final valueFactory.1 valueFactory;
        @NotNull
        private final KtElement returnSubroutine;

        @NotNull
        public final PseudocodeImpl getPseudocode() {
            return this.pseudocode;
        }

        private final void add(Instruction instruction) {
            this.pseudocode.addInstruction(instruction);
        }

        @Override
        @NotNull
        public Label createUnboundLabel() {
            StringBuilder stringBuilder = new StringBuilder().append("L");
            ControlFlowInstructionsGenerator controlFlowInstructionsGenerator = ControlFlowInstructionsGenerator.this;
            int n = controlFlowInstructionsGenerator.labelCount;
            controlFlowInstructionsGenerator.labelCount = n + 1;
            return this.pseudocode.createLabel(stringBuilder.append(n).toString(), null);
        }

        @Override
        @NotNull
        public Label createUnboundLabel(@NotNull String name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            StringBuilder stringBuilder = new StringBuilder().append("L");
            ControlFlowInstructionsGenerator controlFlowInstructionsGenerator = ControlFlowInstructionsGenerator.this;
            int n = controlFlowInstructionsGenerator.labelCount;
            controlFlowInstructionsGenerator.labelCount = n + 1;
            return this.pseudocode.createLabel(stringBuilder.append(n).toString(), name2);
        }

        @Override
        @NotNull
        public LoopInfo enterLoop(@NotNull KtLoopExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            LoopInfo info = new LoopInfo(expression2, this.createUnboundLabel("loop entry point"), this.createUnboundLabel("loop exit point"), this.createUnboundLabel("body entry point"), this.createUnboundLabel("body exit point"), this.createUnboundLabel("condition entry point"));
            Label label = info.getEntryPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label, (String)"info.entryPoint");
            this.bindLabel(label);
            ControlFlowInstructionsGenerator.this.elementToBlockInfo.put(expression2, info);
            return info;
        }

        @Override
        public void enterLoopBody(@NotNull KtLoopExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Object v = ControlFlowInstructionsGenerator.this.elementToBlockInfo.get(expression2);
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.LoopInfo");
            }
            LoopInfo info = (LoopInfo)v;
            Label label = info.getBodyEntryPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label, (String)"info.bodyEntryPoint");
            this.bindLabel(label);
            ControlFlowInstructionsGenerator.this.loopInfo.push((Object)info);
            ControlFlowInstructionsGenerator.this.allBlocks.push((Object)info);
        }

        @Override
        public void exitLoopBody(@NotNull KtLoopExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            LoopInfo info = (LoopInfo)ControlFlowInstructionsGenerator.this.loopInfo.pop();
            ControlFlowInstructionsGenerator.this.elementToBlockInfo.remove(expression2);
            ControlFlowInstructionsGenerator.this.allBlocks.pop();
            Label label = info.getBodyExitPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label, (String)"info.bodyExitPoint");
            this.bindLabel(label);
        }

        @Override
        @Nullable
        public KtLoopExpression getCurrentLoop() {
            return ControlFlowInstructionsGenerator.this.loopInfo.empty() ? (KtLoopExpression)null : ((LoopInfo)ControlFlowInstructionsGenerator.this.loopInfo.peek()).getElement();
        }

        @Override
        public void enterSubroutine(@NotNull KtElement subroutine) {
            Intrinsics.checkParameterIsNotNull((Object)subroutine, (String)"subroutine");
            BreakableBlockInfo blockInfo = new BreakableBlockInfo(subroutine, this.createUnboundLabel(), this.createUnboundLabel());
            ControlFlowInstructionsGenerator.this.elementToBlockInfo.put(subroutine, blockInfo);
            ControlFlowInstructionsGenerator.this.allBlocks.push((Object)blockInfo);
            Label label = blockInfo.getEntryPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label, (String)"blockInfo.entryPoint");
            this.bindLabel(label);
            this.add(new SubroutineEnterInstruction(subroutine, this.getCurrentScope()));
        }

        @Override
        @NotNull
        public KtElement getCurrentSubroutine() {
            return this.pseudocode.getCorrespondingElement();
        }

        @Override
        @NotNull
        public Label getConditionEntryPoint(@NotNull KtElement labelElement) {
            Unit unit;
            Intrinsics.checkParameterIsNotNull((Object)labelElement, (String)"labelElement");
            BreakableBlockInfo blockInfo = (BreakableBlockInfo)ControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement);
            boolean value$iv = blockInfo instanceof LoopInfo;
            if (_Assertions.ENABLED) {
                if (!value$iv) {
                    String message$iv = "expected LoopInfo for " + labelElement.getText();
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            BreakableBlockInfo breakableBlockInfo = blockInfo;
            if (breakableBlockInfo == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.LoopInfo");
            }
            Label label = ((LoopInfo)breakableBlockInfo).getConditionEntryPoint();
            Intrinsics.checkExpressionValueIsNotNull((Object)label, (String)"(blockInfo as LoopInfo).conditionEntryPoint");
            return label;
        }

        @Override
        @Nullable
        public Label getExitPoint(@NotNull KtElement labelElement) {
            Intrinsics.checkParameterIsNotNull((Object)labelElement, (String)"labelElement");
            BreakableBlockInfo breakableBlockInfo = (BreakableBlockInfo)ControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement);
            return breakableBlockInfo != null ? breakableBlockInfo.getExitPoint() : null;
        }

        private final LexicalScope getCurrentScope() {
            LexicalScope lexicalScope = (LexicalScope)ControlFlowInstructionsGenerator.this.lexicalScopes.peek();
            Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"lexicalScopes.peek()");
            return lexicalScope;
        }

        @Override
        public void enterLexicalScope(@NotNull KtElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            LexicalScope current = ControlFlowInstructionsGenerator.this.lexicalScopes.isEmpty() ? (LexicalScope)null : this.getCurrentScope();
            LexicalScope scope2 = new LexicalScope(current, element2);
            ControlFlowInstructionsGenerator.this.lexicalScopes.push((Object)scope2);
        }

        @Override
        public void exitLexicalScope(@NotNull KtElement element2) {
            Unit unit;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            LexicalScope currentScope = this.getCurrentScope();
            boolean value$iv = currentScope.getElement() == element2;
            if (_Assertions.ENABLED) {
                if (!value$iv) {
                    String message$iv = "Exit from not the current lexical scope.\n" + "Current scope is for: " + currentScope.getElement() + ".\n" + "Exit from the scope for: " + element2.getText();
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            ControlFlowInstructionsGenerator.this.lexicalScopes.pop();
        }

        /*
         * WARNING - void declaration
         */
        private final void handleJumpInsideTryFinally(Label jumpTarget) {
            ArrayList<BlockInfo> finallyBlocks = new ArrayList<BlockInfo>();
            IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)((Collection)ControlFlowInstructionsGenerator.this.allBlocks))));
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                block0: while (true) {
                    void i;
                    BlockInfo blockInfo;
                    if ((blockInfo = (BlockInfo)ControlFlowInstructionsGenerator.this.allBlocks.get((int)i)) instanceof BreakableBlockInfo) {
                        if (((BreakableBlockInfo)blockInfo).getReferablePoints().contains(jumpTarget) || jumpTarget == this.error) {
                            IntProgression intProgression2 = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)finallyBlocks)));
                            int n6 = intProgression2.getFirst();
                            int n7 = intProgression2.getLast();
                            int n8 = intProgression2.getStep();
                            int n9 = n6;
                            int n10 = n7;
                            if (!(n8 > 0 ? n9 <= n10 : n9 >= n10)) break;
                            while (true) {
                                void j;
                                ((TryFinallyBlockInfo)finallyBlocks.get((int)j)).generateFinallyBlock();
                                if (j == n7) break block0;
                                j += n8;
                            }
                        }
                    } else if (blockInfo instanceof TryFinallyBlockInfo) {
                        finallyBlocks.add(blockInfo);
                    }
                    if (i == n2) break;
                    n = i + n3;
                }
            }
        }

        @Override
        @NotNull
        public Pseudocode exitSubroutine(@NotNull KtElement subroutine) {
            Unit unit;
            Intrinsics.checkParameterIsNotNull((Object)subroutine, (String)"subroutine");
            Label label = this.getExitPoint(subroutine);
            if (label != null) {
                Label $receiver$iv = label;
                Label it = $receiver$iv;
                this.bindLabel(it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            this.pseudocode.addExitInstruction(new SubroutineExitInstruction(subroutine, this.getCurrentScope(), false));
            this.bindLabel(this.error);
            this.pseudocode.addErrorInstruction(new SubroutineExitInstruction(subroutine, this.getCurrentScope(), true));
            this.bindLabel(this.sink);
            this.pseudocode.addSinkInstruction(new SubroutineSinkInstruction(subroutine, this.getCurrentScope(), "<SINK>"));
            ControlFlowInstructionsGenerator.this.elementToBlockInfo.remove(subroutine);
            ControlFlowInstructionsGenerator.this.allBlocks.pop();
            return this.pseudocode;
        }

        @Override
        public void mark(@NotNull KtElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.add(new MarkInstruction(element2, this.getCurrentScope()));
        }

        @Override
        @Nullable
        public PseudoValue getBoundValue(@Nullable KtElement element2) {
            return this.pseudocode.getElementValue(element2);
        }

        @Override
        public void bindValue(@NotNull PseudoValue value2, @NotNull KtElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.pseudocode.bindElementToValue(element2, value2);
        }

        @Override
        @NotNull
        public PseudoValue newValue(@Nullable KtElement element2) {
            return this.valueFactory.newValue(element2, null);
        }

        @Override
        public void returnValue(@NotNull KtExpression returnExpression, @NotNull PseudoValue returnValue, @NotNull KtElement subroutine) {
            Intrinsics.checkParameterIsNotNull((Object)returnExpression, (String)"returnExpression");
            Intrinsics.checkParameterIsNotNull((Object)returnValue, (String)"returnValue");
            Intrinsics.checkParameterIsNotNull((Object)subroutine, (String)"subroutine");
            Label label = this.getExitPoint(subroutine);
            if (label == null) {
                return;
            }
            Label exitPoint = label;
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnValueInstruction(returnExpression, this.getCurrentScope(), exitPoint, returnValue));
        }

        @Override
        public void returnNoValue(@NotNull KtReturnExpression returnExpression, @NotNull KtElement subroutine) {
            Intrinsics.checkParameterIsNotNull((Object)returnExpression, (String)"returnExpression");
            Intrinsics.checkParameterIsNotNull((Object)subroutine, (String)"subroutine");
            Label label = this.getExitPoint(subroutine);
            if (label == null) {
                return;
            }
            Label exitPoint = label;
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnNoValueInstruction((KtElement)returnExpression, this.getCurrentScope(), exitPoint));
        }

        @Override
        public void write(@NotNull KtElement assignment, @NotNull KtElement lValue, @NotNull PseudoValue rValue, @NotNull AccessTarget target, @NotNull Map<PseudoValue, ? extends ReceiverValue> receiverValues) {
            Intrinsics.checkParameterIsNotNull((Object)assignment, (String)"assignment");
            Intrinsics.checkParameterIsNotNull((Object)lValue, (String)"lValue");
            Intrinsics.checkParameterIsNotNull((Object)rValue, (String)"rValue");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            Intrinsics.checkParameterIsNotNull(receiverValues, (String)"receiverValues");
            this.add(new WriteValueInstruction(assignment, this.getCurrentScope(), target, receiverValues, lValue, rValue));
        }

        @Override
        public void declareParameter(@NotNull KtParameter parameter) {
            Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
            this.add(new VariableDeclarationInstruction(parameter, this.getCurrentScope()));
        }

        @Override
        public void declareVariable(@NotNull KtVariableDeclaration property2) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            this.add(new VariableDeclarationInstruction(property2, this.getCurrentScope()));
        }

        @Override
        public void declareFunction(@NotNull KtElement subroutine, @NotNull Pseudocode pseudocode2) {
            Intrinsics.checkParameterIsNotNull((Object)subroutine, (String)"subroutine");
            Intrinsics.checkParameterIsNotNull((Object)pseudocode2, (String)"pseudocode");
            this.add(new LocalFunctionDeclarationInstruction(subroutine, pseudocode2, this.getCurrentScope()));
        }

        @Override
        public void loadUnit(@NotNull KtExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.add(new LoadUnitValueInstruction(expression2, this.getCurrentScope()));
        }

        @Override
        public void jump(@NotNull Label label, @NotNull KtElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.handleJumpInsideTryFinally(label);
            this.add(new UnconditionalJumpInstruction(element2, label, this.getCurrentScope()));
        }

        @Override
        public void jumpOnFalse(@NotNull Label label, @NotNull KtElement element2, @Nullable PseudoValue conditionValue) {
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(element2, false, this.getCurrentScope(), label, conditionValue));
        }

        @Override
        public void jumpOnTrue(@NotNull Label label, @NotNull KtElement element2, @Nullable PseudoValue conditionValue) {
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(element2, true, this.getCurrentScope(), label, conditionValue));
        }

        @Override
        public void bindLabel(@NotNull Label label) {
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            this.pseudocode.bindLabel(label);
        }

        @Override
        public void nondeterministicJump(@NotNull Label label, @NotNull KtElement element2, @Nullable PseudoValue inputValue) {
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.handleJumpInsideTryFinally(label);
            this.add(new NondeterministicJumpInstruction(element2, CollectionsKt.listOf((Object)label), this.getCurrentScope(), inputValue));
        }

        @Override
        public void nondeterministicJump(@NotNull List<? extends Label> label, @NotNull KtElement element2) {
            Intrinsics.checkParameterIsNotNull(label, (String)"label");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.add(new NondeterministicJumpInstruction(element2, label, this.getCurrentScope(), null));
        }

        @Override
        public void jumpToError(@NotNull KtElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.handleJumpInsideTryFinally(this.error);
            this.add(new UnconditionalJumpInstruction(element2, this.error, this.getCurrentScope()));
        }

        @Override
        public void enterTryFinally(@NotNull GenerationTrigger trigger) {
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            ControlFlowInstructionsGenerator.this.allBlocks.push((Object)new TryFinallyBlockInfo(trigger));
        }

        @Override
        public void throwException(@NotNull KtThrowExpression throwExpression, @NotNull PseudoValue thrownValue) {
            Intrinsics.checkParameterIsNotNull((Object)throwExpression, (String)"throwExpression");
            Intrinsics.checkParameterIsNotNull((Object)thrownValue, (String)"thrownValue");
            this.handleJumpInsideTryFinally(this.error);
            this.add(new ThrowExceptionInstruction(throwExpression, this.getCurrentScope(), this.error, thrownValue));
        }

        @Override
        public void exitTryFinally() {
            Unit unit;
            BlockInfo pop2 = (BlockInfo)ControlFlowInstructionsGenerator.this.allBlocks.pop();
            boolean value$iv = pop2 instanceof TryFinallyBlockInfo;
            if (_Assertions.ENABLED) {
                if (!value$iv) {
                    String message$iv$iv = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
        }

        @Override
        public void repeatPseudocode(@NotNull Label startLabel, @NotNull Label finishLabel) {
            Intrinsics.checkParameterIsNotNull((Object)startLabel, (String)"startLabel");
            Intrinsics.checkParameterIsNotNull((Object)finishLabel, (String)"finishLabel");
            ControlFlowInstructionsGenerator.this.labelCount = this.pseudocode.repeatPart(startLabel, finishLabel, ControlFlowInstructionsGenerator.this.labelCount);
        }

        @Override
        @NotNull
        public InstructionWithValue loadConstant(@NotNull KtExpression expression2, @Nullable CompileTimeConstant<?> constant) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return ControlFlowInstructionsGeneratorWorker.read$default(this, expression2, null, null, 6, null);
        }

        @Override
        @NotNull
        public InstructionWithValue createAnonymousObject(@NotNull KtObjectLiteralExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return ControlFlowInstructionsGeneratorWorker.read$default(this, expression2, null, null, 6, null);
        }

        @Override
        @NotNull
        public InstructionWithValue createLambda(@NotNull KtFunction expression2) {
            KtExpression ktExpression;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            if (expression2 instanceof KtFunctionLiteral) {
                PsiElement psiElement = expression2.getParent();
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLambdaExpression");
                }
                ktExpression = (KtLambdaExpression)psiElement;
            } else {
                ktExpression = expression2;
            }
            return ControlFlowInstructionsGeneratorWorker.read$default(this, ktExpression, null, null, 6, null);
        }

        @Override
        @NotNull
        public InstructionWithValue loadStringTemplate(@NotNull KtStringTemplateExpression expression2, @NotNull List<? extends PseudoValue> inputValues) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull(inputValues, (String)"inputValues");
            return inputValues.isEmpty() ? (InstructionWithValue)ControlFlowInstructionsGeneratorWorker.read$default(this, expression2, null, null, 6, null) : (InstructionWithValue)this.magic(expression2, expression2, inputValues, MagicKind.STRING_TEMPLATE);
        }

        @Override
        @NotNull
        public MagicInstruction magic(@NotNull KtElement instructionElement, @Nullable KtElement valueElement, @NotNull List<? extends PseudoValue> inputValues, @NotNull MagicKind kind2) {
            Intrinsics.checkParameterIsNotNull((Object)instructionElement, (String)"instructionElement");
            Intrinsics.checkParameterIsNotNull(inputValues, (String)"inputValues");
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind2), (String)"kind");
            MagicInstruction instruction = new MagicInstruction(instructionElement, valueElement, this.getCurrentScope(), inputValues, kind2, this.valueFactory);
            this.add(instruction);
            return instruction;
        }

        @Override
        @NotNull
        public MergeInstruction merge(@NotNull KtExpression expression2, @NotNull List<? extends PseudoValue> inputValues) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull(inputValues, (String)"inputValues");
            MergeInstruction instruction = new MergeInstruction(expression2, this.getCurrentScope(), inputValues, this.valueFactory);
            this.add(instruction);
            return instruction;
        }

        @Override
        @NotNull
        public ReadValueInstruction readVariable(@NotNull KtExpression expression2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull Map<PseudoValue, ? extends ReceiverValue> receiverValues) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull(receiverValues, (String)"receiverValues");
            return this.read(expression2, resolvedCall2, receiverValues);
        }

        @Override
        @NotNull
        public CallInstruction call(@NotNull KtElement valueElement, @NotNull ResolvedCall<?> resolvedCall2, @NotNull Map<PseudoValue, ? extends ReceiverValue> receiverValues, @NotNull Map<PseudoValue, ? extends ValueParameterDescriptor> arguments2) {
            Intrinsics.checkParameterIsNotNull((Object)valueElement, (String)"valueElement");
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull(receiverValues, (String)"receiverValues");
            Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
            KotlinType returnType2 = resolvedCall2.getResultingDescriptor().getReturnType();
            CallInstruction instruction = new CallInstruction(valueElement, this.getCurrentScope(), resolvedCall2, receiverValues, arguments2, returnType2 != null && KotlinBuiltIns.isNothing(returnType2) ? null : this.valueFactory);
            this.add(instruction);
            return instruction;
        }

        @Override
        @NotNull
        public OperationInstruction predefinedOperation(@NotNull KtExpression expression2, @NotNull ControlFlowBuilder.PredefinedOperation operation, @NotNull List<? extends PseudoValue> inputValues) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)((Object)operation), (String)"operation");
            Intrinsics.checkParameterIsNotNull(inputValues, (String)"inputValues");
            return this.magic(expression2, expression2, inputValues, this.getMagicKind(operation));
        }

        private final MagicKind getMagicKind(ControlFlowBuilder.PredefinedOperation operation) {
            switch (ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker$WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
                case 1: {
                    return MagicKind.AND;
                }
                case 2: {
                    return MagicKind.OR;
                }
                case 3: {
                    return MagicKind.NOT_NULL_ASSERTION;
                }
            }
            throw (Throwable)new IllegalArgumentException("Invalid operation: " + (Object)((Object)operation));
        }

        private final ReadValueInstruction read(KtExpression expression2, ResolvedCall<?> resolvedCall2, Map<PseudoValue, ? extends ReceiverValue> receiverValues) {
            AccessTarget accessTarget = resolvedCall2 != null ? (AccessTarget)new AccessTarget.Call(resolvedCall2) : (AccessTarget)AccessTarget.BlackBox.INSTANCE;
            ReadValueInstruction instruction = new ReadValueInstruction((KtElement)expression2, this.getCurrentScope(), accessTarget, receiverValues, this.valueFactory);
            this.add(instruction);
            return instruction;
        }

        static /* bridge */ /* synthetic */ ReadValueInstruction read$default(ControlFlowInstructionsGeneratorWorker controlFlowInstructionsGeneratorWorker, KtExpression ktExpression, ResolvedCall resolvedCall2, Map map2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
            }
            if ((n & 2) != 0) {
                resolvedCall2 = null;
            }
            if ((n & 4) != 0) {
                map2 = MapsKt.emptyMap();
            }
            return controlFlowInstructionsGeneratorWorker.read(ktExpression, resolvedCall2, map2);
        }

        @Override
        @NotNull
        public KtElement getReturnSubroutine() {
            return this.returnSubroutine;
        }

        public ControlFlowInstructionsGeneratorWorker(@NotNull KtElement scopingElement, KtElement returnSubroutine) {
            Intrinsics.checkParameterIsNotNull((Object)scopingElement, (String)"scopingElement");
            Intrinsics.checkParameterIsNotNull((Object)returnSubroutine, (String)"returnSubroutine");
            this.returnSubroutine = returnSubroutine;
            this.valueFactory = new PseudoValueFactoryImpl(this){
                final /* synthetic */ ControlFlowInstructionsGeneratorWorker this$0;

                @NotNull
                public PseudoValue newValue(@Nullable KtElement element2, @Nullable InstructionWithValue instruction) {
                    PseudoValue value2 = super.newValue(element2, instruction);
                    if (element2 != null) {
                        this.this$0.bindValue(value2, element2);
                    }
                    return value2;
                }
                {
                    this.this$0 = $outer;
                }
            };
            this.pseudocode = new PseudocodeImpl(scopingElement);
            this.error = this.pseudocode.createLabel("error", null);
            this.sink = this.pseudocode.createLabel("sink", null);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$TryFinallyBlockInfo;", "Lorg/jetbrains/kotlin/cfg/BlockInfo;", "finallyBlock", "Lorg/jetbrains/kotlin/cfg/GenerationTrigger;", "(Lorg/jetbrains/kotlin/cfg/GenerationTrigger;)V", "generateFinallyBlock", "", "frontend"})
    private static final class TryFinallyBlockInfo
    extends BlockInfo {
        private final GenerationTrigger finallyBlock;

        public final void generateFinallyBlock() {
            this.finallyBlock.generate();
        }

        public TryFinallyBlockInfo(@NotNull GenerationTrigger finallyBlock) {
            Intrinsics.checkParameterIsNotNull((Object)finallyBlock, (String)"finallyBlock");
            this.finallyBlock = finallyBlock;
        }
    }
}

