/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J.\u0010\r\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "appendDescriptors", "", "node", "Lcom/intellij/lang/ASTNode;", "document", "Lcom/intellij/openapi/editor/Document;", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "buildLanguageFoldRegions", "root", "Lcom/intellij/psi/PsiElement;", "quick", "", "getLanguagePlaceholderText", "", "range", "Lcom/intellij/openapi/util/TextRange;", "getRangeToFold", "isCustomFoldingRoot", "isFirstElementInFile", "element", "isOneLine", "textRange", "isRegionCollapsedByDefault", "needFolding", "idea"})
public final class KotlinFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        if (!(root instanceof KtFile)) {
            return;
        }
        List<KtImportDirective> imports = ((KtFile)root).getImportDirectives();
        if (imports.size() > 1) {
            PsiElement importKeyword = imports.get(0).getFirstChild();
            int startOffset = PsiUtilsKt.getEndOffset(importKeyword) + 1;
            KtImportList importList = ((KtFile)root).getImportList();
            if (importList != null) {
                int endOffset = PsiUtilsKt.getEndOffset((PsiElement)importList);
                TextRange range = new TextRange(startOffset, endOffset);
                descriptors.add(new FoldingDescriptor((PsiElement)importList, range));
            }
        }
        ASTNode aSTNode = (ASTNode)((KtFile)root).getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"root.node");
        this.appendDescriptors(aSTNode, document, descriptors);
    }

    private final void appendDescriptors(ASTNode node, Document document, List<FoldingDescriptor> descriptors) {
        TextRange textRange;
        if (this.needFolding(node) && !this.isOneLine(textRange = this.getRangeToFold(node), document)) {
            descriptors.add(new FoldingDescriptor(node, textRange));
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            this.appendDescriptors(child, document, descriptors);
        }
    }

    private final boolean needFolding(ASTNode node) {
        IElementType type2 = node.getElementType();
        ASTNode aSTNode = node.getTreeParent();
        IElementType parentType = aSTNode != null ? aSTNode.getElementType() : null;
        return Intrinsics.areEqual((Object)type2, (Object)((Object)KtNodeTypes.FUNCTION_LITERAL)) || Intrinsics.areEqual((Object)type2, (Object)((Object)KtNodeTypes.BLOCK)) && Intrinsics.areEqual((Object)parentType, (Object)((Object)KtNodeTypes.FUNCTION_LITERAL)) ^ true || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.CLASS_BODY) || Intrinsics.areEqual((Object)type2, (Object)((Object)KtTokens.BLOCK_COMMENT)) || Intrinsics.areEqual((Object)type2, (Object)KDocTokens.KDOC);
    }

    private final TextRange getRangeToFold(ASTNode node) {
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)KtNodeTypes.FUNCTION_LITERAL))) {
            PsiElement rbrace;
            KtFunctionLiteral psi;
            PsiElement psiElement = node.getPsi();
            if (!(psiElement instanceof KtFunctionLiteral)) {
                psiElement = null;
            }
            KtFunctionLiteral ktFunctionLiteral = psi = (KtFunctionLiteral)psiElement;
            PsiElement lbrace = ktFunctionLiteral != null ? ktFunctionLiteral.getLBrace() : null;
            KtFunctionLiteral ktFunctionLiteral2 = psi;
            Object object = rbrace = ktFunctionLiteral2 != null ? ktFunctionLiteral2.getRBrace() : null;
            if (lbrace != null && rbrace != null) {
                return new TextRange(PsiUtilsKt.getStartOffset(lbrace), PsiUtilsKt.getEndOffset(rbrace));
            }
        }
        TextRange textRange = node.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"node.textRange");
        return textRange;
    }

    private final boolean isOneLine(TextRange textRange, Document document) {
        return document.getLineNumber(textRange.getStartOffset()) == document.getLineNumber(textRange.getEndOffset());
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        return Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)KtTokens.BLOCK_COMMENT)) ? "/.../" : (Intrinsics.areEqual((Object)node.getElementType(), (Object)KDocTokens.KDOC) ? "/**...*/" : (node.getPsi() instanceof KtImportList ? "..." : "{...}"));
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        if (node.getPsi() instanceof KtImportList) {
            return settings.isCollapseImports();
        }
        IElementType type2 = node.getElementType();
        if (Intrinsics.areEqual((Object)type2, (Object)((Object)KtTokens.BLOCK_COMMENT)) || Intrinsics.areEqual((Object)type2, (Object)KDocTokens.KDOC)) {
            PsiElement psiElement = node.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"node.psi");
            if (this.isFirstElementInFile(psiElement)) {
                return settings.isCollapseFileHeader();
            }
        }
        return false;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)KtNodeTypes.BLOCK)) || Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.CLASS_BODY);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isFirstElementInFile(PsiElement element2) {
        PsiElement parent2 = element2.getParent();
        if (parent2 instanceof KtFile) {
            Object v0;
            block2: {
                void $receiver$iv;
                Sequence sequence2 = PsiUtilsKt.getAllChildren(parent2);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(it.getTextLength() != 0 && !(it instanceof PsiWhiteSpace))) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            PsiElement firstNonWhiteSpace = v0;
            return Intrinsics.areEqual((Object)element2, (Object)firstNonWhiteSpace);
        }
        return false;
    }
}

