/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;

public class KotlinPairMatcher
implements PairedBraceMatcher {
    private final BracePair[] pairs = new BracePair[]{new BracePair((IElementType)KtTokens.LPAR, (IElementType)KtTokens.RPAR, false), new BracePair((IElementType)KtTokens.LONG_TEMPLATE_ENTRY_START, (IElementType)KtTokens.LONG_TEMPLATE_ENTRY_END, false), new BracePair((IElementType)KtTokens.LBRACE, (IElementType)KtTokens.RBRACE, true), new BracePair((IElementType)KtTokens.LBRACKET, (IElementType)KtTokens.RBRACKET, false)};

    public BracePair[] getPairs() {
        return this.pairs;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "org/jetbrains/kotlin/idea/KotlinPairMatcher", "isPairedBracesAllowedBeforeType"));
        }
        if (lbraceType.equals((Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
            return false;
        }
        return KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(contextType) || contextType == KtTokens.SEMICOLON || contextType == KtTokens.COMMA || contextType == KtTokens.RPAR || contextType == KtTokens.RBRACKET || contextType == KtTokens.RBRACE || contextType == KtTokens.LBRACE || contextType == KtTokens.LONG_TEMPLATE_ENTRY_END;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }
}

