/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a#\u0010\b\u001a\u00020\u0006*\u00020\u00022\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u001a \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u0013*\u00020\u0018\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u0013*\u00020\u0018\u00a8\u0006\u001a"}, d2={"analyze", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Lorg/jetbrains/kotlin/psi/KtElement;", "bodyResolveMode", "Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;", "analyzeAndGetResult", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "analyzeFully", "analyzeFullyAndGetResult", "extraFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtElement;[Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "findModuleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getResolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "resolveImportReference", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "moduleDescriptor", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "resolveToDescriptor", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "resolveToDescriptorIfAny", "ide-common"})
@JvmName(name="ResolutionUtils")
public final class ResolutionUtils {
    @NotNull
    public static final ResolutionFacade getResolutionFacade(KtElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return KotlinCacheService.Companion.getInstance(project).getResolutionFacade(CollectionsKt.listOf((Object)$receiver));
    }

    @NotNull
    public static final DeclarationDescriptor resolveToDescriptor(KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ResolutionUtils.getResolutionFacade($receiver).resolveToDescriptor($receiver);
    }

    @Nullable
    public static final DeclarationDescriptor resolveToDescriptorIfAny(KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL).get(BindingContext.DECLARATION_TO_DESCRIPTOR, $receiver);
    }

    @NotNull
    public static final Collection<DeclarationDescriptor> resolveImportReference(KtFile $receiver, @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        ResolutionFacade facade = ResolutionUtils.getResolutionFacade($receiver);
        return ResolutionUtils.resolveImportReference(facade, facade.getModuleDescriptor(), fqName2);
    }

    @JvmOverloads
    @NotNull
    public static final BindingContext analyze(KtElement $receiver, @NotNull BodyResolveMode bodyResolveMode) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)bodyResolveMode), (String)"bodyResolveMode");
        return ResolutionUtils.getResolutionFacade($receiver).analyze($receiver, bodyResolveMode);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ BindingContext analyze$default(KtElement ktElement, BodyResolveMode bodyResolveMode, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: analyze");
        }
        if ((n & 1) != 0) {
            bodyResolveMode = BodyResolveMode.FULL;
        }
        return ResolutionUtils.analyze(ktElement, bodyResolveMode);
    }

    @JvmOverloads
    @NotNull
    public static BindingContext analyze(KtElement $receiver) {
        return ResolutionUtils.analyze$default($receiver, null, 1, null);
    }

    @NotNull
    public static final AnalysisResult analyzeAndGetResult(KtElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade($receiver);
        return AnalysisResult.Companion.success(ResolutionFacade.DefaultImpls.analyze$default(resolutionFacade2, $receiver, null, 2, null), resolutionFacade2.getModuleDescriptor());
    }

    @NotNull
    public static final ModuleDescriptor findModuleDescriptor(KtElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ResolutionUtils.getResolutionFacade($receiver).getModuleDescriptor();
    }

    @NotNull
    public static final BindingContext analyzeFully(KtElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ResolutionUtils.analyzeFullyAndGetResult($receiver, new KtFile[0]).getBindingContext();
    }

    @NotNull
    public static final AnalysisResult analyzeFullyAndGetResult(KtElement $receiver, KtFile ... extraFiles) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)extraFiles, (String)"extraFiles");
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return KotlinCacheService.Companion.getInstance(project).getResolutionFacade(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$receiver), (Iterable)ArraysKt.toList((Object[])extraFiles))).analyzeFullyAndGetResult(CollectionsKt.listOf((Object)$receiver));
    }

    @NotNull
    public static final Collection<DeclarationDescriptor> resolveImportReference(ResolutionFacade $receiver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        KtImportDirective importDirective = new KtPsiFactory($receiver.getProject()).createImportDirective(new ImportPath(fqName2, false));
        QualifiedExpressionResolver qualifiedExpressionResolver = $receiver.getFrontendService(moduleDescriptor, QualifiedExpressionResolver.class);
        Object object = qualifiedExpressionResolver.processImportReference(importDirective, moduleDescriptor, new BindingTraceContext(), CollectionsKt.emptyList(), null);
        if (object == null || (object = ResolutionScope.DefaultImpls.getContributedDescriptors$default((ResolutionScope)object, null, null, 3, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }
}

