/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinUnwrapRemoveBase;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtValueArgument;

public class KotlinLambdaUnwrapper
extends KotlinUnwrapRemoveBase {
    public KotlinLambdaUnwrapper(String key) {
        super(key);
    }

    private static KtElement getLambdaEnclosingElement(@NotNull KtLambdaExpression lambda2) {
        if (lambda2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinLambdaUnwrapper", "getLambdaEnclosingElement"));
        }
        PsiElement parent2 = lambda2.getParent();
        if (parent2 instanceof KtValueArgument) {
            return (KtElement)PsiTreeUtil.getParentOfType((PsiElement)parent2, KtCallExpression.class, (boolean)true);
        }
        if (parent2 instanceof KtCallExpression) {
            return (KtElement)parent2;
        }
        if (parent2 instanceof KtProperty && ((KtProperty)parent2).isLocal()) {
            return (KtElement)parent2;
        }
        return lambda2;
    }

    public boolean isApplicableTo(PsiElement e) {
        if (!(e instanceof KtLambdaExpression)) {
            return false;
        }
        KtLambdaExpression lambda2 = (KtLambdaExpression)e;
        KtBlockExpression body2 = lambda2.getBodyExpression();
        KtElement enclosingElement = KotlinLambdaUnwrapper.getLambdaEnclosingElement((KtLambdaExpression)e);
        if (body2 == null || enclosingElement == null) {
            return false;
        }
        return this.canExtractExpression(body2, (KtElement)enclosingElement.getParent());
    }

    protected void doUnwrap(PsiElement element2, KotlinUnwrapRemoveBase.Context context) throws IncorrectOperationException {
        KtLambdaExpression lambda2 = (KtLambdaExpression)element2;
        KtBlockExpression body2 = lambda2.getBodyExpression();
        KtElement enclosingExpression = KotlinLambdaUnwrapper.getLambdaEnclosingElement(lambda2);
        context.extractFromBlock(body2, enclosingExpression);
        context.delete((PsiElement)enclosingExpression);
    }
}

