/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.google.common.base.Predicate;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.upDownMover.AbstractKotlinUpDownMover;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class KotlinExpressionMover
extends AbstractKotlinUpDownMover {
    private static final Predicate<KtElement> IS_CALL_EXPRESSION = new Predicate<KtElement>(){

        public boolean apply(@Nullable KtElement input) {
            return input instanceof KtCallExpression;
        }
    };
    private static final Class[] MOVABLE_ELEMENT_CLASSES = new Class[]{KtExpression.class, KtWhenEntry.class, KtValueArgument.class, PsiComment.class};
    private static final Function1<PsiElement, Boolean> MOVABLE_ELEMENT_CONSTRAINT = new Function1<PsiElement, Boolean>(){

        @NotNull
        public Boolean invoke(PsiElement element2) {
            Boolean bl = !(element2 instanceof KtExpression) || element2 instanceof KtDeclaration || element2 instanceof KtBlockExpression || element2.getParent() instanceof KtBlockExpression;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover$2", "invoke"));
            }
            return bl;
        }
    };
    private static final Class[] BLOCKLIKE_ELEMENT_CLASSES = new Class[]{KtBlockExpression.class, KtWhenExpression.class, KtClassBody.class, KtFile.class};
    private static final Class[] FUNCTIONLIKE_ELEMENT_CLASSES = new Class[]{KtFunction.class, KtPropertyAccessor.class, KtAnonymousInitializer.class};
    private static final Predicate<KtElement> CHECK_BLOCK_LIKE_ELEMENT = new Predicate<KtElement>(){

        public boolean apply(@Nullable KtElement input) {
            return (input instanceof KtBlockExpression || input instanceof KtClassBody) && !PsiTreeUtil.instanceOf((Object)input.getParent(), (Class[])FUNCTIONLIKE_ELEMENT_CLASSES);
        }
    };
    private static final Predicate<KtElement> CHECK_BLOCK = new Predicate<KtElement>(){

        public boolean apply(@Nullable KtElement input) {
            return input instanceof KtBlockExpression && !PsiTreeUtil.instanceOf((Object)input.getParent(), (Class[])FUNCTIONLIKE_ELEMENT_CLASSES);
        }
    };
    @Nullable
    private Pair<PsiElement, PsiElement> parametersOrArgsToMove;

    @Nullable
    private static PsiElement getStandaloneClosingBrace(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getStandaloneClosingBrace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getStandaloneClosingBrace"));
        }
        LineRange range = KotlinExpressionMover.getLineRangeFromSelection((Editor)editor);
        if (range.endLine - range.startLine != 1) {
            return null;
        }
        int offset2 = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int line = document.getLineNumber(offset2);
        int lineStartOffset = document.getLineStartOffset(line);
        String lineText = document.getText().substring(lineStartOffset, document.getLineEndOffset(line));
        if (!lineText.trim().equals("}")) {
            return null;
        }
        return file.findElementAt(lineStartOffset + lineText.indexOf(125));
    }

    private static BraceStatus checkForMovableDownClosingBrace(@NotNull PsiElement closingBrace, @NotNull PsiElement block, @NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info) {
        if (closingBrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closingBrace", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkForMovableDownClosingBrace"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkForMovableDownClosingBrace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkForMovableDownClosingBrace"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkForMovableDownClosingBrace"));
        }
        PsiElement current = block;
        PsiElement nextElement = null;
        PsiElement nextExpression = null;
        do {
            PsiElement sibling;
            if ((sibling = KotlinExpressionMover.firstNonWhiteElement((PsiElement)current.getNextSibling(), (boolean)true)) != null && nextElement == null) {
                nextElement = sibling;
            }
            if (!(sibling instanceof KtExpression)) continue;
            nextExpression = sibling;
            break;
        } while ((current = current.getParent()) != null && !PsiTreeUtil.instanceOf((Object)current, (Class[])BLOCKLIKE_ELEMENT_CLASSES));
        if (nextExpression == null) {
            return BraceStatus.NOT_MOVABLE;
        }
        Document doc = editor.getDocument();
        info.toMove = new LineRange(closingBrace, closingBrace, doc);
        info.toMove2 = new LineRange(nextElement, nextExpression);
        info.indentSource = true;
        return BraceStatus.MOVABLE;
    }

    private static BraceStatus checkForMovableUpClosingBrace(@NotNull PsiElement closingBrace, PsiElement block, @NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info) {
        if (closingBrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closingBrace", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkForMovableUpClosingBrace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkForMovableUpClosingBrace"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkForMovableUpClosingBrace"));
        }
        Object prev2 = KtPsiUtil.getLastChildByType(block, KtExpression.class);
        if (prev2 == null) {
            return BraceStatus.NOT_MOVABLE;
        }
        Document doc = editor.getDocument();
        info.toMove = new LineRange(closingBrace, closingBrace, doc);
        info.toMove2 = new LineRange(prev2, prev2, doc);
        info.indentSource = true;
        return BraceStatus.MOVABLE;
    }

    private static BraceStatus checkForMovableClosingBrace(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        KtIfExpression ifExpression2;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkForMovableClosingBrace"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkForMovableClosingBrace"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkForMovableClosingBrace"));
        }
        PsiElement closingBrace = KotlinExpressionMover.getStandaloneClosingBrace(file, editor);
        if (closingBrace == null) {
            return BraceStatus.NOT_FOUND;
        }
        PsiElement blockLikeElement = closingBrace.getParent();
        if (!(blockLikeElement instanceof KtBlockExpression)) {
            return BraceStatus.NOT_MOVABLE;
        }
        PsiElement blockParent = blockLikeElement.getParent();
        if (blockParent instanceof KtWhenEntry) {
            return BraceStatus.NOT_FOUND;
        }
        if (PsiTreeUtil.instanceOf((Object)blockParent, (Class[])FUNCTIONLIKE_ELEMENT_CLASSES)) {
            return BraceStatus.NOT_FOUND;
        }
        PsiElement enclosingExpression = PsiTreeUtil.getParentOfType((PsiElement)blockLikeElement, KtExpression.class);
        if (enclosingExpression instanceof KtDoWhileExpression) {
            return BraceStatus.NOT_MOVABLE;
        }
        if (enclosingExpression instanceof KtIfExpression && blockLikeElement == (ifExpression2 = (KtIfExpression)enclosingExpression).getThen() && ifExpression2.getElse() != null) {
            return BraceStatus.NOT_MOVABLE;
        }
        return down ? KotlinExpressionMover.checkForMovableDownClosingBrace(closingBrace, blockLikeElement, editor, info) : KotlinExpressionMover.checkForMovableUpClosingBrace(closingBrace, blockLikeElement, editor, info);
    }

    @Nullable
    private static KtBlockExpression findClosestBlock(@NotNull PsiElement anchor2, boolean down, boolean strict) {
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "findClosestBlock"));
        }
        PsiElement current = PsiTreeUtil.getParentOfType((PsiElement)anchor2, KtBlockExpression.class, (boolean)strict);
        while (current != null) {
            PsiElement sibling;
            PsiElement parent2 = current.getParent();
            if (parent2 instanceof KtClassBody || parent2 instanceof KtAnonymousInitializer || parent2 instanceof KtNamedFunction || parent2 instanceof KtProperty && !((KtProperty)parent2).isLocal()) {
                return null;
            }
            if (parent2 instanceof KtBlockExpression) {
                return (KtBlockExpression)parent2;
            }
            PsiElement psiElement = sibling = down ? current.getNextSibling() : current.getPrevSibling();
            if (sibling != null) {
                KtBlockExpression block = (KtBlockExpression)KtPsiUtil.getOutermostDescendantElement(sibling, down, CHECK_BLOCK);
                if (block != null) {
                    return block;
                }
                current = sibling;
                continue;
            }
            current = parent2;
        }
        return null;
    }

    @Nullable
    private static KtBlockExpression getDSLLambdaBlock(@NotNull PsiElement element2, boolean down) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getDSLLambdaBlock"));
        }
        KtCallExpression callExpression2 = (KtCallExpression)KtPsiUtil.getOutermostDescendantElement(element2, down, IS_CALL_EXPRESSION);
        if (callExpression2 == null) {
            return null;
        }
        List<KtLambdaArgument> functionLiterals = callExpression2.getLambdaArguments();
        if (functionLiterals.isEmpty()) {
            return null;
        }
        return functionLiterals.get(0).getLambdaExpression().getBodyExpression();
    }

    @Nullable
    private static LineRange getExpressionTargetRange(@NotNull Editor editor, @NotNull PsiElement sibling, boolean down) {
        KtExpression elseBranch;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getExpressionTargetRange"));
        }
        if (sibling == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sibling", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getExpressionTargetRange"));
        }
        if (sibling instanceof KtIfExpression && !down && (elseBranch = ((KtIfExpression)sibling).getElse()) instanceof KtBlockExpression) {
            sibling = elseBranch;
        }
        PsiElement start = sibling;
        PsiElement end = sibling;
        if (sibling.getNode().getElementType() == (down ? KtTokens.RBRACE : KtTokens.LBRACE)) {
            KtBlockExpression newBlock;
            PsiElement parent2 = sibling.getParent();
            if (!(parent2 instanceof KtBlockExpression) && !(parent2 instanceof KtFunctionLiteral)) {
                return null;
            }
            if (parent2 instanceof KtFunctionLiteral) {
                PsiElement arrow;
                newBlock = KotlinExpressionMover.findClosestBlock((PsiElement)((KtFunctionLiteral)parent2).getBodyExpression(), down, false);
                if (!down && (arrow = ((KtFunctionLiteral)parent2).getArrow()) != null) {
                    end = arrow;
                }
            } else {
                newBlock = KotlinExpressionMover.findClosestBlock(sibling, down, true);
            }
            if (newBlock == null) {
                return null;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)newBlock, (PsiElement)parent2, (boolean)true)) {
                PsiElement outermostParent = KtPsiUtil.getOutermostParent(parent2, (PsiElement)newBlock, true);
                if (down) {
                    end = outermostParent;
                } else {
                    start = outermostParent;
                }
            } else if (down) {
                end = newBlock.getLBrace();
            } else {
                start = newBlock.getRBrace();
            }
        } else {
            KtBlockExpression dslBlock = KotlinExpressionMover.getDSLLambdaBlock(sibling, down);
            Object blockLikeElement = dslBlock != null ? dslBlock.getParent() : KtPsiUtil.getOutermostDescendantElement(sibling, down, CHECK_BLOCK_LIKE_ELEMENT);
            if (blockLikeElement != null) {
                if (down) {
                    PsiElement arrow;
                    end = KtPsiUtil.findChildByType(blockLikeElement, KtTokens.LBRACE);
                    if (blockLikeElement instanceof KtFunctionLiteral && (arrow = ((KtFunctionLiteral)blockLikeElement).getArrow()) != null) {
                        end = arrow;
                    }
                } else {
                    start = KtPsiUtil.findChildByType(blockLikeElement, KtTokens.RBRACE);
                }
            }
        }
        return start != null && end != null ? new LineRange(start, end, editor.getDocument()) : null;
    }

    @Nullable
    private static LineRange getWhenEntryTargetRange(@NotNull Editor editor, @NotNull PsiElement sibling, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getWhenEntryTargetRange"));
        }
        if (sibling == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sibling", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getWhenEntryTargetRange"));
        }
        if (sibling.getNode().getElementType() == (down ? KtTokens.RBRACE : KtTokens.LBRACE) && PsiTreeUtil.getParentOfType((PsiElement)sibling, KtWhenEntry.class) == null) {
            return null;
        }
        return new LineRange(sibling, sibling, editor.getDocument());
    }

    @Nullable
    private LineRange getValueParamOrArgTargetRange(@NotNull Editor editor, @NotNull PsiElement elementToCheck, @NotNull PsiElement sibling, boolean down) {
        LineRange range;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getValueParamOrArgTargetRange"));
        }
        if (elementToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToCheck", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getValueParamOrArgTargetRange"));
        }
        if (sibling == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sibling", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getValueParamOrArgTargetRange"));
        }
        PsiElement next2 = sibling;
        if (next2.getNode().getElementType() == KtTokens.COMMA) {
            next2 = KotlinExpressionMover.firstNonWhiteSibling(next2, down);
        }
        Object object = range = next2 instanceof KtParameter || next2 instanceof KtValueArgument ? new LineRange(next2, next2, editor.getDocument()) : null;
        if (range != null) {
            this.parametersOrArgsToMove = new Pair((Object)elementToCheck, (Object)next2);
        }
        return range;
    }

    @Nullable
    private LineRange getTargetRange(@NotNull Editor editor, @Nullable PsiElement elementToCheck, @NotNull PsiElement sibling, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getTargetRange"));
        }
        if (sibling == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sibling", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getTargetRange"));
        }
        if (elementToCheck instanceof KtParameter || elementToCheck instanceof KtValueArgument) {
            return this.getValueParamOrArgTargetRange(editor, elementToCheck, sibling, down);
        }
        if (elementToCheck instanceof KtExpression || elementToCheck instanceof PsiComment) {
            return KotlinExpressionMover.getExpressionTargetRange(editor, sibling, down);
        }
        if (elementToCheck instanceof KtWhenEntry) {
            return KotlinExpressionMover.getWhenEntryTargetRange(editor, sibling, down);
        }
        return null;
    }

    @Override
    protected boolean checkSourceElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkSourceElement"));
        }
        return PsiTreeUtil.instanceOf((Object)element2, (Class[])MOVABLE_ELEMENT_CLASSES);
    }

    @Override
    protected LineRange getElementSourceLineRange(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull LineRange oldRange) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getElementSourceLineRange"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getElementSourceLineRange"));
        }
        if (oldRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRange", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getElementSourceLineRange"));
        }
        TextRange textRange = element2.getTextRange();
        if (editor.getDocument().getTextLength() < textRange.getEndOffset()) {
            return null;
        }
        int startLine = editor.offsetToLogicalPosition((int)textRange.getStartOffset()).line;
        int endLine = editor.offsetToLogicalPosition((int)textRange.getEndOffset()).line + 1;
        return new LineRange(startLine, endLine);
    }

    @Nullable
    private static PsiElement getMovableElement(@NotNull PsiElement element2, boolean lookRight) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getMovableElement"));
        }
        PsiElement movableElement = PsiUtilsKt.getParentOfTypesAndPredicate(element2, false, MOVABLE_ELEMENT_CLASSES, MOVABLE_ELEMENT_CONSTRAINT);
        if (movableElement == null) {
            return null;
        }
        if (KotlinExpressionMover.isBracelessBlock(movableElement)) {
            movableElement = KotlinExpressionMover.firstNonWhiteElement((PsiElement)(lookRight ? movableElement.getLastChild() : movableElement.getFirstChild()), (!lookRight ? 1 : 0) != 0);
        }
        return movableElement;
    }

    private static boolean isLastOfItsKind(@NotNull PsiElement element2, boolean down) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "isLastOfItsKind"));
        }
        return KotlinExpressionMover.getSiblingOfType(element2, down, element2.getClass()) == null;
    }

    private static boolean isForbiddenMove(@NotNull PsiElement element2, boolean down) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "isForbiddenMove"));
        }
        if (element2 instanceof KtParameter || element2 instanceof KtValueArgument) {
            return KotlinExpressionMover.isLastOfItsKind(element2, down);
        }
        return false;
    }

    private static boolean isBracelessBlock(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "isBracelessBlock"));
        }
        if (!(element2 instanceof KtBlockExpression)) {
            return false;
        }
        KtBlockExpression block = (KtBlockExpression)element2;
        return block.getLBrace() == null && block.getRBrace() == null;
    }

    protected static PsiElement adjustSibling(@NotNull LineRange sourceRange, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiElement parent2;
        PsiElement sibling;
        if (sourceRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRange", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "adjustSibling"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "adjustSibling"));
        }
        PsiElement element2 = down ? sourceRange.lastElement : sourceRange.firstElement;
        PsiElement whiteSpaceTestSubject = sibling = down ? element2.getNextSibling() : element2.getPrevSibling();
        if (sibling == null && (parent2 = element2.getParent()) != null && KotlinExpressionMover.isBracelessBlock(parent2)) {
            PsiElement psiElement = whiteSpaceTestSubject = down ? parent2.getNextSibling() : parent2.getPrevSibling();
        }
        if (whiteSpaceTestSubject instanceof PsiWhiteSpace) {
            if (JetRefactoringUtilKt.isMultiLine(whiteSpaceTestSubject)) {
                int nearLine = down ? sourceRange.endLine : sourceRange.startLine - 1;
                info.toMove = sourceRange;
                info.toMove2 = new LineRange(nearLine, nearLine + 1);
                info.indentTarget = false;
                return null;
            }
            if (sibling != null) {
                sibling = KotlinExpressionMover.firstNonWhiteElement((PsiElement)sibling, (boolean)down);
            }
        }
        if (sibling == null) {
            KtBlockExpression dslBlock;
            KtCallExpression callExpression2 = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, KtCallExpression.class);
            if (callExpression2 != null && PsiTreeUtil.isAncestor((PsiElement)(dslBlock = KotlinExpressionMover.getDSLLambdaBlock((PsiElement)callExpression2, down)), (PsiElement)element2, (boolean)false)) {
                PsiElement blockParent = dslBlock.getParent();
                return down ? KtPsiUtil.findChildByType(blockParent, KtTokens.RBRACE) : KtPsiUtil.findChildByType(blockParent, KtTokens.LBRACE);
            }
            info.toMove2 = null;
            return null;
        }
        return sibling;
    }

    @Override
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        LineRange sourceRange;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "checkAvailable"));
        }
        this.parametersOrArgsToMove = null;
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        switch (KotlinExpressionMover.checkForMovableClosingBrace(editor, file, info, down)) {
            case NOT_MOVABLE: {
                info.toMove2 = null;
                return true;
            }
            case MOVABLE: {
                return true;
            }
        }
        LineRange oldRange = info.toMove;
        Pair psiRange = KotlinExpressionMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)oldRange);
        if (psiRange == null) {
            return false;
        }
        PsiElement firstElement = KotlinExpressionMover.getMovableElement((PsiElement)psiRange.getFirst(), false);
        PsiElement lastElement = KotlinExpressionMover.getMovableElement((PsiElement)psiRange.getSecond(), true);
        if (firstElement == null || lastElement == null) {
            return false;
        }
        if (KotlinExpressionMover.isForbiddenMove(firstElement, down) || KotlinExpressionMover.isForbiddenMove(lastElement, down)) {
            info.toMove2 = null;
            return true;
        }
        if ((firstElement instanceof KtParameter || firstElement instanceof KtValueArgument) && PsiTreeUtil.isAncestor((PsiElement)lastElement, (PsiElement)firstElement, (boolean)false)) {
            lastElement = firstElement;
        }
        if ((sourceRange = this.getSourceRange(firstElement, lastElement, editor, oldRange)) == null) {
            return false;
        }
        PsiElement sibling = KotlinExpressionMover.getLastNonWhiteSiblingInLine(KotlinExpressionMover.adjustSibling(sourceRange, info, down), editor, down);
        if (sibling == null) {
            return true;
        }
        info.toMove = sourceRange;
        info.toMove2 = this.getTargetRange(editor, sourceRange.firstElement, sibling, down);
        return true;
    }

    private static PsiElement getComma(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "getComma"));
        }
        PsiElement sibling = KotlinExpressionMover.firstNonWhiteSibling(element2, true);
        return sibling != null && sibling.getNode().getElementType() == KtTokens.COMMA ? sibling : null;
    }

    private static void fixCommaIfNeeded(@NotNull PsiElement element2, boolean willBeLast) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "fixCommaIfNeeded"));
        }
        PsiElement comma = KotlinExpressionMover.getComma(element2);
        if (willBeLast && comma != null) {
            comma.delete();
        } else if (!willBeLast && comma == null) {
            PsiElement parent2 = element2.getParent();
            assert (parent2 != null);
            parent2.addAfter(KtPsiFactoryKt.KtPsiFactory(parent2.getProject()).createComma(), element2);
        }
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "beforeMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover", "beforeMove"));
        }
        if (this.parametersOrArgsToMove != null) {
            PsiElement element1 = (PsiElement)this.parametersOrArgsToMove.first;
            PsiElement element2 = (PsiElement)this.parametersOrArgsToMove.second;
            KotlinExpressionMover.fixCommaIfNeeded(element1, down && KotlinExpressionMover.isLastOfItsKind(element2, true));
            KotlinExpressionMover.fixCommaIfNeeded(element2, !down && KotlinExpressionMover.isLastOfItsKind(element1, true));
            PsiDocumentManager.getInstance((Project)editor.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
    }

    private static enum BraceStatus {
        NOT_FOUND,
        MOVABLE,
        NOT_MOVABLE;

    }
}

