/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.kotlin.idea.configuration.KotlinMavenConfigurator;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.resolve.TargetPlatform;

public class KotlinJavascriptMavenConfigurator
extends KotlinMavenConfigurator {
    private static final String NAME = "js maven";
    private static final String STD_LIB_ID = "kotlin-js-library";
    private static final String JS_GOAL = "js";
    private static final String JS_TEST_GOAL = "test-js";
    private static final String JS_EXECUTION_ID = "js";
    private static final String PRESENTABLE_TEXT = "JavaScript Maven - experimental";

    public KotlinJavascriptMavenConfigurator() {
        super(STD_LIB_ID, NAME, PRESENTABLE_TEXT);
    }

    @Override
    protected boolean isKotlinModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinJavascriptMavenConfigurator", "isKotlinModule"));
        }
        return ProjectStructureUtil.isJsKotlinModule(module);
    }

    @Override
    protected void createExecutions(VirtualFile virtualFile, MavenDomPlugin kotlinPlugin, Module module) {
        this.createExecution(virtualFile, kotlinPlugin, module, false);
        this.createExecution(virtualFile, kotlinPlugin, module, true);
    }

    @Override
    @NotNull
    protected String getExecutionId(boolean isTest) {
        String string = "js" + (isTest ? "-test" : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavascriptMavenConfigurator", "getExecutionId"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getGoal(boolean isTest) {
        String string = isTest ? JS_TEST_GOAL : "js";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavascriptMavenConfigurator", "getGoal"));
        }
        return string;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        JsPlatform jsPlatform = JsPlatform.INSTANCE;
        if (jsPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavascriptMavenConfigurator", "getTargetPlatform"));
        }
        return jsPlatform;
    }
}

