/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinEditorTextProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilder;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluator;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J6\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aH\u0016J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory;", "Lcom/intellij/debugger/engine/evaluation/CodeFragmentFactory;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createCodeFragment", "Lcom/intellij/psi/JavaCodeFragment;", "item", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "context", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "createPresentationCodeFragment", "createWrappingContext", "Lorg/jetbrains/kotlin/psi/KtElement;", "newFragmentText", "", "labels", "", "Lcom/sun/jdi/Value;", "originalContext", "getEvaluatorBuilder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluationBuilder;", "getFileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "kotlin.jvm.PlatformType", "getWrappedContextElement", "isContextAccepted", "", "contextElement", "wrapContextIfNeeded", "Companion", "idea"})
public final class KotlinCodeFragmentFactory
extends CodeFragmentFactory {
    private final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());
    @NotNull
    private static final Key<Value> LABEL_VARIABLE_VALUE_KEY;
    @NotNull
    private static final String DEBUG_LABEL_SUFFIX = "_DebugLabel";
    @NotNull
    private static final Key<StackFrameProxyImpl> DEBUG_FRAME_FOR_TESTS;
    public static final Companion Companion;

    @NotNull
    public JavaCodeFragment createCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        KtCodeFragment ktCodeFragment;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KtElement contextElement = this.getWrappedContextElement(project, context);
        if (contextElement == null) {
            PsiElement psiElement = context;
            this.LOG.warn("CodeFragment with null context created:" + "\n" + "originalContext = " + (psiElement != null ? PsiUtilsKt.getElementTextWithContext(psiElement) : null));
        }
        if (Intrinsics.areEqual((Object)item.getKind(), (Object)CodeFragmentKind.EXPRESSION)) {
            CharSequence charSequence = item.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"item.text");
            ktCodeFragment = new KtExpressionCodeFragment(project, "fragment.kt", charSequence, item.getImports(), (PsiElement)contextElement);
        } else {
            CharSequence charSequence = item.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"item.text");
            ktCodeFragment = new KtBlockCodeFragment(project, "fragment.kt", charSequence, item.getImports(), (PsiElement)contextElement);
        }
        KtCodeFragment codeFragment = ktCodeFragment;
        codeFragment.putCopyableUserData(KtCodeFragment.Companion.getRUNTIME_TYPE_EVALUATOR(), new Function1<KtExpression, KotlinType>(project){
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final KotlinType invoke(@NotNull KtExpression expression2) {
                KotlinType kotlinType;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx((Project)this.$project).getContext();
                DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
                if (debuggerSession == null) {
                    kotlinType = null;
                } else {
                    Unit unit;
                    Semaphore semaphore = new Semaphore();
                    semaphore.down();
                    AtomicReference<V> nameRef = new AtomicReference<V>();
                    Editor editor = null;
                    DebuggerContextImpl debuggerContextImpl = debuggerContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"debuggerContext");
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"ProgressManager.getInstance().progressIndicator");
                    KotlinRuntimeTypeEvaluator worker2 = new KotlinRuntimeTypeEvaluator(nameRef, semaphore, editor, expression2, debuggerContextImpl, progressIndicator){
                        final /* synthetic */ AtomicReference $nameRef;
                        final /* synthetic */ Semaphore $semaphore;

                        protected void typeCalculationFinished(@Nullable KotlinType type2) {
                            this.$nameRef.set(type2);
                            this.$semaphore.up();
                        }
                        {
                            this.$nameRef = $captured_local_variable$0;
                            this.$semaphore = $captured_local_variable$1;
                            super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5);
                        }
                    };
                    DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
                    if (debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getManagerThread()) != null) {
                        debugProcessImpl.invoke((DebuggerCommandImpl)worker2);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    int n = 0;
                    int n2 = 50;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            ProgressManager.checkCanceled();
                            if (semaphore.waitFor(20L) || i == n2) break;
                            ++i;
                        }
                    }
                    kotlinType = (KotlinType)nameRef.get();
                }
                return kotlinType;
            }
            {
                this.$project = project;
                super(1);
            }
        });
        return codeFragment;
    }

    private final KtElement getWrappedContextElement(Project project, PsiElement context) {
        return this.wrapContextIfNeeded(project, Companion.getContextElement(context));
    }

    @NotNull
    public JavaCodeFragment createPresentationCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.createCodeFragment(item, context, project);
    }

    public boolean isContextAccepted(@Nullable PsiElement contextElement) {
        if (contextElement instanceof PsiCodeBlock) {
            PsiElement psiElement = ((PsiCodeBlock)contextElement).getContext();
            return this.isContextAccepted((PsiElement)(psiElement != null ? psiElement.getContext() : null));
        }
        PsiElement psiElement = contextElement;
        return Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getLanguage() : null), (Object)KotlinFileType.INSTANCE.getLanguage());
    }

    public KotlinFileType getFileType() {
        return KotlinFileType.INSTANCE;
    }

    @NotNull
    public KotlinEvaluationBuilder getEvaluatorBuilder() {
        return KotlinEvaluationBuilder.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final KtElement wrapContextIfNeeded(Project project, KtElement originalContext) {
        void labels;
        void $receiver$iv;
        void text2;
        Map markupMap;
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (!(xDebugSession instanceof XDebugSessionImpl)) {
            xDebugSession = null;
        }
        XDebugSessionImpl xDebugSessionImpl = (XDebugSessionImpl)xDebugSession;
        if (xDebugSessionImpl == null) {
            return originalContext;
        }
        XDebugSessionImpl session = xDebugSessionImpl;
        XValueMarkers xValueMarkers = session.getValueMarkers();
        Map map2 = markupMap = xValueMarkers != null ? xValueMarkers.getAllMarkers() : null;
        if (markupMap == null || markupMap.isEmpty()) {
            return originalContext;
        }
        Object object = Companion.createCodeFragmentForLabeledObjects(project, markupMap);
        String string = (String)object.component1();
        Map map3 = (Map)object.component2();
        object = null;
        object = (CharSequence)text2;
        if ($receiver$iv.length() == 0) {
            return originalContext;
        }
        return this.createWrappingContext((String)text2, (Map<String, ? extends Value>)labels, (PsiElement)originalContext, project);
    }

    @Nullable
    public final KtElement createWrappingContext(@NotNull String newFragmentText, @NotNull Map<String, ? extends Value> labels, @Nullable PsiElement originalContext, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)newFragmentText, (String)"newFragmentText");
        Intrinsics.checkParameterIsNotNull(labels, (String)"labels");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KtBlockCodeFragment codeFragment = new KtPsiFactory(project).createBlockCodeFragment(newFragmentText, originalContext);
        codeFragment.accept(new KtTreeVisitorVoid(labels){
            final /* synthetic */ Map $labels;

            /*
             * WARNING - void declaration
             */
            public void visitProperty(@NotNull KtProperty property2) {
                void key$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                Map map2 = this.$labels;
                String string = property2.getName();
                void v0 = $receiver$iv;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                }
                Value reference2 = (Value)((Map)v0).get(key$iv);
                if (reference2 != null) {
                    property2.putUserData(KotlinCodeFragmentFactory.Companion.getLABEL_VARIABLE_VALUE_KEY(), reference2);
                }
            }
            {
                this.$labels = $captured_local_variable$0;
            }
        });
        return Companion.getContextElement(codeFragment.findElementAt(codeFragment.getText().length() - 1));
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"_label_variable_value_key_");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Value>(\"_label_variable_value_key_\")");
        LABEL_VARIABLE_VALUE_KEY = key;
        DEBUG_LABEL_SUFFIX = DEBUG_LABEL_SUFFIX;
        Key key2 = Key.create((String)"DEBUG_FRAME_FOR_TESTS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"DEBUG_FRAME_FOR_TESTS\")");
        DEBUG_FRAME_FOR_TESTS = key2;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00150\u0011J*\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f*\u0004\u0018\u00010\u001bH\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$Companion;", "", "()V", "DEBUG_FRAME_FOR_TESTS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "getDEBUG_FRAME_FOR_TESTS", "()Lcom/intellij/openapi/util/Key;", "DEBUG_LABEL_SUFFIX", "", "getDEBUG_LABEL_SUFFIX", "()Ljava/lang/String;", "LABEL_VARIABLE_VALUE_KEY", "Lcom/sun/jdi/Value;", "getLABEL_VARIABLE_VALUE_KEY", "createCodeFragmentForLabeledObjects", "Lkotlin/Pair;", "", "project", "Lcom/intellij/openapi/project/Project;", "markupMap", "Lcom/intellij/xdebugger/impl/ui/tree/ValueMarkup;", "createKotlinProperty", "variableName", "variableTypeName", "value", "getContextElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "elementAt", "Lcom/intellij/psi/PsiElement;", "check", "", "idea"})
    public static final class Companion {
        @NotNull
        public final Key<Value> getLABEL_VARIABLE_VALUE_KEY() {
            return LABEL_VARIABLE_VALUE_KEY;
        }

        @NotNull
        public final String getDEBUG_LABEL_SUFFIX() {
            return DEBUG_LABEL_SUFFIX;
        }

        @NotNull
        public final Key<StackFrameProxyImpl> getDEBUG_FRAME_FOR_TESTS() {
            return DEBUG_FRAME_FOR_TESTS;
        }

        @Nullable
        public final KtElement getContextElement(@Nullable PsiElement elementAt) {
            int n;
            if (elementAt == null) {
                return null;
            }
            if (elementAt instanceof PsiCodeBlock) {
                PsiElement psiElement = ((PsiCodeBlock)elementAt).getContext();
                return this.getContextElement((PsiElement)(psiElement != null ? psiElement.getContext() : null));
            }
            if (elementAt instanceof KtLightClass) {
                return this.getContextElement(((KtLightClass)elementAt).getOrigin());
            }
            PsiFile containingFile = elementAt.getContainingFile();
            if (!(containingFile instanceof KtFile)) {
                return null;
            }
            if (elementAt instanceof PsiWhiteSpace || elementAt instanceof PsiComment) {
                PsiElement psiElement = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAt, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                n = psiElement != null ? psiElement.getTextOffset() : elementAt.getTextOffset();
            } else {
                n = elementAt.getTextOffset();
            }
            int lineStartOffset = n;
            KtExpression result2 = (KtExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)containingFile, (int)lineStartOffset, KtExpression.class, (boolean)false);
            if (this.check(result2)) {
                KtExpression ktExpression = result2;
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                return CodeInsightUtils.getTopmostElementAtOffset((PsiElement)ktExpression, lineStartOffset, KtExpression.class);
            }
            result2 = KotlinEditorTextProvider.Companion.findExpressionInner(elementAt, true);
            if (this.check(result2)) {
                return result2;
            }
            return (KtElement)containingFile;
        }

        private final boolean check(KtElement $receiver) {
            return $receiver != null && AddToStdlibKt.check($receiver, check.1.INSTANCE) != null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<String, Map<String, Value>> createCodeFragmentForLabeledObjects(@NotNull Project project, @NotNull Map<?, ? extends ValueMarkup> markupMap) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(markupMap, (String)"markupMap");
            StringBuilder sb = new StringBuilder();
            HashMap<String, Value> labeledObjects = new HashMap<String, Value>();
            Set<Map.Entry<?, ValueMarkup>> entrySet = markupMap.entrySet();
            Iterator<Map.Entry<?, ValueMarkup>> iterator2 = entrySet.iterator();
            while (iterator2.hasNext()) {
                Value objectRef;
                void $receiver$iv;
                void $receiver$iv2;
                Map.Entry<?, ValueMarkup> entry;
                Map.Entry<?, ValueMarkup> entry2 = entry = iterator2.next();
                Object value2 = $receiver$iv2.getKey();
                Map.Entry<?, ValueMarkup> $i$f$component1 = entry;
                ValueMarkup markup = (ValueMarkup)$receiver$iv.getValue();
                String labelName = markup.getText();
                if (!Name.isValidIdentifier(labelName)) continue;
                Object k = value2;
                if (!(k instanceof Value)) {
                    k = null;
                }
                if ((Value)k == null) {
                    continue;
                }
                String labelNameWithSuffix = labelName + this.getDEBUG_LABEL_SUFFIX();
                StringBuilder stringBuilder = new StringBuilder();
                String string = objectRef.type().name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"objectRef.type().name()");
                sb.append(stringBuilder.append(this.createKotlinProperty(project, labelNameWithSuffix, string, objectRef)).append("\n").toString());
                labeledObjects.put(labelNameWithSuffix, objectRef);
            }
            sb.append("val _debug_context_val = 1");
            return TuplesKt.to((Object)sb.toString(), labeledObjects);
        }

        private final String createKotlinProperty(Project project, String variableName, String variableTypeName, Value value2) {
            ClassDescriptor actualClassDescriptor = KotlinEvaluationBuilderKt.getClassDescriptor(JdiValuesKt.asValue(value2).getAsmType(), project);
            if (actualClassDescriptor != null && actualClassDescriptor.getDefaultType().getArguments().isEmpty()) {
                String renderedType = IdeDescriptorRenderers.SOURCE_CODE.renderType(TypeUtilsKt.makeNullable(actualClassDescriptor.getDefaultType()));
                return "val " + JetRefactoringUtilKt.quoteIfNeeded(variableName) + ": " + renderedType + " = null";
            }
            Function1<String, String> addArraySuffix$ = new Function1<String, String>(value2){
                final /* synthetic */ Value $value;

                @NotNull
                public final String invoke(String $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    return this.$value instanceof ArrayReference ? $receiver + "[]" : $receiver;
                }
                {
                    this.$value = value2;
                    super(1);
                }
            };
            String className = StringsKt.substringBefore$default((String)StringsKt.replace$default((String)variableTypeName, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"[]", null, (int)2, null);
            PsiClassType classType = PsiType.getTypeByName((String)className, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            String type2 = addArraySuffix$.invoke(!(value2 instanceof PrimitiveValue) && classType.resolve() == null ? "java.lang.Object" : className);
            PsiField field2 = PsiElementFactory.SERVICE.getInstance((Project)project).createField(variableName, (PsiType)PsiType.getTypeByName((String)type2, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
            String string = JetRefactoringUtilKt.j2kText((PsiElement)field2);
            return string != null ? StringsKt.substringAfter$default((String)string, (String)"private ", null, (int)2, null) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

