/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilderKt$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ConstructorClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.FunctionClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.PropertyClsStubBuilder;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsKt;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u001a.\u0010\u000e\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"createCallableStubs", "", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "outerContext", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderContext;", "protoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "functionProtos", "", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function;", "propertyProtos", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Property;", "createConstructorStub", "constructorProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Constructor;", "shouldSkip", "", "flags", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "idea-analysis"})
public final class CallableClsStubBuilderKt {
    public static final void createCallableStubs(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer, @NotNull List<ProtoBuf.Function> functionProtos2, @NotNull List<ProtoBuf.Property> propertyProtos2) {
        Intrinsics.checkParameterIsNotNull(parentStub, (String)"parentStub");
        Intrinsics.checkParameterIsNotNull((Object)outerContext, (String)"outerContext");
        Intrinsics.checkParameterIsNotNull((Object)protoContainer, (String)"protoContainer");
        Intrinsics.checkParameterIsNotNull(functionProtos2, (String)"functionProtos");
        Intrinsics.checkParameterIsNotNull(propertyProtos2, (String)"propertyProtos");
        for (ProtoBuf.Property propertyProto : propertyProtos2) {
            int n = propertyProto.getFlags();
            Name name2 = outerContext.getNameResolver().getName(propertyProto.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"outerContext.nameResolve\u2026tName(propertyProto.name)");
            if (CallableClsStubBuilderKt.shouldSkip(n, name2)) continue;
            new PropertyClsStubBuilder(parentStub, outerContext, protoContainer, propertyProto).build();
        }
        for (ProtoBuf.Function functionProto : functionProtos2) {
            int n = functionProto.getFlags();
            Name name3 = outerContext.getNameResolver().getName(functionProto.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"outerContext.nameResolve\u2026tName(functionProto.name)");
            if (CallableClsStubBuilderKt.shouldSkip(n, name3)) continue;
            new FunctionClsStubBuilder(parentStub, outerContext, protoContainer, functionProto).build();
        }
    }

    public static final void createConstructorStub(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ProtoBuf.Constructor constructorProto, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer) {
        Intrinsics.checkParameterIsNotNull(parentStub, (String)"parentStub");
        Intrinsics.checkParameterIsNotNull((Object)constructorProto, (String)"constructorProto");
        Intrinsics.checkParameterIsNotNull((Object)outerContext, (String)"outerContext");
        Intrinsics.checkParameterIsNotNull((Object)protoContainer, (String)"protoContainer");
        new ConstructorClsStubBuilder(parentStub, outerContext, protoContainer, constructorProto).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldSkip(int flags, Name name2) {
        ProtoBuf.MemberKind memberKind = Flags.MEMBER_KIND.get(flags);
        if (memberKind == null) return false;
        switch (CallableClsStubBuilderKt$WhenMappings.$EnumSwitchMapping$0[memberKind.ordinal()]) {
            case 1: 
            case 2: {
                return true;
            }
            case 3: {
                if (DataClassUtilsKt.isComponentLike(name2)) return false;
                return true;
            }
            default: {
                return false;
            }
        }
    }
}

