/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighter;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public class FunctionsHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    public FunctionsHighlightingVisitor(AnnotationHolder holder, BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/highlighter/FunctionsHighlightingVisitor", "visitNamedFunction"));
        }
        PsiElement nameIdentifier = function2.getNameIdentifier();
        if (nameIdentifier != null) {
            NameHighlighter.highlightName(this.holder, nameIdentifier, KotlinHighlightingColors.FUNCTION_DECLARATION);
        }
        super.visitNamedFunction(function2);
    }

    @Override
    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
        KtSimpleNameExpression nameExpression;
        KtTypeElement typeElement;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/idea/highlighter/FunctionsHighlightingVisitor", "visitSuperTypeCallEntry"));
        }
        KtConstructorCalleeExpression calleeExpression = call.getCalleeExpression();
        KtTypeReference typeRef = calleeExpression.getTypeReference();
        if (typeRef != null && (typeElement = typeRef.getTypeElement()) instanceof KtUserType && (nameExpression = ((KtUserType)typeElement).getReferenceExpression()) != null) {
            NameHighlighter.highlightName(this.holder, (PsiElement)nameExpression, KotlinHighlightingColors.CONSTRUCTOR_CALL);
        }
        super.visitSuperTypeCallEntry(call);
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/FunctionsHighlightingVisitor", "visitCallExpression"));
        }
        KtExpression callee = expression2.getCalleeExpression();
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext);
        if (callee instanceof KtReferenceExpression && resolvedCall2 != null) {
            CallableDescriptor calleeDescriptor = resolvedCall2.getResultingDescriptor();
            if (DynamicCallsKt.isDynamic(calleeDescriptor)) {
                NameHighlighter.highlightName(this.holder, (PsiElement)callee, KotlinHighlightingColors.DYNAMIC_FUNCTION_CALL);
            } else if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                NameHighlighter.highlightName(this.holder, (PsiElement)callee, FunctionsHighlightingVisitor.containedInFunctionClassOrSubclass(calleeDescriptor) ? KotlinHighlightingColors.VARIABLE_AS_FUNCTION_CALL : KotlinHighlightingColors.VARIABLE_AS_FUNCTION_LIKE_CALL);
            } else if (calleeDescriptor instanceof ConstructorDescriptor) {
                NameHighlighter.highlightName(this.holder, (PsiElement)callee, KotlinHighlightingColors.CONSTRUCTOR_CALL);
            } else if (calleeDescriptor instanceof FunctionDescriptor) {
                FunctionDescriptor fun2 = (FunctionDescriptor)calleeDescriptor;
                NameHighlighter.highlightName(this.holder, (PsiElement)callee, KotlinHighlightingColors.FUNCTION_CALL);
                if (DescriptorUtils.isTopLevelDeclaration(fun2)) {
                    NameHighlighter.highlightName(this.holder, (PsiElement)callee, KotlinHighlightingColors.PACKAGE_FUNCTION_CALL);
                }
                if (fun2.getExtensionReceiverParameter() != null) {
                    NameHighlighter.highlightName(this.holder, (PsiElement)callee, KotlinHighlightingColors.EXTENSION_FUNCTION_CALL);
                }
            }
        }
        super.visitCallExpression(expression2);
    }

    private static boolean containedInFunctionClassOrSubclass(DeclarationDescriptor calleeDescriptor) {
        DeclarationDescriptor parent2 = calleeDescriptor.getContainingDeclaration();
        if (!(parent2 instanceof ClassDescriptor)) {
            return false;
        }
        KotlinType defaultType2 = ((ClassDescriptor)parent2).getDefaultType();
        if (KotlinBuiltIns.isFunctionOrExtensionFunctionType(defaultType2)) {
            return true;
        }
        for (KotlinType supertype : TypeUtils.getAllSupertypes(defaultType2)) {
            if (!KotlinBuiltIns.isFunctionOrExtensionFunctionType(supertype)) continue;
            return true;
        }
        return false;
    }
}

