/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.imports;

import com.google.common.collect.HashMultimap;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizer;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer;", "Lcom/intellij/lang/ImportOptimizer;", "()V", "processFile", "Ljava/lang/Runnable;", "file", "Lcom/intellij/psi/PsiFile;", "supports", "", "CollectUsedDescriptorsVisitor", "Companion", "OptimizeProcess", "idea"})
public final class KotlinImportOptimizer
implements ImportOptimizer {
    public static final Companion Companion = new Companion(null);

    public boolean supports(@Nullable PsiFile file) {
        return file instanceof KtFile;
    }

    @NotNull
    public Runnable processFile(@Nullable PsiFile file) {
        return new Runnable(file){
            final /* synthetic */ PsiFile $file;

            public final void run() {
                PsiFile psiFile = this.$file;
                if (psiFile == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                }
                new OptimizeProcess((KtFile)psiFile).execute();
            }
            {
                this.$file = psiFile;
            }
        };
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$OptimizeProcess;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "execute", "", "idea"})
    private static final class OptimizeProcess {
        private final KtFile file;

        public final void execute() {
            if (!(GetModuleInfoKt.getNullableModuleInfo((PsiElement)this.file) instanceof ModuleSourceInfo)) {
                return;
            }
            List<KtImportDirective> oldImports = this.file.getImportDirectives();
            if (oldImports.isEmpty()) {
                return;
            }
            Set<DeclarationDescriptor> descriptorsToImport = Companion.collectDescriptorsToImport(this.file);
            List<ImportPath> list2 = Companion.prepareOptimizedImports(this.file, (Collection<? extends DeclarationDescriptor>)descriptorsToImport);
            if (list2 == null) {
                return;
            }
            List<ImportPath> imports = list2;
            ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this, imports){
                final /* synthetic */ OptimizeProcess this$0;
                final /* synthetic */ List $imports;

                public final void invoke() {
                    KotlinImportOptimizer.Companion.replaceImports(OptimizeProcess.access$getFile$p(this.this$0), this.$imports);
                }
                {
                    this.this$0 = optimizeProcess;
                    this.$imports = list2;
                    super(0);
                }
            });
        }

        public OptimizeProcess(@NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.file = file;
        }

        @NotNull
        public static final /* synthetic */ KtFile access$getFile$p(OptimizeProcess $this) {
            return $this.file;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$CollectUsedDescriptorsVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "_descriptors", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "currentPackageName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/annotations/NotNull;", "descriptors", "", "getDescriptors", "()Ljava/util/Set;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "isAccessibleAsMember", "", "target", "place", "Lorg/jetbrains/kotlin/psi/KtElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "visitImportList", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "visitKtElement", "visitPackageDirective", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "idea"})
    private static final class CollectUsedDescriptorsVisitor
    extends KtVisitorVoid {
        private final HashSet<DeclarationDescriptor> _descriptors;
        private final FqName currentPackageName;
        @NotNull
        private final KtFile file;

        @NotNull
        public final Set<DeclarationDescriptor> getDescriptors() {
            return this._descriptors;
        }

        public void visitElement(@NotNull PsiElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            ProgressIndicatorProvider.checkCanceled();
            element2.acceptChildren((PsiElementVisitor)this);
        }

        @Override
        public void visitImportList(@NotNull KtImportList importList) {
            Intrinsics.checkParameterIsNotNull((Object)importList, (String)"importList");
        }

        @Override
        public void visitPackageDirective(@NotNull KtPackageDirective directive) {
            Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitKtElement(@NotNull KtElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            var4_2 = element.getReferences();
            for (var3_3 = 0; var3_3 < var4_2.length; ++var3_3) {
                reference = var4_2[var3_3];
                if (!(reference instanceof KtReference)) continue;
                v0 = element;
                if (!(v0 instanceof KtNameReferenceExpression)) {
                    v0 = null;
                }
                v1 = (KtNameReferenceExpression)v0;
                referencedName = v1 != null ? v1.getReferencedNameAsName() : null;
                bindingContext = ResolutionUtils.analyze$default(element, null, 1, null);
                v2 = BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT;
                v3 = element;
                if (!(v3 instanceof KtReferenceExpression)) {
                    v3 = null;
                }
                if ((v4 = (ClassDescriptor)bindingContext.get(v2, (KtReferenceExpression)v3)) == null) ** GOTO lbl-1000
                var8_8 = v4;
                it = (ClassDescriptor)$receiver$iv;
                v4 = CollectionsKt.listOf((Object)it);
                if (v4 != null) {
                    v5 = (Collection)v4;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = ((KtReference)reference).resolveToDescriptors(bindingContext);
                }
                targets = v5;
                for (DeclarationDescriptor target : targets) {
                    if (ImportsUtils.getImportableFqName(target) == null) {
                        continue;
                    }
                    parentFqName = importableFqName.parent();
                    if (target instanceof PackageViewDescriptor && Intrinsics.areEqual((Object)parentFqName, (Object)FqName.ROOT) || !(target instanceof PackageViewDescriptor) && Intrinsics.areEqual((Object)parentFqName, (Object)this.currentPackageName) || !ReferenceUtilKt.canBeResolvedViaImport((KtReference)reference, target)) continue;
                    importableDescriptor = DescriptorUtilsKt.getImportableDescriptor(target);
                    if (referencedName != null && Intrinsics.areEqual((Object)importableDescriptor.getName(), (Object)referencedName) ^ true || this.isAccessibleAsMember(importableDescriptor, element, bindingContext)) continue;
                    this._descriptors.add(importableDescriptor);
                }
            }
            super.visitKtElement(element);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isAccessibleAsMember(DeclarationDescriptor target, KtElement place, BindingContext bindingContext2) {
            if (!(target.getContainingDeclaration() instanceof ClassDescriptor)) {
                return false;
            }
            Function1<HierarchicalScope, Boolean> isInScope$ = new Function1<HierarchicalScope, Boolean>(target){
                final /* synthetic */ DeclarationDescriptor $target;

                public final boolean invoke(@NotNull HierarchicalScope scope2) {
                    boolean bl;
                    Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
                    DeclarationDescriptor declarationDescriptor = this.$target;
                    if (declarationDescriptor instanceof FunctionDescriptor) {
                        Name name2 = ((FunctionDescriptor)this.$target).getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"target.name");
                        bl = ScopeUtilsKt.findFunction(scope2, name2, NoLookupLocation.FROM_IDE, (Function1<? super FunctionDescriptor, Boolean>)((Function1)new Function1<FunctionDescriptor, Boolean>(this){
                            final /* synthetic */ isAccessibleAsMember.1 this$0;

                            public final boolean invoke(@NotNull FunctionDescriptor it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)it, (Object)this.this$0.$target);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        })) != null;
                    } else if (declarationDescriptor instanceof PropertyDescriptor) {
                        Name name3 = ((PropertyDescriptor)this.$target).getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"target.name");
                        bl = ScopeUtilsKt.findVariable(scope2, name3, NoLookupLocation.FROM_IDE, (Function1<? super VariableDescriptor, Boolean>)((Function1)new Function1<VariableDescriptor, Boolean>(this){
                            final /* synthetic */ isAccessibleAsMember.1 this$0;

                            public final boolean invoke(@NotNull VariableDescriptor it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)it, (Object)this.this$0.$target);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        })) != null;
                    } else if (declarationDescriptor instanceof ClassDescriptor) {
                        Name name4 = ((ClassDescriptor)this.$target).getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"target.name");
                        bl = Intrinsics.areEqual((Object)ScopeUtilsKt.findClassifier(scope2, name4, NoLookupLocation.FROM_IDE), (Object)this.$target);
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.$target = declarationDescriptor;
                    super(1);
                }
            };
            LexicalScope resolutionScope = ScopeUtils.getResolutionScope((PsiElement)place, bindingContext2, ResolutionUtils.getResolutionFacade(place));
            LexicalScope noImportsScope = ScopeUtilsKt.replaceImportingScopes(resolutionScope, null);
            if (isInScope$.invoke((HierarchicalScope)noImportsScope)) {
                return true;
            }
            if (!(target instanceof ClassDescriptor)) {
                boolean bl;
                block5: {
                    void $receiver$iv;
                    Iterable iterable = ScopeUtilsKt.getImplicitReceiversHierarchy(resolutionScope);
                    for (Object element$iv : $receiver$iv) {
                        ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv;
                        if (!isInScope$.invoke((HierarchicalScope)ScopeUtilsKt.memberScopeAsImportingScope$default(it.getType().getMemberScope(), null, 1, null))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                if (bl) {
                    return true;
                }
            }
            return false;
        }

        @NotNull
        public final KtFile getFile() {
            return this.file;
        }

        public CollectUsedDescriptorsVisitor(@NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.file = file;
            this._descriptors = new HashSet();
            this.currentPackageName = this.file.getPackageFqName();
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion;", "", "()V", "buildAliasImportMap", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/name/FqName;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectDescriptorsToImport", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "prepareOptimizedImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "descriptorsToImport", "", "replaceImports", "", "imports", "idea"})
    public static final class Companion {
        @NotNull
        public final Set<DeclarationDescriptor> collectDescriptorsToImport(@NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            CollectUsedDescriptorsVisitor visitor2 = new CollectUsedDescriptorsVisitor(file);
            file.accept(visitor2);
            return visitor2.getDescriptors();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<ImportPath> prepareOptimizedImports(@NotNull KtFile file, @NotNull Collection<? extends DeclarationDescriptor> descriptorsToImport) {
            Collection it;
            Object parentFqName;
            Iterable it2;
            Object item$iv$iv;
            Collection destination$iv$iv;
            ImportPath it22;
            Map<Name, FqName> $receiver$iv$iv;
            void $receiver$iv$iv2;
            Object p1;
            Collection element$iv;
            Object object;
            Collection collection;
            Object container2;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(descriptorsToImport, (String)"descriptorsToImport");
            Project project = file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            ImportInsertHelper importInsertHelper = ImportInsertHelper.Companion.getInstance(project);
            KotlinCodeStyleSettings codeStyleSettings = KotlinCodeStyleSettings.getInstance(file.getProject());
            Map<Name, FqName> aliasImports = this.buildAliasImportMap(file);
            HashSet<ImportPath> importsToGenerate = new HashSet<ImportPath>();
            HashMultimap descriptorsByParentFqName = HashMultimap.create();
            for (DeclarationDescriptor declarationDescriptor : descriptorsToImport) {
                boolean bl;
                boolean bl2;
                FqName fqName3;
                if (ImportsUtils.getImportableFqName(declarationDescriptor) == null) {
                    Intrinsics.throwNpe();
                }
                container2 = declarationDescriptor.getContainingDeclaration();
                FqName parentFqName2 = fqName3.parent();
                if (parentFqName2.isRoot()) {
                    bl2 = false;
                } else {
                    Object object2 = container2;
                    if (!(object2 instanceof ClassDescriptor)) {
                        object2 = null;
                    }
                    ClassDescriptor classDescriptor = (ClassDescriptor)object2;
                    bl2 = bl = !Intrinsics.areEqual((Object)((Object)(classDescriptor != null ? classDescriptor.getKind() : null)), (Object)((Object)ClassKind.OBJECT));
                }
                if (bl) {
                    descriptorsByParentFqName.put((Object)parentFqName2, (Object)declarationDescriptor);
                    continue;
                }
                importsToGenerate.add(new ImportPath(fqName3, false));
            }
            HashSet<FqName> hashSet = new HashSet<FqName>();
            Function1<FqName, Boolean> isImportedByDefault$ = new Function1<FqName, Boolean>(importInsertHelper, file){
                final /* synthetic */ ImportInsertHelper $importInsertHelper;
                final /* synthetic */ KtFile $file;

                public final boolean invoke(@NotNull FqName fqName2) {
                    Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                    return this.$importInsertHelper.isImportedWithDefault(new ImportPath(fqName2, false), this.$file);
                }
                {
                    this.$importInsertHelper = importInsertHelper;
                    this.$file = ktFile;
                    super(1);
                }
            };
            for (FqName parentFqName3 : descriptorsByParentFqName.keys()) {
                boolean bl;
                block23: {
                    void $receiver$iv2;
                    Object descriptor322;
                    boolean explicitImports;
                    void destination$iv$iv2;
                    Object item$iv$iv222;
                    void $receiver$iv$iv3;
                    void $receiver$iv3;
                    Set descriptors = descriptorsByParentFqName.get((Object)parentFqName3);
                    Iterable iterable = descriptors;
                    void var15_26 = $receiver$iv3;
                    Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                    for (Object item$iv$iv222 : $receiver$iv$iv3) {
                        void it3;
                        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)item$iv$iv222;
                        collection = destination$iv$iv2;
                        if (ImportsUtils.getImportableFqName((DeclarationDescriptor)it3) == null) {
                            Intrinsics.throwNpe();
                        }
                        collection.add(object);
                    }
                    Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    boolean isMember = ((DeclarationDescriptor)CollectionsKt.first((Iterable)descriptors)).getContainingDeclaration() instanceof ClassDescriptor;
                    int nameCountToUseStar = isMember ? codeStyleSettings.NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS : codeStyleSettings.NAME_COUNT_TO_USE_STAR_IMPORT;
                    boolean bl3 = explicitImports = set.size() < nameCountToUseStar && codeStyleSettings.PACKAGES_TO_USE_STAR_IMPORTS.contains(parentFqName3.asString()) ^ true;
                    if (explicitImports) {
                        item$iv$iv222 = set.iterator();
                        while (item$iv$iv222.hasNext()) {
                            FqName fqName4 = (FqName)item$iv$iv222.next();
                            if (isImportedByDefault$.invoke(fqName4)) continue;
                            importsToGenerate.add(new ImportPath(fqName4, false));
                        }
                        continue;
                    }
                    for (Object descriptor322 : descriptors) {
                        if (!(descriptor322 instanceof ClassDescriptor)) continue;
                        FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor322);
                        if (fqName2 == null) {
                            Intrinsics.throwNpe();
                        }
                        hashSet.add(fqName2);
                    }
                    descriptor322 = set;
                    item$iv$iv222 = $receiver$iv2.iterator();
                    while (item$iv$iv222.hasNext()) {
                        element$iv = item$iv$iv222.next();
                        p1 = (FqName)((Object)element$iv);
                        if (isImportedByDefault$.invoke((FqName)p1)) continue;
                        bl = false;
                        break block23;
                    }
                    bl = true;
                }
                if (bl) continue;
                importsToGenerate.add(new ImportPath(parentFqName3, true));
            }
            container2 = new StringBuilder();
            StringBuilder $receiver = (StringBuilder)$receiver$iv$iv2;
            $receiver.append("package ").append(RenderingUtilsKt.render(file.getPackageFqName().toUnsafe())).append("\n");
            Iterable iterable = importsToGenerate;
            Iterable isMember = iterable;
            Collection nameCountToUseStar = new ArrayList();
            Iterator explicitImports = $receiver$iv$iv.iterator();
            while (explicitImports.hasNext()) {
                Object element$iv$iv = explicitImports.next();
                it22 = (ImportPath)element$iv$iv;
                if (!it22.isAllUnder()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            $receiver$iv$iv = iterable2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            explicitImports = $receiver$iv$iv.iterator();
            while (explicitImports.hasNext()) {
                item$iv$iv = explicitImports.next();
                it22 = (ImportPath)item$iv$iv;
                element$iv = destination$iv$iv;
                p1 = "import " + ((ImportPath)((Object)it2)).getPathStr();
                element$iv.add(p1);
            }
            CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)$receiver, (CharSequence)"\n", null, null, (int)0, null, null, (int)124, null);
            String string = ((StringBuilder)$receiver$iv$iv2).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String fileWithImportsText = string;
            KtFile fileWithImports = KtPsiFactoryKt.KtPsiFactory((PsiElement)file).createAnalyzableFile("Dummy.kt", fileWithImportsText, (PsiElement)file);
            LexicalScope scope2 = ScopeUtils.getFileResolutionScope(ResolutionUtils.getResolutionFacade(fileWithImports), fileWithImports);
            for (FqName fqName3 : hashSet) {
                void destination$iv$iv3;
                void $receiver$iv$iv4;
                void $receiver$iv4;
                HierarchicalScope hierarchicalScope = scope2;
                Name name2 = fqName3.shortName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"fqName.shortName()");
                ClassifierDescriptor classifierDescriptor = ScopeUtilsKt.findClassifier(hierarchicalScope, name2, NoLookupLocation.FROM_IDE);
                if (!(Intrinsics.areEqual((Object)(classifierDescriptor != null ? ImportsUtils.getImportableFqName(classifierDescriptor) : null), (Object)fqName3) ^ true)) continue;
                importsToGenerate.add(new ImportPath(fqName3, false));
                parentFqName = fqName3.parent();
                it2 = descriptorsByParentFqName.get(parentFqName);
                element$iv = $receiver$iv4;
                p1 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv4) {
                    DeclarationDescriptor it4 = (DeclarationDescriptor)element$iv$iv;
                    if (!Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName(it4), (Object)fqName3)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                for (DeclarationDescriptor descriptor4 : (List)destination$iv$iv3) {
                    descriptorsByParentFqName.remove(parentFqName, (Object)descriptor4);
                }
                if (!descriptorsByParentFqName.get(parentFqName).isEmpty()) continue;
                importsToGenerate.remove(new ImportPath((FqName)parentFqName, true));
            }
            Map<Name, FqName> map2 = aliasImports;
            $receiver$iv$iv = map2;
            for (Map.Entry<Name, FqName> item$iv : $receiver$iv$iv.entrySet()) {
                item$iv$iv = item$iv;
                collection = importsToGenerate;
                object = new ImportPath((FqName)it.getValue(), false, (Name)it.getKey());
                collection.add(object);
            }
            List list2 = CollectionsKt.sortedWith((Iterable)importsToGenerate, importInsertHelper.getImportSortComparator());
            List<KtImportDirective> oldImports = file.getImportDirectives();
            if (oldImports.size() == list2.size()) {
                void destination$iv$iv4;
                void $receiver$iv$iv5;
                void $receiver$iv5;
                Map.Entry<Name, FqName> item$iv;
                parentFqName = oldImports;
                item$iv = $receiver$iv5;
                it = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv5, (int)10));
                for (Object item$iv$iv3 : $receiver$iv$iv5) {
                    void it5;
                    KtImportDirective $i$f$mapTo = (KtImportDirective)item$iv$iv3;
                    collection = destination$iv$iv4;
                    object = it5.getImportPath();
                    collection.add(object);
                }
                if (Intrinsics.areEqual((Object)((List)destination$iv$iv4), (Object)list2)) {
                    return null;
                }
            }
            return list2;
        }

        private final Map<Name, FqName> buildAliasImportMap(KtFile file) {
            List<KtImportDirective> imports = file.getImportDirectives();
            HashMap<Name, FqName> aliasImports = new HashMap<Name, FqName>();
            for (KtImportDirective ktImportDirective : imports) {
                ImportPath path;
                if (ktImportDirective.getImportPath() == null) {
                    continue;
                }
                Name aliasName = path.getAlias();
                if (aliasName == null || !(Intrinsics.areEqual((Object)aliasName, (Object)path.fqnPart().shortName()) ^ true)) continue;
                aliasImports.put(aliasName, path.fqnPart());
            }
            return aliasImports;
        }

        public final void replaceImports(@NotNull KtFile file, @NotNull List<ImportPath> imports) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(imports, (String)"imports");
            KtImportList ktImportList = file.getImportList();
            if (ktImportList == null) {
                Intrinsics.throwNpe();
            }
            KtImportList importList = ktImportList;
            List<KtImportDirective> oldImports = importList.getImports();
            Project project = file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            KtPsiFactory psiFactory = new KtPsiFactory(project);
            for (ImportPath importPath : imports) {
                importList.addBefore((PsiElement)psiFactory.createImportDirective(importPath), (PsiElement)CollectionsKt.lastOrNull(oldImports));
            }
            for (KtImportDirective ktImportDirective : oldImports) {
                ktImportDirective.delete();
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

