/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedTransformationUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "element", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class CommaInWhenConditionWithoutArgumentFix
extends KotlinQuickFixAction<PsiElement>
implements CleanupFix {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Replace ',' with '||' in when";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object t = this.getElement();
        if (!(t instanceof KtWhenExpression)) {
            t = null;
        }
        KtWhenExpression ktWhenExpression = (KtWhenExpression)t;
        if (ktWhenExpression == null) {
            return;
        }
        KtWhenExpression whenExpression2 = ktWhenExpression;
        CommaInWhenConditionWithoutArgumentFix.Companion.replaceCommasWithOrsInWhenExpression(whenExpression2);
    }

    public CommaInWhenConditionWithoutArgumentFix(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super(element2);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getConditionsDataOrNull", "Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix$Companion$WhenEntryConditionsData;", "whenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "replaceCommasWithOrsInWhenExpression", "", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "WhenEntryConditionsData", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            CommaInWhenConditionWithoutArgumentFix commaInWhenConditionWithoutArgumentFix;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement().getParent();
            if (psiElement != null && (psiElement = psiElement.getParent()) != null) {
                PsiElement $receiver$iv = psiElement;
                PsiElement whenExpressionElement = $receiver$iv;
                commaInWhenConditionWithoutArgumentFix = new CommaInWhenConditionWithoutArgumentFix(whenExpressionElement);
            } else {
                commaInWhenConditionWithoutArgumentFix = null;
            }
            return commaInWhenConditionWithoutArgumentFix;
        }

        private final void replaceCommasWithOrsInWhenExpression(KtWhenExpression whenExpression2) {
            for (KtWhenEntry whenEntry : whenExpression2.getEntries()) {
                KtExpression replacement;
                WhenEntryConditionsData conditionsData;
                if (((Object[])whenEntry.getConditions()).length <= 1) continue;
                KtWhenEntry ktWhenEntry = whenEntry;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"whenEntry");
                if (this.getConditionsDataOrNull(ktWhenEntry) == null) {
                    return;
                }
                PsiElement psiElement = (PsiElement)whenEntry;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"whenEntry");
                if (BranchedTransformationUtilsKt.combineWhenConditions(KtPsiFactoryKt.KtPsiFactory(psiElement), conditionsData.getConditions(), null) == null) {
                    return;
                }
                whenEntry.deleteChildRange(conditionsData.getFirst(), conditionsData.getLast());
                whenEntry.addBefore((PsiElement)replacement, conditionsData.getArrow());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final WhenEntryConditionsData getConditionsDataOrNull(KtWhenEntry whenEntry) {
            WhenEntryConditionsData whenEntryConditionsData;
            PsiElement last;
            PsiElement child;
            ArrayList<PsiElement> conditions = new ArrayList<PsiElement>();
            PsiElement arrow = null;
            for (child = whenEntry.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof KtWhenConditionWithExpression) {
                    conditions.add(child);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)child.getNode().getElementType(), (Object)((Object)KtTokens.ARROW))) continue;
                arrow = child;
                break;
            }
            PsiElement psiElement = child;
            Object object = last = psiElement != null ? psiElement.getPrevSibling() : null;
            if (arrow != null && last != null) {
                void $receiver$iv;
                WhenEntryConditionsData whenEntryConditionsData2;
                Collection collection = conditions;
                WhenEntryConditionsData whenEntryConditionsData3 = whenEntryConditionsData2;
                WhenEntryConditionsData whenEntryConditionsData4 = whenEntryConditionsData2;
                Collection thisCollection$iv = (Collection)$receiver$iv;
                KtWhenCondition[] ktWhenConditionArray = thisCollection$iv.toArray(new KtWhenCondition[thisCollection$iv.size()]);
                if (ktWhenConditionArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Object[] objectArray = ktWhenConditionArray;
                whenEntryConditionsData = whenEntryConditionsData4;
                KtWhenCondition[] ktWhenConditionArray2 = (KtWhenCondition[])objectArray;
                PsiElement psiElement2 = whenEntry.getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"whenEntry.firstChild");
                whenEntryConditionsData3(ktWhenConditionArray2, psiElement2, last, arrow);
            } else {
                whenEntryConditionsData = null;
            }
            return whenEntryConditionsData;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix$Companion$WhenEntryConditionsData;", "", "conditions", "", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "first", "Lcom/intellij/psi/PsiElement;", "last", "arrow", "([Lorg/jetbrains/kotlin/psi/KtWhenCondition;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "getArrow", "()Lcom/intellij/psi/PsiElement;", "getConditions", "()[Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "[Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "getFirst", "getLast", "idea"})
        private static final class WhenEntryConditionsData {
            @NotNull
            private final KtWhenCondition[] conditions;
            @NotNull
            private final PsiElement first;
            @NotNull
            private final PsiElement last;
            @NotNull
            private final PsiElement arrow;

            @NotNull
            public final KtWhenCondition[] getConditions() {
                return this.conditions;
            }

            @NotNull
            public final PsiElement getFirst() {
                return this.first;
            }

            @NotNull
            public final PsiElement getLast() {
                return this.last;
            }

            @NotNull
            public final PsiElement getArrow() {
                return this.arrow;
            }

            public WhenEntryConditionsData(@NotNull KtWhenCondition[] conditions, @NotNull PsiElement first, @NotNull PsiElement last, @NotNull PsiElement arrow) {
                Intrinsics.checkParameterIsNotNull((Object)conditions, (String)"conditions");
                Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
                Intrinsics.checkParameterIsNotNull((Object)last, (String)"last");
                Intrinsics.checkParameterIsNotNull((Object)arrow, (String)"arrow");
                this.conditions = conditions;
                this.first = first;
                this.last = last;
                this.arrow = arrow;
            }
        }
    }
}

