/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.codeInsight.unwrap.RangeSplitter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/SelectionAwareScopeHighlighter;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "highlighters", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "addHighlighter", "", "r", "Lcom/intellij/openapi/util/TextRange;", "attr", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "dropHighlight", "highlight", "wholeAffected", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class SelectionAwareScopeHighlighter {
    private final ArrayList<RangeHighlighter> highlighters;
    @NotNull
    private final Editor editor;

    private final void addHighlighter(TextRange r, TextAttributes attr) {
        this.highlighters.add(this.editor.getMarkupModel().addRangeHighlighter(r.getStartOffset(), r.getEndOffset(), 6001, attr, HighlighterTargetArea.EXACT_RANGE));
    }

    /*
     * WARNING - void declaration
     */
    public final void highlight(@NotNull PsiElement wholeAffected) {
        void receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)wholeAffected, (String)"wholeAffected");
        this.dropHighlight();
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (textAttributes == null) {
            Intrinsics.throwNpe();
        }
        TextAttributes attributes = textAttributes;
        SelectionModel selectionModel = this.editor.getSelectionModel();
        SelectionModel $receiver = (SelectionModel)receiver$iv;
        TextRange selectedRange = new TextRange($receiver.getSelectionStart(), $receiver.getSelectionEnd());
        TextRange textRange = wholeAffected.getTextRange();
        if (textRange == null) {
            Intrinsics.throwNpe();
        }
        Iterator iterator2 = RangeSplitter.split((TextRange)textRange, Collections.singletonList(selectedRange)).iterator();
        while (iterator2.hasNext()) {
            TextRange r;
            TextRange textRange2 = r = (TextRange)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"r");
            this.addHighlighter(textRange2, attributes);
        }
    }

    public final void dropHighlight() {
        Iterable $receiver$iv = this.highlighters;
        for (Object element$iv : $receiver$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            it.dispose();
        }
        this.highlighters.clear();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public SelectionAwareScopeHighlighter(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.editor = editor;
        this.highlighters = new ArrayList();
    }
}

