/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTarget;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/KotlinMoveTargetForCompanion;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/KotlinMoveTarget;", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "getTargetClass", "()Lorg/jetbrains/kotlin/psi/KtClass;", "targetContainerFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/annotations/Nullable;", "getTargetContainerFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getOrCreateTargetPsi", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "originalPsi", "Lcom/intellij/psi/PsiElement;", "getTargetPsiIfExists", "verify", "", "file", "Lcom/intellij/psi/PsiFile;", "idea"})
public final class KotlinMoveTargetForCompanion
implements KotlinMoveTarget {
    @NotNull
    private final FqName targetContainerFqName;
    @NotNull
    private final KtClass targetClass;

    @Override
    @NotNull
    public FqName getTargetContainerFqName() {
        return this.targetContainerFqName;
    }

    @Override
    @NotNull
    public KtObjectDeclaration getOrCreateTargetPsi(@NotNull PsiElement originalPsi) {
        Intrinsics.checkParameterIsNotNull((Object)originalPsi, (String)"originalPsi");
        return PsiModificationUtilsKt.getOrCreateCompanionObject(this.targetClass);
    }

    @Override
    @Nullable
    public KtObjectDeclaration getTargetPsiIfExists(@NotNull PsiElement originalPsi) {
        Intrinsics.checkParameterIsNotNull((Object)originalPsi, (String)"originalPsi");
        return (KtObjectDeclaration)CollectionsKt.firstOrNull(this.targetClass.getCompanionObjects());
    }

    @Override
    @Nullable
    public String verify(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return null;
    }

    @NotNull
    public final KtClass getTargetClass() {
        return this.targetClass;
    }

    public KotlinMoveTargetForCompanion(@NotNull KtClass targetClass) {
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        this.targetClass = targetClass;
        Object object = (KtObjectDeclaration)CollectionsKt.firstOrNull(this.targetClass.getCompanionObjects());
        if (object == null || (object = ((KtTypeParameterListOwnerStub)object).getFqName()) == null) {
            FqName fqName2 = this.targetClass.getFqName();
            if (fqName2 == null) {
                Intrinsics.throwNpe();
            }
            object = fqName2.child(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
        }
        this.targetContainerFqName = object;
    }
}

