/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverrideResolver;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0016J8\u0010\u0016\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J;\u0010\u0017\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPropertyProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "()V", "addRenameElements", "", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "oldName", "", "newName", "allRenames", "", "Lcom/intellij/psi/PsiElement;", "scope", "Lcom/intellij/psi/search/SearchScope;", "canProcessElement", "", "element", "findDeepestOverriddenDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "declaration", "isInplaceRenameSupported", "prepareRenaming", "renameElement", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "substituteElementToRename", "editor", "Lcom/intellij/openapi/editor/Editor;", "UsageKind", "idea"})
public final class RenameKotlinPropertyProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiNamedElement namedUnwrappedElement = LightClassUtilsKt.getNamedUnwrappedElement(element2);
        return namedUnwrappedElement instanceof KtProperty || namedUnwrappedElement instanceof KtParameter && ((KtParameter)namedUnwrappedElement).hasValOrVar();
    }

    public boolean isInplaceRenameSupported() {
        return false;
    }

    @Nullable
    public PsiElement substituteElementToRename(@Nullable PsiElement element2, @Nullable Editor editor) {
        PsiElement psiElement;
        PsiElement psiElement2 = element2;
        Object namedUnwrappedElement = psiElement2 != null ? LightClassUtilsKt.getNamedUnwrappedElement(psiElement2) : null;
        PsiNamedElement psiNamedElement = namedUnwrappedElement;
        if (!(psiNamedElement instanceof KtCallableDeclaration)) {
            psiNamedElement = null;
        }
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiNamedElement;
        if (ktCallableDeclaration == null) {
            throw (Throwable)new IllegalStateException("Can't be for element " + element2 + " there because of canProcessElement()");
        }
        KtCallableDeclaration callableDeclaration = ktCallableDeclaration;
        KtCallableDeclaration deepestSuperDeclaration = this.findDeepestOverriddenDeclaration(callableDeclaration);
        if (deepestSuperDeclaration == null || Intrinsics.areEqual((Object)deepestSuperDeclaration, (Object)callableDeclaration)) {
            return callableDeclaration;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        if (application.isUnitTestMode()) {
            return deepestSuperDeclaration;
        }
        Object object = deepestSuperDeclaration.getFqName();
        if (object == null || (object = ((FqName)object).parent()) == null || (object = ((FqName)object).asString()) == null) {
            PsiElement psiElement3 = deepestSuperDeclaration.getParent();
            if (!(psiElement3 instanceof KtClassOrObject)) {
                psiElement3 = null;
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement3;
            object = ktClassOrObject != null ? ktClassOrObject.getName() : null;
        }
        Object containsText = object;
        int result2 = Messages.showYesNoCancelDialog((Project)deepestSuperDeclaration.getProject(), (String)(containsText != null ? "Do you want to rename base property from " + "\n" + (String)containsText : "Do you want to rename base property"), (String)"Rename warning", (Icon)Messages.getQuestionIcon());
        switch (result2) {
            case 0: {
                psiElement = deepestSuperDeclaration;
                break;
            }
            case 1: {
                psiElement = callableDeclaration;
                break;
            }
            default: {
                psiElement = null;
            }
        }
        return psiElement;
    }

    public void prepareRenaming(@Nullable PsiElement element2, @Nullable String newName2, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        LightClassUtil.PropertyAccessorsPsiMethods propertyAccessorsPsiMethods;
        PsiNamedElement namedUnwrappedElement;
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        PsiElement psiElement = element2;
        PsiNamedElement psiNamedElement = namedUnwrappedElement = psiElement != null ? LightClassUtilsKt.getNamedUnwrappedElement(psiElement) : null;
        if (psiNamedElement instanceof KtProperty) {
            propertyAccessorsPsiMethods = (LightClassUtil.PropertyAccessorsPsiMethods)ApplicationUtilsKt.runReadAction((Function0)new Function0<LightClassUtil.PropertyAccessorsPsiMethods>(namedUnwrappedElement){
                final /* synthetic */ PsiNamedElement $namedUnwrappedElement;

                @NotNull
                public final LightClassUtil.PropertyAccessorsPsiMethods invoke() {
                    return LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)this.$namedUnwrappedElement);
                }
                {
                    this.$namedUnwrappedElement = psiNamedElement;
                    super(0);
                }
            });
        } else if (psiNamedElement instanceof KtParameter) {
            propertyAccessorsPsiMethods = (LightClassUtil.PropertyAccessorsPsiMethods)ApplicationUtilsKt.runReadAction((Function0)new Function0<LightClassUtil.PropertyAccessorsPsiMethods>(namedUnwrappedElement){
                final /* synthetic */ PsiNamedElement $namedUnwrappedElement;

                @NotNull
                public final LightClassUtil.PropertyAccessorsPsiMethods invoke() {
                    return LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtParameter)this.$namedUnwrappedElement);
                }
                {
                    this.$namedUnwrappedElement = psiNamedElement;
                    super(0);
                }
            });
        } else {
            throw (Throwable)new IllegalStateException("Can't be for element " + element2 + " there because of canProcessElement()");
        }
        LightClassUtil.PropertyAccessorsPsiMethods propertyMethods2 = propertyAccessorsPsiMethods;
        for (PsiMethod propertyMethod : propertyMethods2) {
            PsiElement psiElement2 = element2;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiNamedElement");
            }
            this.addRenameElements(propertyMethod, ((PsiNamedElement)psiElement2).getName(), newName2, allRenames, scope2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void renameElement(@Nullable PsiElement element2, @Nullable String newName2, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) {
        Unit unit;
        UsageInfo[] usageInfoArray;
        String string;
        PsiElement psiElement;
        RenameKotlinPropertyProcessor renameKotlinPropertyProcessor;
        block29: {
            Collection elements$iv;
            Object[] objectArray;
            RenameKotlinPropertyProcessor renameKotlinPropertyProcessor2;
            PsiElement psiElement2;
            String string2;
            UsageInfo[] $receiver$iv;
            block28: {
                UsageInfo[] usageInfoArray2;
                String string3;
                PsiElement psiElement3;
                RenameKotlinPropertyProcessor renameKotlinPropertyProcessor3;
                Collection thisCollection$iv;
                void refKindUsages;
                block27: {
                    block26: {
                        UsageInfo[] usageInfoArray3;
                        String string4;
                        PsiElement psiElement4;
                        RenameKotlinPropertyProcessor renameKotlinPropertyProcessor4;
                        block25: {
                            block24: {
                                void destination$iv$iv;
                                void $receiver$iv$iv;
                                Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
                                if (!(element2 instanceof KtProperty) && !(element2 instanceof KtParameter)) {
                                    super.renameElement(element2, newName2, usages2, listener2);
                                    return;
                                }
                                PsiElement psiElement5 = element2;
                                if (psiElement5 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                                }
                                String string5 = ((KtNamedDeclaration)psiElement5).getName();
                                if (string5 == null) {
                                    Intrinsics.throwNpe();
                                }
                                String name2 = string5;
                                String oldGetterName = JvmAbi.getterName(name2);
                                String oldSetterName = JvmAbi.setterName(name2);
                                Iterable iterable = ArraysKt.toList((Object[])usages2);
                                void var10_9 = $receiver$iv;
                                Map map2 = new LinkedHashMap();
                                for (Object element$iv$iv : $receiver$iv$iv) {
                                    Object object;
                                    void $receiver$iv$iv$iv;
                                    String string6;
                                    PsiElement refElement;
                                    UsageInfo usage = (UsageInfo)element$iv$iv;
                                    PsiReference psiReference = usage.getReference();
                                    Object object2 = refElement = psiReference != null ? psiReference.resolve() : null;
                                    UsageKind key$iv$iv = refElement instanceof PsiMethod ? (Intrinsics.areEqual((Object)(string6 = ((PsiMethod)refElement).getName()), (Object)oldGetterName) ? UsageKind.GETTER_USAGE : (Intrinsics.areEqual((Object)string6, (Object)oldSetterName) ? UsageKind.SETTER_USAGE : UsageKind.SIMPLE_PROPERTY_USAGE)) : UsageKind.SIMPLE_PROPERTY_USAGE;
                                    void var19_17 = destination$iv$iv;
                                    Object value$iv$iv$iv = $receiver$iv$iv$iv.get((Object)key$iv$iv);
                                    if (value$iv$iv$iv == null) {
                                        ArrayList answer$iv$iv$iv = new ArrayList();
                                        $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                        object = answer$iv$iv$iv;
                                    } else {
                                        object = value$iv$iv$iv;
                                    }
                                    List list$iv$iv = (List)object;
                                    list$iv$iv.add(element$iv$iv);
                                }
                                refKindUsages = destination$iv$iv;
                                renameKotlinPropertyProcessor4 = this;
                                psiElement4 = element2;
                                String string7 = newName2;
                                if (string7 == null) {
                                    Intrinsics.throwNpe();
                                }
                                string4 = JvmAbi.setterName(string7);
                                usageInfoArray3 = (UsageInfo[])refKindUsages.get((Object)UsageKind.SETTER_USAGE);
                                if (usageInfoArray3 == null) break block24;
                                $receiver$iv = usageInfoArray3;
                                string2 = string4;
                                psiElement2 = psiElement4;
                                renameKotlinPropertyProcessor2 = renameKotlinPropertyProcessor4;
                                if ($receiver$iv == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                                }
                                thisCollection$iv = (Collection)$receiver$iv;
                                UsageInfo[] usageInfoArray4 = thisCollection$iv.toArray(new UsageInfo[thisCollection$iv.size()]);
                                if (usageInfoArray4 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                                }
                                objectArray = usageInfoArray4;
                                renameKotlinPropertyProcessor4 = renameKotlinPropertyProcessor2;
                                psiElement4 = psiElement2;
                                string4 = string2;
                                usageInfoArray3 = (UsageInfo[])objectArray;
                                if (usageInfoArray3 != null) break block25;
                            }
                            $receiver$iv = new UsageInfo[]{};
                            string2 = string4;
                            psiElement2 = psiElement4;
                            renameKotlinPropertyProcessor2 = renameKotlinPropertyProcessor4;
                            objectArray = (Object[])elements$iv;
                            renameKotlinPropertyProcessor4 = renameKotlinPropertyProcessor2;
                            psiElement4 = psiElement2;
                            string4 = string2;
                            usageInfoArray3 = (UsageInfo[])objectArray;
                        }
                        super.renameElement(psiElement4, string4, usageInfoArray3, (RefactoringElementListener)null);
                        renameKotlinPropertyProcessor3 = this;
                        psiElement3 = element2;
                        string3 = JvmAbi.getterName(newName2);
                        usageInfoArray2 = (UsageInfo[])refKindUsages.get((Object)UsageKind.GETTER_USAGE);
                        if (usageInfoArray2 == null) break block26;
                        elements$iv = (Collection)usageInfoArray2;
                        string2 = string3;
                        psiElement2 = psiElement3;
                        renameKotlinPropertyProcessor2 = renameKotlinPropertyProcessor3;
                        if ($receiver$iv == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                        }
                        thisCollection$iv = (Collection)$receiver$iv;
                        UsageInfo[] usageInfoArray5 = thisCollection$iv.toArray(new UsageInfo[thisCollection$iv.size()]);
                        if (usageInfoArray5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        objectArray = usageInfoArray5;
                        renameKotlinPropertyProcessor3 = renameKotlinPropertyProcessor2;
                        psiElement3 = psiElement2;
                        string3 = string2;
                        usageInfoArray2 = (UsageInfo[])objectArray;
                        if (usageInfoArray2 != null) break block27;
                    }
                    $receiver$iv = new UsageInfo[]{};
                    string2 = string3;
                    psiElement2 = psiElement3;
                    renameKotlinPropertyProcessor2 = renameKotlinPropertyProcessor3;
                    objectArray = (Object[])elements$iv;
                    renameKotlinPropertyProcessor3 = renameKotlinPropertyProcessor2;
                    psiElement3 = psiElement2;
                    string3 = string2;
                    usageInfoArray2 = (UsageInfo[])objectArray;
                }
                super.renameElement(psiElement3, string3, usageInfoArray2, (RefactoringElementListener)null);
                renameKotlinPropertyProcessor = this;
                psiElement = element2;
                string = newName2;
                usageInfoArray = (UsageInfo[])refKindUsages.get((Object)UsageKind.SIMPLE_PROPERTY_USAGE);
                if (usageInfoArray == null) break block28;
                elements$iv = (Collection)usageInfoArray;
                string2 = string;
                psiElement2 = psiElement;
                renameKotlinPropertyProcessor2 = renameKotlinPropertyProcessor;
                if ($receiver$iv == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                thisCollection$iv = (Collection)$receiver$iv;
                UsageInfo[] usageInfoArray6 = thisCollection$iv.toArray(new UsageInfo[thisCollection$iv.size()]);
                if (usageInfoArray6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                objectArray = usageInfoArray6;
                renameKotlinPropertyProcessor = renameKotlinPropertyProcessor2;
                psiElement = psiElement2;
                string = string2;
                usageInfoArray = (UsageInfo[])objectArray;
                if (usageInfoArray != null) break block29;
            }
            $receiver$iv = new UsageInfo[]{};
            string2 = string;
            psiElement2 = psiElement;
            renameKotlinPropertyProcessor2 = renameKotlinPropertyProcessor;
            objectArray = (Object[])elements$iv;
            renameKotlinPropertyProcessor = renameKotlinPropertyProcessor2;
            psiElement = psiElement2;
            string = string2;
            usageInfoArray = (UsageInfo[])objectArray;
        }
        super.renameElement(psiElement, string, usageInfoArray, (RefactoringElementListener)null);
        JetRefactoringUtilKt.dropOverrideKeywordIfNecessary((KtNamedDeclaration)element2);
        RefactoringElementListener refactoringElementListener = listener2;
        if (refactoringElementListener != null) {
            refactoringElementListener.elementRenamed(element2);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addRenameElements(PsiMethod psiMethod, String oldName, String newName2, Map<PsiElement, String> allRenames, SearchScope scope2) {
        void $receiver$iv;
        if (psiMethod == null) {
            return;
        }
        Iterable iterable = (Iterable)OverridingMethodsSearch.search((PsiMethod)psiMethod, (SearchScope)scope2, (boolean)true);
        for (Object element$iv : $receiver$iv) {
            String value$iv;
            Map<PsiElement, String> $receiver$iv2;
            PsiMethod overrider = (PsiMethod)element$iv;
            PsiNamedElement overriderElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)overrider);
            if (overriderElement == null || overriderElement instanceof SyntheticElement) continue;
            RenameProcessor.assertNonCompileElement((PsiElement)((PsiElement)overriderElement));
            String overriderName = overriderElement.getName();
            if (overriderElement instanceof PsiMethod) {
                if (newName2 != null && Name.isValidIdentifier(newName2)) {
                    String string;
                    boolean isGetter = ((PsiMethod)overriderElement).getParameterList().getParametersCount() == 0;
                    Map<PsiElement, String> map2 = allRenames;
                    Intrinsics.checkExpressionValueIsNotNull((Object)(isGetter ? JvmAbi.getterName(newName2) : JvmAbi.setterName(newName2)), (String)"if (isGetter) JvmAbi.get\u2026vmAbi.setterName(newName)");
                    string = string;
                    $receiver$iv2.put((PsiElement)overriderElement, value$iv);
                }
                continue;
            }
            String newOverriderName = RefactoringUtil.suggestNewOverriderName((String)overriderName, (String)oldName, (String)newName2);
            if (newOverriderName == null) continue;
            $receiver$iv2 = allRenames;
            value$iv = newOverriderName;
            $receiver$iv2.put((PsiElement)overriderElement, value$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KtCallableDeclaration findDeepestOverriddenDeclaration(KtCallableDeclaration declaration) {
        KtModifierList ktModifierList = declaration.getModifierList();
        if (Intrinsics.areEqual((Object)(ktModifierList != null ? Boolean.valueOf(ktModifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD)) : null), (Object)true)) {
            BindingContext bindingContext2 = ResolutionUtils.analyze$default(declaration, null, 1, null);
            DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
            if (descriptor2 instanceof ValueParameterDescriptor) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)bindingContext2.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, descriptor2);
                if (propertyDescriptor == null) {
                    return declaration;
                }
                descriptor2 = propertyDescriptor;
            }
            if (descriptor2 != null) {
                Unit unit;
                boolean bl = descriptor2 instanceof PropertyDescriptor;
                if (_Assertions.ENABLED) {
                    void value$iv;
                    if (value$iv == false) {
                        String message$iv = "Property descriptor is expected";
                        throw (Throwable)((Object)new AssertionError((Object)message$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                DeclarationDescriptor declarationDescriptor = descriptor2;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                }
                Set<CallableMemberDescriptor> supers = OverrideResolver.getDeepestSuperDeclarations((CallableMemberDescriptor)((PropertyDescriptor)declarationDescriptor));
                PropertyDescriptor deepest = (PropertyDescriptor)CollectionsKt.first((Iterable)supers);
                if (Intrinsics.areEqual((Object)deepest, (Object)descriptor2) ^ true) {
                    DeclarationDescriptor declarationDescriptor2 = deepest;
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"deepest");
                    PsiElement superPsiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor2);
                    PsiElement psiElement = superPsiElement;
                    if (!(psiElement instanceof KtCallableDeclaration)) {
                        psiElement = null;
                    }
                    return (KtCallableDeclaration)psiElement;
                }
            }
        }
        return null;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPropertyProcessor$UsageKind;", "", "(Ljava/lang/String;I)V", "SIMPLE_PROPERTY_USAGE", "GETTER_USAGE", "SETTER_USAGE", "idea"})
    private static final class UsageKind
    extends Enum<UsageKind> {
        public static final /* enum */ UsageKind SIMPLE_PROPERTY_USAGE;
        public static final /* enum */ UsageKind GETTER_USAGE;
        public static final /* enum */ UsageKind SETTER_USAGE;
        private static final /* synthetic */ UsageKind[] $VALUES;

        static {
            UsageKind[] usageKindArray = new UsageKind[3];
            UsageKind[] usageKindArray2 = usageKindArray;
            usageKindArray[0] = SIMPLE_PROPERTY_USAGE = new UsageKind();
            usageKindArray[1] = GETTER_USAGE = new UsageKind();
            usageKindArray[2] = SETTER_USAGE = new UsageKind();
            $VALUES = usageKindArray;
        }

        public static UsageKind[] values() {
            return (UsageKind[])$VALUES.clone();
        }

        public static UsageKind valueOf(String string) {
            return Enum.valueOf(UsageKind.class, string);
        }
    }
}

