/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public class KtArrayAccessReference
extends KtSimpleReference<KtArrayAccessExpression>
implements MultiRangeReference {
    public KtArrayAccessReference(@NotNull KtArrayAccessExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/references/KtArrayAccessReference", "<init>"));
        }
        super(expression2);
    }

    public TextRange getRangeInElement() {
        return ((KtArrayAccessExpression)this.getElement()).getTextRange().shiftRight(-((KtArrayAccessExpression)this.getElement()).getTextOffset());
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> getTargetDescriptors(@NotNull BindingContext context) {
        ResolvedCall<FunctionDescriptor> setFunction;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/references/KtArrayAccessReference", "getTargetDescriptors"));
        }
        ArrayList result2 = Lists.newArrayList();
        ResolvedCall<FunctionDescriptor> getFunction = context.get(BindingContext.INDEXED_LVALUE_GET, this.getExpression());
        if (getFunction != null) {
            result2.add(getFunction.getCandidateDescriptor());
        }
        if ((setFunction = context.get(BindingContext.INDEXED_LVALUE_SET, this.getExpression())) != null) {
            result2.add(setFunction.getCandidateDescriptor());
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/references/KtArrayAccessReference", "getTargetDescriptors"));
        }
        return arrayList;
    }

    public List<TextRange> getRanges() {
        ArrayList<TextRange> list2 = new ArrayList<TextRange>();
        KtContainerNode indices = ((KtArrayAccessExpression)this.getExpression()).getIndicesNode();
        TextRange textRange = indices.getNode().findChildByType((IElementType)KtTokens.LBRACKET).getTextRange();
        TextRange lBracketRange = textRange.shiftRight(-((KtArrayAccessExpression)this.getExpression()).getTextOffset());
        list2.add(lBracketRange);
        ASTNode rBracket = indices.getNode().findChildByType((IElementType)KtTokens.RBRACKET);
        if (rBracket != null) {
            textRange = rBracket.getTextRange();
            TextRange rBracketRange = textRange.shiftRight(-((KtArrayAccessExpression)this.getExpression()).getTextOffset());
            list2.add(rBracketRange);
        }
        return list2;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@Nullable String newElementName) {
        return ReferenceUtilKt.renameImplicitConventionalCall(this, newElementName);
    }
}

