/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.AbstractTestClassConfigurationProducer;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017H\u0016J\u000e\u0010!\u001a\u00020\u0010*\u0004\u0018\u00010\tH\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinJUnitRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/intellij/execution/junit/JUnitConfiguration;", "()V", "getTestClass", "Lcom/intellij/psi/PsiClass;", "leaf", "Lcom/intellij/psi/PsiElement;", "getTestClassInFile", "Lorg/jetbrains/kotlin/psi/KtClass;", "jetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getTestMethodLocation", "Lcom/intellij/execution/Location;", "Lcom/intellij/psi/PsiMethod;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "onFirstRun", "", "fromContext", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "performRunnable", "Ljava/lang/Runnable;", "settingsMatchTemplate", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "shouldReplace", "self", "other", "isJUnitTestClass", "idea"})
public final class KotlinJUnitRunConfigurationProducer
extends RunConfigurationProducer<JUnitConfiguration> {
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkParameterIsNotNull((Object)self, (String)"self");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.isProducedBy(JUnitConfigurationProducer.class);
    }

    public boolean isConfigurationFromContext(@NotNull JUnitConfiguration configuration2, @NotNull ConfigurationContext context) {
        Location leaf;
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location location2 = context.getLocation();
        if (location2 == null || (location2 = location2.getPsiElement()) == null) {
            return false;
        }
        Location location3 = leaf = location2;
        Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"leaf");
        Location<PsiMethod> methodLocation = this.getTestMethodLocation((PsiElement)location3);
        Location location4 = leaf;
        Intrinsics.checkExpressionValueIsNotNull((Object)location4, (String)"leaf");
        PsiClass testClass = this.getTestClass((PsiElement)location4);
        TestObject testObject = configuration2.getTestObject();
        Location<PsiMethod> location5 = methodLocation;
        if (!testObject.isConfiguredByElement(configuration2, testClass, (PsiMethod)(location5 != null ? (PsiMethod)location5.getPsiElement() : null), (PsiPackage)null, (PsiDirectory)null)) {
            return false;
        }
        return this.settingsMatchTemplate(configuration2, context);
    }

    private final boolean settingsMatchTemplate(JUnitConfiguration configuration2, ConfigurationContext context) {
        String vmParameters;
        RunConfiguration predefinedConfiguration = context.getOriginalConfiguration((ConfigurationType)JUnitConfigurationType.getInstance());
        RunConfiguration runConfiguration = predefinedConfiguration;
        if (!(runConfiguration instanceof CommonJavaRunConfigurationParameters)) {
            runConfiguration = null;
        }
        CommonJavaRunConfigurationParameters commonJavaRunConfigurationParameters = (CommonJavaRunConfigurationParameters)runConfiguration;
        String string = vmParameters = commonJavaRunConfigurationParameters != null ? commonJavaRunConfigurationParameters.getVMParameters() : null;
        if (vmParameters != null && Intrinsics.areEqual((Object)configuration2.getVMParameters(), (Object)vmParameters) ^ true) {
            return false;
        }
        RunnerAndConfigurationSettings template = RunManager.getInstance((Project)configuration2.getProject()).getConfigurationTemplate(this.getConfigurationFactory());
        RunConfiguration runConfiguration2 = template.getConfiguration();
        if (runConfiguration2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.configurations.ModuleBasedConfiguration<*>");
        }
        Module predefinedModule = ((ModuleBasedConfiguration)runConfiguration2).getConfigurationModule().getModule();
        Module configurationModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
        Location location2 = context.getLocation();
        return Intrinsics.areEqual((Object)configurationModule, (Object)(location2 != null ? location2.getModule() : null)) || Intrinsics.areEqual((Object)configurationModule, (Object)predefinedModule);
    }

    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement leaf;
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        if (DumbService.getInstance((Project)context.getProject()).isDumb()) {
            return false;
        }
        Location location2 = context.getLocation();
        if (location2 == null) {
            return false;
        }
        Location location3 = location2;
        PsiElement psiElement = leaf = location3.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"leaf");
        if (!ProjectRootsUtil.isInProjectOrLibSource(psiElement)) {
            return false;
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return false;
        }
        PsiFile psiFile = leaf.getContainingFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile jetFile = (KtFile)psiFile;
        if (ProjectStructureUtil.isJsKotlinModule(jetFile)) {
            return false;
        }
        PsiElement psiElement2 = leaf;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"leaf");
        Location<PsiMethod> methodLocation = this.getTestMethodLocation(psiElement2);
        if (methodLocation != null) {
            Module originalModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
            configuration2.beMethodConfiguration(methodLocation);
            configuration2.restoreOriginalModule(originalModule);
            JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location3);
            return true;
        }
        PsiElement psiElement3 = leaf;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"leaf");
        PsiClass testClass = this.getTestClass(psiElement3);
        if (testClass != null) {
            Module originalModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
            configuration2.beClassConfiguration(testClass);
            configuration2.restoreOriginalModule(originalModule);
            JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location3);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void onFirstRun(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable) {
        PsiElement leaf;
        Intrinsics.checkParameterIsNotNull((Object)fromContext, (String)"fromContext");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)performRunnable, (String)"performRunnable");
        PsiElement psiElement = leaf = fromContext.getSourceElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"leaf");
        PsiClass psiClass = this.getTestClass(psiElement);
        if (psiClass != null) {
            void $receiver$iv;
            PsiClass psiClass2 = psiClass;
            PsiClass testClass = (PsiClass)$receiver$iv;
            ConfigurationFromContext fromContextSubstitute = new ConfigurationFromContext(testClass, fromContext, context, performRunnable){
                final /* synthetic */ PsiClass $testClass;
                final /* synthetic */ ConfigurationFromContext $fromContext$inlined;
                final /* synthetic */ ConfigurationContext $context$inlined;
                final /* synthetic */ Runnable $performRunnable$inlined;

                public RunnerAndConfigurationSettings getConfigurationSettings() {
                    return this.$fromContext$inlined.getConfigurationSettings();
                }

                public void setConfigurationSettings(RunnerAndConfigurationSettings configurationSettings) {
                    this.$fromContext$inlined.setConfigurationSettings(configurationSettings);
                }

                public PsiClass getSourceElement() {
                    return this.$testClass;
                }
                {
                    this.$testClass = psiClass;
                    this.$fromContext$inlined = configurationFromContext;
                    this.$context$inlined = configurationContext;
                    this.$performRunnable$inlined = runnable;
                }
            };
            new AbstractTestClassConfigurationProducer((ConfigurationType)JUnitConfigurationType.getInstance()){}.onFirstRun(fromContextSubstitute, context, performRunnable);
            return;
        }
        super.onFirstRun(fromContext, context, performRunnable);
    }

    /*
     * WARNING - void declaration
     */
    private final Location<PsiMethod> getTestMethodLocation(PsiElement leaf) {
        void strict$iv;
        void $receiver$iv;
        PsiElement psiElement = leaf;
        boolean bl = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtNamedFunction.class, (boolean)strict$iv);
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction function2 = ktNamedFunction;
        KtTypeParameterListOwner owner = (KtTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)function2, (Class[])new Class[]{KtFunction.class, KtClass.class});
        if (owner instanceof KtClass) {
            Object v2;
            block6: {
                void $receiver$iv2;
                KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)owner);
                if (ktLightClass == null) {
                    return null;
                }
                KtLightClass delegate2 = ktLightClass;
                Object[] objectArray = delegate2.getMethods();
                for (int i = 0; i < ((void)$receiver$iv2).length; ++i) {
                    void element$iv = $receiver$iv2[i];
                    PsiMethod it = (PsiMethod)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getNavigationElement(), (Object)function2)) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            PsiMethod psiMethod = v2;
            if (psiMethod == null) {
                return null;
            }
            PsiMethod method = psiMethod;
            Location methodLocation = PsiLocation.fromPsiElement((PsiElement)((PsiElement)method));
            if (JUnitUtil.isTestMethod((Location)methodLocation, (boolean)false)) {
                return methodLocation;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiClass getTestClass(PsiElement leaf) {
        void strict$iv;
        void $receiver$iv;
        PsiFile psiFile = leaf.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return null;
        }
        KtFile containingFile = ktFile;
        PsiElement psiElement = leaf;
        boolean bl = false;
        KtClass jetClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, (boolean)strict$iv);
        if (!this.isJUnitTestClass(jetClass)) {
            jetClass = this.getTestClassInFile(containingFile);
        }
        KtClass ktClass = jetClass;
        return ktClass != null ? LightClassUtilsKt.toLightClass(ktClass) : null;
    }

    private final boolean isJUnitTestClass(KtClass $receiver) {
        boolean bl;
        Object object = $receiver;
        if (object != null && (object = LightClassUtilsKt.toLightClass((KtClassOrObject)object)) != null) {
            Object $receiver$iv = object;
            KtLightClass it = (KtLightClass)$receiver$iv;
            bl = JUnitUtil.isTestClass((PsiClass)it, (boolean)false, (boolean)true);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final KtClass getTestClassInFile(KtFile jetFile) {
        Iterable iterable;
        block3: {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = jetFile.getDeclarations();
            Iterable iterable2 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof KtClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                KtClass it = (KtClass)element$iv;
                if (!this.isJUnitTestClass(it)) continue;
                if (found$iv) {
                    iterable = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            iterable = !found$iv ? null : iterable2;
        }
        return (KtClass)((Object)iterable);
    }

    public KotlinJUnitRunConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }
}

