/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMemberImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;
import org.jetbrains.kotlin.name.Name;

public class JavaMethodImpl
extends JavaMemberImpl<PsiMethod>
implements JavaMethod {
    public JavaMethodImpl(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/kotlin/load/java/structure/impl/JavaMethodImpl", "<init>"));
        }
        super(psiMethod);
        assert (!psiMethod.isConstructor()) : "PsiMethod which is a constructor should be wrapped in JavaConstructorImpl: " + psiMethod.getName();
    }

    @Override
    @NotNull
    public Name getName() {
        Name name2 = Name.identifier(((PsiMethod)this.getPsi()).getName());
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaMethodImpl", "getName"));
        }
        return name2;
    }

    @Override
    @NotNull
    public List<JavaTypeParameter> getTypeParameters() {
        List<JavaTypeParameter> list2 = JavaElementCollectionFromPsiArrayUtil.typeParameters(((PsiMethod)this.getPsi()).getTypeParameters());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaMethodImpl", "getTypeParameters"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<JavaValueParameter> getValueParameters() {
        List<JavaValueParameter> list2 = JavaElementCollectionFromPsiArrayUtil.valueParameters(((PsiMethod)this.getPsi()).getParameterList().getParameters());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaMethodImpl", "getValueParameters"));
        }
        return list2;
    }

    @Override
    public boolean hasAnnotationParameterDefaultValue() {
        PsiMethod psiMethod = (PsiMethod)this.getPsi();
        return psiMethod instanceof PsiAnnotationMethod && ((PsiAnnotationMethod)psiMethod).getDefaultValue() != null;
    }

    @Override
    @NotNull
    public JavaType getReturnType() {
        PsiType psiType = ((PsiMethod)this.getPsi()).getReturnType();
        assert (psiType != null) : "Method is not a constructor and has no return type: " + this.getName();
        JavaTypeImpl<?> javaTypeImpl = JavaTypeImpl.create(psiType);
        if (javaTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaMethodImpl", "getReturnType"));
        }
        return javaTypeImpl;
    }
}

