/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.kdoc.psi.api.KDocElement;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public class KtPsiUtil {
    public static final Predicate<KtElement> ANY_JET_ELEMENT = new Predicate<KtElement>(){

        public boolean apply(@Nullable KtElement input) {
            return true;
        }
    };

    private KtPsiUtil() {
    }

    public static <D> void visitChildren(@NotNull KtElement element2, @NotNull KtVisitor<Void, D> visitor2, D data) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil", "visitChildren"));
        }
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtPsiUtil", "visitChildren"));
        }
        for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof KtElement)) continue;
            ((KtElement)child).accept(visitor2, data);
        }
    }

    @NotNull
    public static KtExpression safeDeparenthesize(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/KtPsiUtil", "safeDeparenthesize"));
        }
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression2);
        KtExpression ktExpression = deparenthesized != null ? deparenthesized : expression2;
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPsiUtil", "safeDeparenthesize"));
        }
        return ktExpression;
    }

    @Nullable
    public static KtExpression deparenthesize(@Nullable KtExpression expression2) {
        KtExpression baseExpression;
        while ((baseExpression = KtPsiUtil.deparenthesizeOnce(expression2)) != expression2) {
            expression2 = baseExpression;
        }
        return baseExpression;
    }

    @Nullable
    public static KtExpression deparenthesizeOnce(@Nullable KtExpression expression2) {
        if (expression2 instanceof KtAnnotatedExpression) {
            return ((KtAnnotatedExpression)expression2).getBaseExpression();
        }
        if (expression2 instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression2).getBaseExpression();
        }
        if (expression2 instanceof KtExpressionWrapper) {
            return ((KtExpressionWrapper)((Object)expression2)).getBaseExpression();
        }
        if (expression2 instanceof KtParenthesizedExpression) {
            return ((KtParenthesizedExpression)expression2).getExpression();
        }
        return expression2;
    }

    @NotNull
    public static Name safeName(@Nullable String name2) {
        Name name3 = name2 == null ? SpecialNames.NO_NAME_PROVIDED : Name.identifier(name2);
        if (name3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPsiUtil", "safeName"));
        }
        return name3;
    }

    @NotNull
    public static Set<KtElement> findRootExpressions(@NotNull Collection<KtElement> unreachableElements) {
        if (unreachableElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unreachableElements", "org/jetbrains/kotlin/psi/KtPsiUtil", "findRootExpressions"));
        }
        HashSet<KtElement> rootElements = new HashSet<KtElement>();
        final HashSet shadowedElements = new HashSet();
        KtVisitorVoid shadowAllChildren = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element2) {
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil$1", "visitKtElement"));
                }
                if (shadowedElements.add(element2)) {
                    element2.acceptChildren(this);
                }
            }
        };
        for (KtElement element2 : unreachableElements) {
            if (shadowedElements.contains(element2)) continue;
            element2.acceptChildren(shadowAllChildren);
            rootElements.removeAll(shadowedElements);
            rootElements.add(element2);
        }
        HashSet<KtElement> hashSet = rootElements;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPsiUtil", "findRootExpressions"));
        }
        return hashSet;
    }

    @NotNull
    public static String unquoteIdentifier(@NotNull String quoted) {
        if (quoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "org/jetbrains/kotlin/psi/KtPsiUtil", "unquoteIdentifier"));
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPsiUtil", "unquoteIdentifier"));
            }
            return string;
        }
        if (quoted.startsWith("`") && quoted.endsWith("`") && quoted.length() >= 2) {
            String string = quoted.substring(1, quoted.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPsiUtil", "unquoteIdentifier"));
            }
            return string;
        }
        String string = quoted;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPsiUtil", "unquoteIdentifier"));
        }
        return string;
    }

    @NotNull
    public static String unquoteIdentifierOrFieldReference(@NotNull String quoted) {
        if (quoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "org/jetbrains/kotlin/psi/KtPsiUtil", "unquoteIdentifierOrFieldReference"));
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPsiUtil", "unquoteIdentifierOrFieldReference"));
            }
            return string;
        }
        if (quoted.startsWith("$")) {
            String string = "$" + KtPsiUtil.unquoteIdentifier(quoted.substring(1));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPsiUtil", "unquoteIdentifierOrFieldReference"));
            }
            return string;
        }
        String string = KtPsiUtil.unquoteIdentifier(quoted);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPsiUtil", "unquoteIdentifierOrFieldReference"));
        }
        return string;
    }

    @Nullable
    public static FqName toQualifiedName(@NotNull KtUserType userType) {
        if (userType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userType", "org/jetbrains/kotlin/psi/KtPsiUtil", "toQualifiedName"));
        }
        ArrayList reversedNames = Lists.newArrayList();
        for (KtUserType current = userType; current != null; current = current.getQualifier()) {
            String name2 = current.getReferencedName();
            if (name2 == null) {
                return null;
            }
            reversedNames.add(name2);
        }
        return FqName.fromSegments(ContainerUtil.reverse((List)reversedNames));
    }

    @Nullable
    public static Name getShortName(@NotNull KtAnnotationEntry annotation2) {
        KtUserType userType;
        String shortName;
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/psi/KtPsiUtil", "getShortName"));
        }
        KtTypeReference typeReference = annotation2.getTypeReference();
        assert (typeReference != null) : "Annotation entry hasn't typeReference " + annotation2.getText();
        KtTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement instanceof KtUserType && (shortName = (userType = (KtUserType)typeElement).getReferencedName()) != null) {
            return Name.identifier(shortName);
        }
        return null;
    }

    public static boolean isDeprecated(@NotNull KtModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/psi/KtPsiUtil", "isDeprecated"));
        }
        KtModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            List<KtAnnotationEntry> annotationEntries = modifierList.getAnnotationEntries();
            for (KtAnnotationEntry annotation2 : annotationEntries) {
                Name shortName = KtPsiUtil.getShortName(annotation2);
                if (!KotlinBuiltIns.FQ_NAMES.deprecated.shortName().equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getDirectParentOfTypeForBlock(@NotNull KtBlockExpression block, @NotNull Class<T> aClass2) {
        KtFunctionLiteral functionLiteral;
        KtIfExpression ifExpression2;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/psi/KtPsiUtil", "getDirectParentOfTypeForBlock"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/psi/KtPsiUtil", "getDirectParentOfTypeForBlock"));
        }
        PsiElement parent2 = PsiTreeUtil.getParentOfType((PsiElement)block, aClass2);
        if (parent2 instanceof KtIfExpression && ((ifExpression2 = (KtIfExpression)parent2).getElse() == block || ifExpression2.getThen() == block)) {
            return (T)parent2;
        }
        if (parent2 instanceof KtWhenExpression) {
            KtWhenExpression whenExpression2 = (KtWhenExpression)parent2;
            for (KtWhenEntry whenEntry : whenExpression2.getEntries()) {
                if (whenEntry.getExpression() != block) continue;
                return (T)parent2;
            }
        }
        if (parent2 instanceof KtFunctionLiteral && (functionLiteral = (KtFunctionLiteral)parent2).getBodyExpression() == block) {
            return (T)parent2;
        }
        if (parent2 instanceof KtTryExpression) {
            KtTryExpression tryExpression = (KtTryExpression)parent2;
            if (tryExpression.getTryBlock() == block) {
                return (T)parent2;
            }
            for (KtCatchClause clause : tryExpression.getCatchClauses()) {
                if (clause.getCatchBody() != block) continue;
                return (T)parent2;
            }
        }
        return null;
    }

    @Nullable
    public static Name getAliasName(@NotNull KtImportDirective importDirective) {
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/kotlin/psi/KtPsiUtil", "getAliasName"));
        }
        if (importDirective.isAllUnder()) {
            return null;
        }
        String aliasName = importDirective.getAliasName();
        KtExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return null;
        }
        KtSimpleNameExpression referenceExpression = KtPsiUtil.getLastReference(importedReference);
        if (aliasName == null) {
            aliasName = referenceExpression != null ? referenceExpression.getReferencedName() : null;
        }
        return aliasName != null && !aliasName.isEmpty() ? Name.identifier(aliasName) : null;
    }

    @Nullable
    public static KtSimpleNameExpression getLastReference(@NotNull KtExpression importedReference) {
        if (importedReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedReference", "org/jetbrains/kotlin/psi/KtPsiUtil", "getLastReference"));
        }
        KtElement selector = KtPsiUtilKt.getQualifiedElementSelector(importedReference);
        return selector instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)selector : null;
    }

    public static boolean isSelectorInQualified(@NotNull KtSimpleNameExpression nameExpression) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/psi/KtPsiUtil", "isSelectorInQualified"));
        }
        KtElement qualifiedElement = KtPsiUtilKt.getQualifiedElement(nameExpression);
        return qualifiedElement instanceof KtQualifiedExpression || qualifiedElement instanceof KtUserType && ((KtUserType)qualifiedElement).getQualifier() != null;
    }

    public static boolean isLHSOfDot(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/KtPsiUtil", "isLHSOfDot"));
        }
        PsiElement parent2 = expression2.getParent();
        if (!(parent2 instanceof KtQualifiedExpression)) {
            return false;
        }
        KtQualifiedExpression qualifiedParent = (KtQualifiedExpression)parent2;
        return qualifiedParent.getReceiverExpression() == expression2 || KtPsiUtil.isLHSOfDot(qualifiedParent);
    }

    public static boolean isScriptDeclaration(@NotNull KtDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/KtPsiUtil", "isScriptDeclaration"));
        }
        return KtPsiUtil.getScript(namedDeclaration) != null;
    }

    @Nullable
    public static KtScript getScript(@NotNull KtDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/KtPsiUtil", "getScript"));
        }
        PsiElement parent2 = namedDeclaration.getParent();
        if (parent2 != null && parent2.getParent() instanceof KtScript) {
            return (KtScript)parent2.getParent();
        }
        return null;
    }

    public static boolean isVariableNotParameterDeclaration(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/KtPsiUtil", "isVariableNotParameterDeclaration"));
        }
        if (!(declaration instanceof KtVariableDeclaration)) {
            return false;
        }
        if (declaration instanceof KtProperty) {
            return true;
        }
        assert (declaration instanceof KtDestructuringDeclarationEntry);
        KtDestructuringDeclarationEntry multiDeclarationEntry = (KtDestructuringDeclarationEntry)declaration;
        return !(multiDeclarationEntry.getParent().getParent() instanceof KtForExpression);
    }

    @Nullable
    public static Name getConventionName(@NotNull KtSimpleNameExpression simpleNameExpression) {
        IElementType elementType;
        if (simpleNameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleNameExpression", "org/jetbrains/kotlin/psi/KtPsiUtil", "getConventionName"));
        }
        if (simpleNameExpression.getIdentifier() != null) {
            return simpleNameExpression.getReferencedNameAsName();
        }
        PsiElement firstChild = simpleNameExpression.getFirstChild();
        if (firstChild != null && (elementType = firstChild.getNode().getElementType()) instanceof KtToken) {
            KtToken jetToken = (KtToken)elementType;
            boolean isPrefixExpression = simpleNameExpression.getParent() instanceof KtPrefixExpression;
            if (isPrefixExpression) {
                return OperatorConventions.getNameForOperationSymbol(jetToken, true, false);
            }
            return OperatorConventions.getNameForOperationSymbol(jetToken);
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement getTopmostParentOfTypes(@Nullable PsiElement element2, Class<? extends PsiElement> ... parentTypes) {
        PsiElement next2;
        if (parentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentTypes", "org/jetbrains/kotlin/psi/KtPsiUtil", "getTopmostParentOfTypes"));
        }
        if (element2 instanceof PsiFile) {
            return null;
        }
        PsiElement answer = PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])parentTypes);
        if (answer instanceof PsiFile) {
            return answer;
        }
        while ((next2 = PsiTreeUtil.getParentOfType((PsiElement)answer, (Class[])parentTypes)) != null) {
            answer = next2;
        }
        return answer;
    }

    public static boolean isNullConstant(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/KtPsiUtil", "isNullConstant"));
        }
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression2);
        return deparenthesized instanceof KtConstantExpression && deparenthesized.getNode().getElementType() == KtNodeTypes.NULL;
    }

    public static boolean isTrueConstant(@Nullable KtExpression condition2) {
        return condition2 != null && condition2.getNode().getElementType() == KtNodeTypes.BOOLEAN_CONSTANT && condition2.getNode().findChildByType((IElementType)KtTokens.TRUE_KEYWORD) != null;
    }

    public static boolean isAbstract(@NotNull KtDeclarationWithBody declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/KtPsiUtil", "isAbstract"));
        }
        return declaration.getBodyExpression() == null;
    }

    public static boolean isBackingFieldReference(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof SyntheticFieldDescriptor;
    }

    @Nullable
    public static KtExpression getExpressionOrLastStatementInBlock(@Nullable KtExpression expression2) {
        if (expression2 instanceof KtBlockExpression) {
            return KtPsiUtil.getLastStatementInABlock((KtBlockExpression)expression2);
        }
        return expression2;
    }

    @Nullable
    public static KtExpression getLastStatementInABlock(@Nullable KtBlockExpression blockExpression) {
        if (blockExpression == null) {
            return null;
        }
        List<KtExpression> statements = blockExpression.getStatements();
        return statements.isEmpty() ? null : statements.get(statements.size() - 1);
    }

    public static boolean isTrait(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/psi/KtPsiUtil", "isTrait"));
        }
        return classOrObject instanceof KtClass && ((KtClass)classOrObject).isInterface();
    }

    @Nullable
    public static KtClassOrObject getOutermostClassOrObject(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/psi/KtPsiUtil", "getOutermostClassOrObject"));
        }
        KtClassOrObject current = classOrObject;
        while (true) {
            PsiElement parent2 = current.getParent();
            assert (classOrObject.getParent() != null) : "Class with no parent: " + classOrObject.getText();
            if (parent2 instanceof PsiFile) {
                return current;
            }
            if (!(parent2 instanceof KtClassBody)) {
                return current;
            }
            current = (KtClassOrObject)parent2.getParent();
        }
    }

    @Nullable
    public static KtClassOrObject getClassIfParameterIsProperty(@NotNull KtParameter jetParameter) {
        PsiElement grandParent;
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/kotlin/psi/KtPsiUtil", "getClassIfParameterIsProperty"));
        }
        if (jetParameter.hasValOrVar() && (grandParent = jetParameter.getParent().getParent()) instanceof KtPrimaryConstructor) {
            return ((KtPrimaryConstructor)grandParent).getContainingClassOrObject();
        }
        return null;
    }

    @Nullable
    private static IElementType getOperation(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/KtPsiUtil", "getOperation"));
        }
        if (expression2 instanceof KtQualifiedExpression) {
            return ((KtQualifiedExpression)expression2).getOperationSign();
        }
        if (expression2 instanceof KtOperationExpression) {
            return ((KtOperationExpression)expression2).getOperationReference().getReferencedNameElementType();
        }
        return null;
    }

    private static int getPriority(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/KtPsiUtil", "getPriority"));
        }
        int maxPriority = KotlinExpressionParsing.Precedence.values().length + 1;
        if (expression2 instanceof KtPostfixExpression || expression2 instanceof KtQualifiedExpression || expression2 instanceof KtCallExpression || expression2 instanceof KtArrayAccessExpression) {
            return maxPriority - 1;
        }
        if (expression2 instanceof KtPrefixExpression || expression2 instanceof KtLabeledExpression) {
            return maxPriority - 2;
        }
        if (expression2 instanceof KtIfExpression) {
            return KotlinExpressionParsing.Precedence.ASSIGNMENT.ordinal();
        }
        if (expression2 instanceof KtSuperExpression) {
            return maxPriority;
        }
        if (expression2 instanceof KtDeclaration || expression2 instanceof KtStatementExpression) {
            return 0;
        }
        IElementType operation = KtPsiUtil.getOperation(expression2);
        for (KotlinExpressionParsing.Precedence precedence : KotlinExpressionParsing.Precedence.values()) {
            if (precedence == KotlinExpressionParsing.Precedence.PREFIX || precedence == KotlinExpressionParsing.Precedence.POSTFIX || !precedence.getOperations().contains(operation)) continue;
            return maxPriority - precedence.ordinal() - 1;
        }
        return maxPriority;
    }

    public static boolean areParenthesesUseless(@NotNull KtParenthesizedExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/KtPsiUtil", "areParenthesesUseless"));
        }
        KtExpression innerExpression = expression2.getExpression();
        if (innerExpression == null) {
            return true;
        }
        PsiElement parent2 = expression2.getParent();
        if (!(parent2 instanceof KtExpression)) {
            return true;
        }
        return !KtPsiUtil.areParenthesesNecessary(innerExpression, expression2, (KtExpression)parent2);
    }

    public static boolean areParenthesesNecessary(@NotNull KtExpression innerExpression, @NotNull KtExpression currentInner, @NotNull KtElement parentElement) {
        int parentPriority;
        if (innerExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerExpression", "org/jetbrains/kotlin/psi/KtPsiUtil", "areParenthesesNecessary"));
        }
        if (currentInner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInner", "org/jetbrains/kotlin/psi/KtPsiUtil", "areParenthesesNecessary"));
        }
        if (parentElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentElement", "org/jetbrains/kotlin/psi/KtPsiUtil", "areParenthesesNecessary"));
        }
        if (parentElement instanceof KtParenthesizedExpression || innerExpression instanceof KtParenthesizedExpression) {
            return false;
        }
        if (parentElement instanceof KtPackageDirective) {
            return false;
        }
        if (parentElement instanceof KtWhenExpression || innerExpression instanceof KtWhenExpression) {
            return false;
        }
        if (innerExpression instanceof KtIfExpression) {
            if (parentElement instanceof KtQualifiedExpression) {
                return true;
            }
            KtElement current = parentElement;
            while (!(current instanceof KtBlockExpression || current instanceof KtDeclaration || current instanceof KtStatementExpression)) {
                if (current.getTextRange().getEndOffset() != currentInner.getTextRange().getEndOffset()) {
                    return current.getText().charAt(current.getTextLength() - 1) != ')';
                }
                current = current.getParent();
            }
        }
        if (parentElement instanceof KtCallExpression && currentInner == ((KtCallExpression)parentElement).getCalleeExpression()) {
            if (innerExpression instanceof KtSimpleNameExpression) {
                return false;
            }
            if (KtPsiUtilKt.getQualifiedExpressionForSelector(parentElement) != null) {
                return true;
            }
            return !(innerExpression instanceof KtThisExpression) && !(innerExpression instanceof KtArrayAccessExpression) && !(innerExpression instanceof KtConstantExpression) && !(innerExpression instanceof KtStringTemplateExpression) && !(innerExpression instanceof KtCallExpression);
        }
        if (parentElement instanceof KtValueArgument) {
            KtExpression nextExpression;
            KtValueArgument nextArg = (KtValueArgument)PsiTreeUtil.getNextSiblingOfType((PsiElement)parentElement, KtValueArgument.class);
            KtExpression ktExpression = nextExpression = nextArg != null ? nextArg.getArgumentExpression() : null;
            if (innerExpression instanceof KtBinaryExpression && ((KtBinaryExpression)innerExpression).getOperationToken() == KtTokens.LT && nextExpression instanceof KtBinaryExpression && ((KtBinaryExpression)nextExpression).getOperationToken() == KtTokens.GT) {
                return true;
            }
        }
        if (!(parentElement instanceof KtExpression)) {
            return false;
        }
        IElementType innerOperation = KtPsiUtil.getOperation(innerExpression);
        IElementType parentOperation = KtPsiUtil.getOperation((KtExpression)parentElement);
        if (parentElement instanceof KtReturnExpression && (innerExpression instanceof KtLabeledExpression || innerExpression instanceof KtAnnotatedExpression)) {
            return true;
        }
        if (innerExpression instanceof KtBinaryExpressionWithTypeRHS && parentOperation == KtTokens.LT) {
            return true;
        }
        if (parentElement instanceof KtLabeledExpression) {
            return false;
        }
        if (parentElement instanceof KtBinaryExpression && parentOperation == KtTokens.ELVIS && currentInner == ((KtBinaryExpression)parentElement).getRight()) {
            return false;
        }
        int innerPriority = KtPsiUtil.getPriority(innerExpression);
        if (innerPriority == (parentPriority = KtPsiUtil.getPriority((KtExpression)parentElement))) {
            if (parentElement instanceof KtBinaryExpression) {
                if (innerOperation == KtTokens.ANDAND || innerOperation == KtTokens.OROR) {
                    return false;
                }
                return ((KtBinaryExpression)parentElement).getRight() == currentInner;
            }
            if (parentElement instanceof KtPrefixExpression && innerExpression instanceof KtPrefixExpression) {
                return innerOperation == parentOperation && (innerOperation == KtTokens.PLUS || innerOperation == KtTokens.MINUS);
            }
            return false;
        }
        return innerPriority < parentPriority;
    }

    public static boolean isAssignment(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil", "isAssignment"));
        }
        return element2 instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element2).getOperationToken());
    }

    public static boolean isOrdinaryAssignment(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil", "isOrdinaryAssignment"));
        }
        return element2 instanceof KtBinaryExpression && ((KtBinaryExpression)element2).getOperationToken().equals((Object)KtTokens.EQ);
    }

    public static boolean checkVariableDeclarationInBlock(@NotNull KtBlockExpression block, @NotNull String varName) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/psi/KtPsiUtil", "checkVariableDeclarationInBlock"));
        }
        if (varName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varName", "org/jetbrains/kotlin/psi/KtPsiUtil", "checkVariableDeclarationInBlock"));
        }
        for (KtExpression element2 : block.getStatements()) {
            if (!(element2 instanceof KtVariableDeclaration) || !((KtVariableDeclaration)element2).getNameAsSafeName().asString().equals(varName)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWhenExpressionHasSingleElse(@NotNull KtWhenExpression whenExpression2) {
        if (whenExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/kotlin/psi/KtPsiUtil", "checkWhenExpressionHasSingleElse"));
        }
        int elseCount = 0;
        for (KtWhenEntry entry : whenExpression2.getEntries()) {
            if (!entry.isElse()) continue;
            ++elseCount;
        }
        return elseCount == 1;
    }

    @Nullable
    public static PsiElement skipTrailingWhitespacesAndComments(@Nullable PsiElement element2) {
        return PsiTreeUtil.skipSiblingsForward((PsiElement)element2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
    }

    @Nullable
    public static PsiElement prevLeafIgnoringWhitespaceAndComments(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil", "prevLeafIgnoringWhitespaceAndComments"));
        }
        PsiElement prev2 = PsiTreeUtil.prevLeaf((PsiElement)element2, (boolean)true);
        while (prev2 != null && KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(prev2.getNode().getElementType())) {
            prev2 = PsiTreeUtil.prevLeaf((PsiElement)prev2, (boolean)true);
        }
        return prev2;
    }

    @Nullable
    public static PsiElement getPreviousWord(@NotNull PsiElement element2, @NotNull String word, @NotNull TokenSet suffixTokens) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil", "getPreviousWord"));
        }
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "org/jetbrains/kotlin/psi/KtPsiUtil", "getPreviousWord"));
        }
        if (suffixTokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixTokens", "org/jetbrains/kotlin/psi/KtPsiUtil", "getPreviousWord"));
        }
        PsiElement prev2 = KtPsiUtil.prevLeafIgnoringWhitespaceAndComments(element2);
        if (prev2 != null && suffixTokens.contains(prev2.getNode().getElementType())) {
            prev2 = PsiTreeUtil.prevLeaf((PsiElement)prev2, (boolean)false);
        }
        if (prev2 != null && prev2.getNode().getElementType() == KtTokens.IDENTIFIER && word.equals(prev2.getText())) {
            return prev2;
        }
        return null;
    }

    @NotNull
    public static String getText(@Nullable PsiElement element2) {
        String string = element2 != null ? element2.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPsiUtil", "getText"));
        }
        return string;
    }

    @Nullable
    public static String getNullableText(@Nullable PsiElement element2) {
        return element2 != null ? element2.getText() : null;
    }

    public static boolean isInComment(PsiElement element2) {
        return CommentUtilCore.isComment((PsiElement)element2) || element2 instanceof KDocElement;
    }

    @Nullable
    public static PsiElement getOutermostParent(@NotNull PsiElement element2, @NotNull PsiElement upperBound, boolean strict) {
        PsiElement parent2;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil", "getOutermostParent"));
        }
        if (upperBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperBound", "org/jetbrains/kotlin/psi/KtPsiUtil", "getOutermostParent"));
        }
        PsiElement psiElement = parent2 = strict ? element2.getParent() : element2;
        while (parent2 != null && parent2.getParent() != upperBound) {
            parent2 = parent2.getParent();
        }
        return parent2;
    }

    public static <T extends PsiElement> T getLastChildByType(@NotNull PsiElement root, Class<? extends T> ... elementTypes) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/psi/KtPsiUtil", "getLastChildByType"));
        }
        if (elementTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementTypes", "org/jetbrains/kotlin/psi/KtPsiUtil", "getLastChildByType"));
        }
        PsiElement[] children2 = root.getChildren();
        for (int i = children2.length - 1; i >= 0; --i) {
            if (!PsiTreeUtil.instanceOf((Object)children2[i], (Class[])elementTypes)) continue;
            return (T)children2[i];
        }
        return null;
    }

    @Nullable
    public static KtElement getOutermostDescendantElement(@Nullable PsiElement root, boolean first, final @NotNull Predicate<KtElement> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "org/jetbrains/kotlin/psi/KtPsiUtil", "getOutermostDescendantElement"));
        }
        if (!(root instanceof KtElement)) {
            return null;
        }
        final ArrayList results2 = Lists.newArrayList();
        root.accept((PsiElementVisitor)new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element2) {
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil$3", "visitKtElement"));
                }
                if (predicate.apply((Object)element2)) {
                    results2.add(element2);
                } else {
                    element2.acceptChildren(this);
                }
            }
        });
        if (results2.isEmpty()) {
            return null;
        }
        return first ? (KtElement)results2.get(0) : (KtElement)results2.get(results2.size() - 1);
    }

    @Nullable
    public static PsiElement findChildByType(@NotNull PsiElement element2, @NotNull IElementType type2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil", "findChildByType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/psi/KtPsiUtil", "findChildByType"));
        }
        ASTNode node = element2.getNode().findChildByType(type2);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public static PsiElement skipSiblingsBackwardByPredicate(@Nullable PsiElement element2, Predicate<PsiElement> elementsToSkip) {
        if (element2 == null) {
            return null;
        }
        for (PsiElement e = element2.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (elementsToSkip.apply((Object)e)) continue;
            return e;
        }
        return null;
    }

    public static PsiElement ascendIfPropertyAccessor(PsiElement element2) {
        if (element2 instanceof KtPropertyAccessor) {
            return element2.getParent();
        }
        return element2;
    }

    @Nullable
    public static KtModifierList replaceModifierList(@NotNull KtModifierListOwner owner, @Nullable KtModifierList modifierList) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/psi/KtPsiUtil", "replaceModifierList"));
        }
        KtModifierList oldModifierList = owner.getModifierList();
        if (modifierList == null) {
            if (oldModifierList != null) {
                oldModifierList.delete();
            }
            return null;
        }
        if (oldModifierList == null) {
            PsiElement firstChild = owner.getFirstChild();
            return (KtModifierList)owner.addBefore((PsiElement)modifierList, firstChild);
        }
        return (KtModifierList)oldModifierList.replace((PsiElement)modifierList);
    }

    @Nullable
    public static String getPackageName(@NotNull KtElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil", "getPackageName"));
        }
        KtFile file = element2.getContainingKtFile();
        KtPackageDirective header = (KtPackageDirective)PsiTreeUtil.findChildOfType((PsiElement)file, KtPackageDirective.class);
        return header != null ? header.getQualifiedName() : null;
    }

    @Nullable
    public static KtElement getEnclosingElementForLocalDeclaration(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/KtPsiUtil", "getEnclosingElementForLocalDeclaration"));
        }
        return KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration, true);
    }

    private static boolean isMemberOfObjectExpression(@NotNull KtCallableDeclaration propertyOrFunction) {
        if (propertyOrFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyOrFunction", "org/jetbrains/kotlin/psi/KtPsiUtil", "isMemberOfObjectExpression"));
        }
        PsiElement parent2 = PsiTreeUtil.getStubOrPsiParent((PsiElement)propertyOrFunction);
        if (!(parent2 instanceof KtClassBody)) {
            return false;
        }
        PsiElement grandparent = PsiTreeUtil.getStubOrPsiParent((PsiElement)parent2);
        if (!(grandparent instanceof KtObjectDeclaration)) {
            return false;
        }
        return PsiTreeUtil.getStubOrPsiParent((PsiElement)grandparent) instanceof KtObjectLiteralExpression;
    }

    @Nullable
    public static KtElement getEnclosingElementForLocalDeclaration(@NotNull KtDeclaration declaration, boolean skipParameters) {
        PsiElement parent2;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/KtPsiUtil", "getEnclosingElementForLocalDeclaration"));
        }
        if (declaration instanceof KtTypeParameter && skipParameters) {
            declaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)declaration, KtNamedDeclaration.class);
        } else if (declaration instanceof KtParameter) {
            KtFunctionType functionType = (KtFunctionType)PsiTreeUtil.getParentOfType((PsiElement)declaration, KtFunctionType.class);
            if (functionType != null) {
                return functionType;
            }
            parent2 = declaration.getParent();
            if (((KtParameter)declaration).hasValOrVar() && parent2 != null && parent2.getParent() instanceof KtPrimaryConstructor) {
                return KtPsiUtil.getEnclosingElementForLocalDeclaration(((KtPrimaryConstructor)parent2.getParent()).getContainingClassOrObject(), skipParameters);
            }
            if (skipParameters && parent2 != null && parent2.getParent() instanceof KtNamedFunction) {
                declaration = (KtNamedFunction)parent2.getParent();
            }
        }
        if (declaration instanceof PsiFile) {
            return declaration;
        }
        PsiElement current = PsiTreeUtil.getStubOrPsiParent((PsiElement)declaration);
        while (current != null) {
            parent2 = PsiTreeUtil.getStubOrPsiParent((PsiElement)current);
            if (parent2 instanceof KtScript) {
                return null;
            }
            if (current instanceof KtAnonymousInitializer) {
                return ((KtAnonymousInitializer)current).getBody();
            }
            if (current instanceof KtProperty || current instanceof KtFunction) {
                if (parent2 instanceof KtFile) {
                    return (KtElement)current;
                }
                if (parent2 instanceof KtClassBody && !KtPsiUtil.isMemberOfObjectExpression((KtCallableDeclaration)current)) {
                    return (KtElement)parent2;
                }
            }
            if (current instanceof KtBlockExpression || current instanceof KtParameter) {
                return (KtElement)current;
            }
            if (current instanceof KtValueArgument) {
                return (KtElement)current;
            }
            current = parent2;
        }
        return null;
    }

    public static boolean isLocal(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/KtPsiUtil", "isLocal"));
        }
        return KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration) != null;
    }

    @Nullable
    public static KtToken getOperationToken(@NotNull KtOperationExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/KtPsiUtil", "getOperationToken"));
        }
        KtSimpleNameExpression operationExpression = expression2.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType == null || elementType instanceof KtToken) : "JetOperationExpression should have operation token of type KtToken: " + expression2;
        return (KtToken)elementType;
    }

    public static boolean isLabelIdentifierExpression(PsiElement element2) {
        return element2 instanceof KtLabelReferenceExpression;
    }

    @Nullable
    public static KtExpression getParentCallIfPresent(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/KtPsiUtil", "getParentCallIfPresent"));
        }
        PsiElement parent2 = expression2.getParent();
        while (parent2 != null) {
            if (parent2 instanceof KtBinaryExpression || parent2 instanceof KtUnaryExpression || parent2 instanceof KtLabeledExpression || parent2 instanceof KtDotQualifiedExpression || parent2 instanceof KtCallExpression || parent2 instanceof KtArrayAccessExpression || parent2 instanceof KtDestructuringDeclaration) {
                if (parent2 instanceof KtLabeledExpression) {
                    parent2 = parent2.getParent();
                    continue;
                }
                return (KtExpression)parent2;
            }
            if (parent2 instanceof KtParenthesizedExpression || parent2 instanceof KtBinaryExpressionWithTypeRHS) {
                parent2 = parent2.getParent();
                continue;
            }
            if (parent2 instanceof KtValueArgument || parent2 instanceof KtValueArgumentList) {
                parent2 = parent2.getParent();
                continue;
            }
            if (parent2 instanceof KtLambdaExpression || parent2 instanceof KtAnnotatedExpression) {
                parent2 = parent2.getParent();
                continue;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static KtExpression getLastElementDeparenthesized(@Nullable KtExpression expression2, @NotNull StatementFilter statementFilter) {
        KtBlockExpression blockExpression;
        KtExpression lastStatementInABlock;
        if (statementFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementFilter", "org/jetbrains/kotlin/psi/KtPsiUtil", "getLastElementDeparenthesized"));
        }
        KtExpression deparenthesizedExpression = KtPsiUtil.deparenthesize(expression2);
        if (deparenthesizedExpression instanceof KtBlockExpression && (lastStatementInABlock = StatementFilterKt.getLastStatementInABlock(statementFilter, blockExpression = (KtBlockExpression)deparenthesizedExpression)) != null) {
            return KtPsiUtil.getLastElementDeparenthesized(lastStatementInABlock, statementFilter);
        }
        return deparenthesizedExpression;
    }

    public static interface KtExpressionWrapper {
        public KtExpression getBaseExpression();
    }
}

