/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.ChainedTemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CandidateResolveMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.kotlin.resolve.calls.util.DelegatingCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class CallTransformer<D extends CallableDescriptor, F extends D> {
    public static CallTransformer<CallableDescriptor, CallableDescriptor> MEMBER_CALL_TRANSFORMER = new CallTransformer();
    public static CallTransformer<VariableDescriptor, VariableDescriptor> VARIABLE_CALL_TRANSFORMER = new CallTransformer();
    public static CallTransformer<CallableDescriptor, FunctionDescriptor> FUNCTION_CALL_TRANSFORMER = new CallTransformer<CallableDescriptor, FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<CallCandidateResolutionContext<CallableDescriptor>> createCallContexts(@NotNull ResolutionCandidate<CallableDescriptor> candidate, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task2, @NotNull TemporaryBindingTrace candidateTrace, @NotNull CandidateResolveMode candidateResolveMode) {
            if (candidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createCallContexts"));
            }
            if (task2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createCallContexts"));
            }
            if (candidateTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateTrace", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createCallContexts"));
            }
            if (candidateResolveMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolveMode", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createCallContexts"));
            }
            if (candidate.getDescriptor() instanceof FunctionDescriptor) {
                Collection<CallCandidateResolutionContext<CallableDescriptor>> collection = super.createCallContexts(candidate, task2, candidateTrace, candidateResolveMode);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createCallContexts"));
                }
                return collection;
            }
            assert (candidate.getDescriptor() instanceof VariableDescriptor);
            boolean hasReceiver = candidate.getReceiverArgument() != null;
            Call variableCall = 3.stripCallArguments(task2.call);
            ResolutionCandidate<CallableDescriptor> variableCandidate = ResolutionCandidate.create(variableCall, candidate.getDescriptor(), candidate.getDispatchReceiver(), candidate.getReceiverArgument(), candidate.getExplicitReceiverKind(), null);
            if (!hasReceiver) {
                CallCandidateResolutionContext<CallableDescriptor> context = CallCandidateResolutionContext.create(ResolvedCallImpl.create(variableCandidate, candidateTrace, task2.tracing, task2.dataFlowInfoForArguments), task2, candidateTrace, task2.tracing, variableCall, null, candidateResolveMode);
                Set<CallCandidateResolutionContext<CallableDescriptor>> set = Collections.singleton(context);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createCallContexts"));
                }
                return set;
            }
            CallCandidateResolutionContext<CallableDescriptor> contextWithReceiver = this.createContextWithChainedTrace(variableCandidate, variableCall, candidateTrace, task2, null, candidateResolveMode);
            Call variableCallWithoutReceiver = 3.stripReceiver(variableCall);
            ResolutionCandidate<CallableDescriptor> candidateWithoutReceiver = ResolutionCandidate.create(variableCallWithoutReceiver, candidate.getDescriptor(), candidate.getDispatchReceiver(), null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
            CallCandidateResolutionContext<CallableDescriptor> contextWithoutReceiver = this.createContextWithChainedTrace(candidateWithoutReceiver, variableCallWithoutReceiver, candidateTrace, task2, variableCall.getExplicitReceiver(), candidateResolveMode);
            ArrayList arrayList = Lists.newArrayList((Object[])new CallCandidateResolutionContext[]{contextWithReceiver, contextWithoutReceiver});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createCallContexts"));
            }
            return arrayList;
        }

        private CallCandidateResolutionContext<CallableDescriptor> createContextWithChainedTrace(@NotNull ResolutionCandidate<CallableDescriptor> candidate, @NotNull Call call, @NotNull TemporaryBindingTrace temporaryTrace, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task2, @Nullable Receiver receiverValue, @NotNull CandidateResolveMode candidateResolveMode) {
            if (candidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createContextWithChainedTrace"));
            }
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createContextWithChainedTrace"));
            }
            if (temporaryTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "temporaryTrace", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createContextWithChainedTrace"));
            }
            if (task2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createContextWithChainedTrace"));
            }
            if (candidateResolveMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolveMode", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "createContextWithChainedTrace"));
            }
            ChainedTemporaryBindingTrace chainedTrace = ChainedTemporaryBindingTrace.create(temporaryTrace, "chained trace to resolve candidate", candidate);
            ResolvedCallImpl<CallableDescriptor> resolvedCall2 = ResolvedCallImpl.create(candidate, chainedTrace, task2.tracing, task2.dataFlowInfoForArguments);
            return CallCandidateResolutionContext.create(resolvedCall2, task2, chainedTrace, task2.tracing, call, receiverValue, candidateResolveMode);
        }

        @Override
        @NotNull
        public Collection<MutableResolvedCall<FunctionDescriptor>> transformCall(@NotNull CallCandidateResolutionContext<CallableDescriptor> context, @NotNull CallResolver callResolver, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task2) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "transformCall"));
            }
            if (callResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "transformCall"));
            }
            if (task2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "transformCall"));
            }
            Object descriptor2 = context.candidateCall.getCandidateDescriptor();
            if (descriptor2 instanceof FunctionDescriptor) {
                Collection<MutableResolvedCall<FunctionDescriptor>> collection = super.transformCall(context, callResolver, task2);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "transformCall"));
                }
                return collection;
            }
            assert (descriptor2 instanceof VariableDescriptor);
            KotlinType returnType2 = descriptor2.getReturnType();
            if (returnType2 == null) {
                List<MutableResolvedCall<FunctionDescriptor>> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "transformCall"));
                }
                return list2;
            }
            final MutableResolvedCall variableResolvedCall = context.candidateCall;
            KtExpression calleeExpression = task2.call.getCalleeExpression();
            if (calleeExpression == null) {
                List<MutableResolvedCall<FunctionDescriptor>> list3 = Collections.emptyList();
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "transformCall"));
                }
                return list3;
            }
            ExpressionReceiver variableReceiver = ExpressionReceiver.Companion.create(calleeExpression, ((VariableDescriptor)variableResolvedCall.getResultingDescriptor()).getType(), context.trace.getBindingContext());
            CallForImplicitInvoke functionCall2 = new CallForImplicitInvoke(context.explicitExtensionReceiverForInvoke, variableReceiver, task2.call);
            DelegatingBindingTrace variableCallTrace = context.candidateCall.getTrace();
            BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(((CallCandidateResolutionContext)context.replaceBindingTrace(variableCallTrace)).replaceContextDependency(ContextDependency.DEPENDENT), functionCall2, context.checkArguments, context.dataFlowInfoForArguments);
            TracingStrategyForInvoke tracingForInvoke = new TracingStrategyForInvoke(calleeExpression, functionCall2, variableReceiver.getType());
            OverloadResolutionResults<FunctionDescriptor> results2 = callResolver.resolveCallForInvoke(basicCallResolutionContext, tracingForInvoke);
            Collection calls = ((OverloadResolutionResultsImpl)results2).getResultingCalls();
            Collection collection = Collections2.transform(calls, (Function)new Function<MutableResolvedCall<FunctionDescriptor>, MutableResolvedCall<FunctionDescriptor>>(){

                public MutableResolvedCall<FunctionDescriptor> apply(MutableResolvedCall<FunctionDescriptor> functionResolvedCall) {
                    return new VariableAsFunctionResolvedCallImpl(functionResolvedCall, variableResolvedCall);
                }
            });
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$3", "transformCall"));
            }
            return collection;
        }
    };

    private CallTransformer() {
    }

    @NotNull
    public Collection<CallCandidateResolutionContext<D>> createCallContexts(@NotNull ResolutionCandidate<D> candidate, @NotNull ResolutionTask<D, F> task2, @NotNull TemporaryBindingTrace candidateTrace, @NotNull CandidateResolveMode candidateResolveMode) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "createCallContexts"));
        }
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "createCallContexts"));
        }
        if (candidateTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateTrace", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "createCallContexts"));
        }
        if (candidateResolveMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolveMode", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "createCallContexts"));
        }
        ResolvedCallImpl<D> candidateCall = ResolvedCallImpl.create(candidate, candidateTrace, task2.tracing, task2.dataFlowInfoForArguments);
        Set<CallCandidateResolutionContext<D>> set = Collections.singleton(CallCandidateResolutionContext.create(candidateCall, task2, candidateTrace, task2.tracing, task2.call, null, candidateResolveMode));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "createCallContexts"));
        }
        return set;
    }

    @NotNull
    public Collection<MutableResolvedCall<F>> transformCall(@NotNull CallCandidateResolutionContext<D> callCandidateResolutionContext, @NotNull CallResolver callResolver, @NotNull ResolutionTask<D, F> task2) {
        if (callCandidateResolutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callCandidateResolutionContext", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "transformCall"));
        }
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "transformCall"));
        }
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "transformCall"));
        }
        Set<MutableResolvedCall<F>> set = Collections.singleton(callCandidateResolutionContext.candidateCall);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "transformCall"));
        }
        return set;
    }

    public static Call stripCallArguments(@NotNull Call call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "stripCallArguments"));
        }
        return new DelegatingCall(call){

            @Override
            public KtValueArgumentList getValueArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "getValueArguments"));
                }
                return list2;
            }

            @NotNull
            public List<LambdaArgument> getFunctionLiteralArguments() {
                List<LambdaArgument> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "getFunctionLiteralArguments"));
                }
                return list2;
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "getTypeArguments"));
                }
                return list2;
            }

            @Override
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                KtExpression calleeExpression = this.getCalleeExpression();
                assert (calleeExpression != null) : "No callee expression: " + this.getCallElement().getText();
                KtExpression ktExpression = calleeExpression;
                if (ktExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$1", "getCallElement"));
                }
                return ktExpression;
            }
        };
    }

    public static Call stripReceiver(@NotNull Call variableCall) {
        if (variableCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableCall", "org/jetbrains/kotlin/resolve/calls/CallTransformer", "stripReceiver"));
        }
        return new DelegatingCall(variableCall){

            @Override
            @Nullable
            public ASTNode getCallOperationNode() {
                return null;
            }

            @Override
            @Nullable
            public ReceiverValue getExplicitReceiver() {
                return null;
            }
        };
    }

    public static class CallForImplicitInvoke
    extends DelegatingCall {
        private final Call outerCall;
        private final Receiver explicitExtensionReceiver;
        private final ExpressionReceiver calleeExpressionAsDispatchReceiver;
        private final KtSimpleNameExpression fakeInvokeExpression;

        public CallForImplicitInvoke(@Nullable Receiver explicitExtensionReceiver, @NotNull ExpressionReceiver calleeExpressionAsDispatchReceiver, @NotNull Call call) {
            if (calleeExpressionAsDispatchReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpressionAsDispatchReceiver", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "<init>"));
            }
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "<init>"));
            }
            super(call);
            this.outerCall = call;
            this.explicitExtensionReceiver = explicitExtensionReceiver;
            this.calleeExpressionAsDispatchReceiver = calleeExpressionAsDispatchReceiver;
            this.fakeInvokeExpression = (KtSimpleNameExpression)KtPsiFactoryKt.KtPsiFactory((PsiElement)call.getCallElement()).createExpression(OperatorNameConventions.INVOKE.asString());
        }

        @Override
        @Nullable
        public ASTNode getCallOperationNode() {
            return this.explicitExtensionReceiver != null ? super.getCallOperationNode() : null;
        }

        @Override
        @Nullable
        public Receiver getExplicitReceiver() {
            return this.explicitExtensionReceiver;
        }

        @Override
        @NotNull
        public ExpressionReceiver getDispatchReceiver() {
            ExpressionReceiver expressionReceiver = this.calleeExpressionAsDispatchReceiver;
            if (expressionReceiver == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "getDispatchReceiver"));
            }
            return expressionReceiver;
        }

        @Override
        public KtExpression getCalleeExpression() {
            return this.fakeInvokeExpression;
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            Call.CallType callType = Call.CallType.INVOKE;
            if (callType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "getCallType"));
            }
            return callType;
        }

        @NotNull
        public Call getOuterCall() {
            Call call = this.outerCall;
            if (call == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallTransformer$CallForImplicitInvoke", "getOuterCall"));
            }
            return call;
        }
    }
}

