/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.lang.ASTNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/SafeCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "frontend"})
public final class SafeCallChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ASTNode aSTNode = resolvedCall2.getCall().getCallOperationNode();
        if (aSTNode == null) {
            return;
        }
        ASTNode operationNode = aSTNode;
        if (Intrinsics.areEqual((Object)operationNode.getElementType(), (Object)((Object)KtTokens.SAFE_ACCESS)) && Intrinsics.areEqual((Object)((Object)resolvedCall2.getExplicitReceiverKind()), (Object)((Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER))) {
            context.trace.report(Errors.UNEXPECTED_SAFE_CALL.on(operationNode.getPsi()));
        }
    }
}

