/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import org.jetbrains.annotations.NotNull;

public enum Nullability {
    NULL(true, false),
    NOT_NULL(false, true),
    UNKNOWN(true, true),
    IMPOSSIBLE(false, false);

    private final boolean canBeNull;
    private final boolean canBeNonNull;

    @NotNull
    public static Nullability fromFlags(boolean canBeNull, boolean canBeNonNull) {
        if (!canBeNull && !canBeNonNull) {
            Nullability nullability = IMPOSSIBLE;
            if (nullability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "fromFlags"));
            }
            return nullability;
        }
        if (!canBeNull && canBeNonNull) {
            Nullability nullability = NOT_NULL;
            if (nullability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "fromFlags"));
            }
            return nullability;
        }
        if (canBeNull && !canBeNonNull) {
            Nullability nullability = NULL;
            if (nullability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "fromFlags"));
            }
            return nullability;
        }
        Nullability nullability = UNKNOWN;
        if (nullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "fromFlags"));
        }
        return nullability;
    }

    private Nullability(boolean canBeNull, boolean canBeNonNull) {
        this.canBeNull = canBeNull;
        this.canBeNonNull = canBeNonNull;
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    public boolean canBeNonNull() {
        return this.canBeNonNull;
    }

    @NotNull
    public Nullability refine(@NotNull Nullability other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "refine"));
        }
        switch (this) {
            case UNKNOWN: {
                Nullability nullability = other;
                if (nullability == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "refine"));
                }
                return nullability;
            }
            case IMPOSSIBLE: {
                Nullability nullability = other;
                if (nullability == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "refine"));
                }
                return nullability;
            }
            case NULL: {
                switch (other) {
                    case NOT_NULL: {
                        Nullability nullability = NOT_NULL;
                        if (nullability == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "refine"));
                        }
                        return nullability;
                    }
                }
                Nullability nullability = NULL;
                if (nullability == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "refine"));
                }
                return nullability;
            }
            case NOT_NULL: {
                switch (other) {
                    case NULL: {
                        Nullability nullability = NOT_NULL;
                        if (nullability == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "refine"));
                        }
                        return nullability;
                    }
                }
                Nullability nullability = NOT_NULL;
                if (nullability == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "refine"));
                }
                return nullability;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    public Nullability invert() {
        switch (this) {
            case NULL: {
                Nullability nullability = NOT_NULL;
                if (nullability == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "invert"));
                }
                return nullability;
            }
            case NOT_NULL: {
                Nullability nullability = UNKNOWN;
                if (nullability == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "invert"));
                }
                return nullability;
            }
            case UNKNOWN: {
                Nullability nullability = UNKNOWN;
                if (nullability == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "invert"));
                }
                return nullability;
            }
            case IMPOSSIBLE: {
                Nullability nullability = UNKNOWN;
                if (nullability == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "invert"));
                }
                return nullability;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    public Nullability and(@NotNull Nullability other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "and"));
        }
        Nullability nullability = Nullability.fromFlags(this.canBeNull && other.canBeNull, this.canBeNonNull && other.canBeNonNull);
        if (nullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "and"));
        }
        return nullability;
    }

    @NotNull
    public Nullability or(@NotNull Nullability other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "or"));
        }
        Nullability nullability = Nullability.fromFlags(this.canBeNull || other.canBeNull, this.canBeNonNull || other.canBeNonNull);
        if (nullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability", "or"));
        }
        return nullability;
    }
}

