/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import icons.GithubIcons;
import java.util.Collection;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

abstract class GithubShowCommitInBrowserAction
extends DumbAwareAction {
    public GithubShowCommitInBrowserAction() {
        super("Open on GitHub", "Open the selected commit in browser", GithubIcons.Github_icon);
    }

    protected static void openInBrowser(Project project, GitRepository repository, String revisionHash) {
        String url = GithubUtil.findGithubRemoteUrl(repository);
        if (url == null) {
            GithubUtil.LOG.info(String.format("Repository is not under GitHub. Root: %s, Remotes: %s", repository.getRoot(), GitUtil.getPrintableRemotes((Collection)repository.getRemotes())));
            return;
        }
        GithubFullPath userAndRepository = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url);
        if (userAndRepository == null) {
            GithubNotifications.showError(project, "Cannot open in browser", "Cannot extract info about repository: " + url);
            return;
        }
        String githubUrl = GithubUrlUtil.getGithubHost() + '/' + userAndRepository.getUser() + '/' + userAndRepository.getRepository() + "/commit/" + revisionHash;
        BrowserUtil.browse((String)githubUrl);
    }
}

