/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubAuthorization;
import org.jetbrains.plugins.github.api.GithubAuthorizationCreateRequest;
import org.jetbrains.plugins.github.api.GithubAuthorizationRaw;
import org.jetbrains.plugins.github.api.GithubAuthorizationUpdateRequest;
import org.jetbrains.plugins.github.api.GithubBranch;
import org.jetbrains.plugins.github.api.GithubBranchRaw;
import org.jetbrains.plugins.github.api.GithubChangeIssueStateRequest;
import org.jetbrains.plugins.github.api.GithubCommit;
import org.jetbrains.plugins.github.api.GithubCommitComment;
import org.jetbrains.plugins.github.api.GithubCommitCommentRaw;
import org.jetbrains.plugins.github.api.GithubCommitDetailed;
import org.jetbrains.plugins.github.api.GithubCommitRaw;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubFile;
import org.jetbrains.plugins.github.api.GithubFileRaw;
import org.jetbrains.plugins.github.api.GithubGist;
import org.jetbrains.plugins.github.api.GithubGistRaw;
import org.jetbrains.plugins.github.api.GithubGistRequest;
import org.jetbrains.plugins.github.api.GithubIssue;
import org.jetbrains.plugins.github.api.GithubIssueComment;
import org.jetbrains.plugins.github.api.GithubIssueCommentRaw;
import org.jetbrains.plugins.github.api.GithubIssueRaw;
import org.jetbrains.plugins.github.api.GithubIssuesSearchResult;
import org.jetbrains.plugins.github.api.GithubIssuesSearchResultRaw;
import org.jetbrains.plugins.github.api.GithubOrg;
import org.jetbrains.plugins.github.api.GithubOrgRaw;
import org.jetbrains.plugins.github.api.GithubPullRequest;
import org.jetbrains.plugins.github.api.GithubPullRequestRaw;
import org.jetbrains.plugins.github.api.GithubPullRequestRequest;
import org.jetbrains.plugins.github.api.GithubRepo;
import org.jetbrains.plugins.github.api.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.GithubRepoOrg;
import org.jetbrains.plugins.github.api.GithubRepoRaw;
import org.jetbrains.plugins.github.api.GithubRepoRequest;
import org.jetbrains.plugins.github.api.GithubUser;
import org.jetbrains.plugins.github.api.GithubUserDetailed;
import org.jetbrains.plugins.github.api.GithubUserRaw;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubApiUtil {
    private static final Logger LOG = GithubUtil.LOG;
    public static final String DEFAULT_GITHUB_HOST = "github.com";
    private static final String PER_PAGE = "per_page=100";
    private static final Header ACCEPT_V3_JSON_HTML_MARKUP = new BasicHeader("Accept", "application/vnd.github.v3.html+json");
    private static final Header ACCEPT_V3_JSON = new BasicHeader("Accept", "application/vnd.github.v3+json");
    @NotNull
    private static final Gson gson = GithubApiUtil.initGson();

    private static Gson initGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder.create();
    }

    @NotNull
    public static <T> T fromJson(@Nullable JsonElement json, @NotNull Class<T> classT) throws IOException {
        Object res;
        if (classT == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classT", "org/jetbrains/plugins/github/api/GithubApiUtil", "fromJson"));
        }
        if (json == null) {
            throw new GithubJsonException("Unexpected empty response");
        }
        try {
            res = gson.fromJson(json, classT);
        }
        catch (ClassCastException e) {
            throw new GithubJsonException("Parse exception while converting JSON to object " + classT.toString(), e);
        }
        catch (JsonParseException e) {
            throw new GithubJsonException("Parse exception while converting JSON to object " + classT.toString(), e);
        }
        if (res == null) {
            throw new GithubJsonException("Empty Json response");
        }
        Object object = res;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "fromJson"));
        }
        return (T)object;
    }

    @NotNull
    public static <Raw extends DataConstructor, Result> Result createDataFromRaw(@NotNull Raw rawObject, @NotNull Class<Result> resultClass) throws GithubJsonException {
        Result Result;
        if (rawObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawObject", "org/jetbrains/plugins/github/api/GithubApiUtil", "createDataFromRaw"));
        }
        if (resultClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultClass", "org/jetbrains/plugins/github/api/GithubApiUtil", "createDataFromRaw"));
        }
        try {
            Result = rawObject.create(resultClass);
        }
        catch (Exception e) {
            throw new GithubJsonException("Json parse error", e);
        }
        if (Result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "createDataFromRaw"));
        }
        return Result;
    }

    public static void askForTwoFactorCodeSMS(@NotNull GithubConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "askForTwoFactorCodeSMS"));
        }
        try {
            connection.postRequest("/authorizations", null, ACCEPT_V3_JSON);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    public static Collection<String> getTokenScopes(@NotNull GithubConnection connection) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getTokenScopes"));
        }
        Header[] headers = connection.headRequest("/user", ACCEPT_V3_JSON);
        Header scopesHeader = null;
        for (Header header : headers) {
            if (!header.getName().equals("X-OAuth-Scopes")) continue;
            scopesHeader = header;
            break;
        }
        if (scopesHeader == null) {
            throw new GithubConfusingException("No scopes header");
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (HeaderElement elem : scopesHeader.getElements()) {
            scopes.add(elem.getName());
        }
        ArrayList<String> arrayList = scopes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getTokenScopes"));
        }
        return arrayList;
    }

    @NotNull
    public static String getScopedToken(@NotNull GithubConnection connection, @NotNull Collection<String> scopes, @NotNull String note) throws IOException {
        String string;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
        }
        if (note == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "note", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
        }
        try {
            string = GithubApiUtil.getNewScopedToken(connection, scopes, note).getToken();
        }
        catch (GithubStatusCodeException e) {
            if (e.getError() != null && e.getError().containsErrorCode("already_exists")) {
                List<GithubAuthorization> tokens = GithubApiUtil.getAllTokens(connection);
                for (int i = 1; i < 100; ++i) {
                    final String newNote = note + "_" + i;
                    if (ContainerUtil.find(tokens, (Condition)new Condition<GithubAuthorization>(){

                        public boolean value(GithubAuthorization authorization) {
                            return newNote.equals(authorization.getNote());
                        }
                    }) != null) continue;
                    String string2 = GithubApiUtil.getNewScopedToken(connection, scopes, newNote).getToken();
                    if (string2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
                    }
                    return string2;
                }
            }
            throw e;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
        }
        return string;
    }

    @NotNull
    private static GithubAuthorization updateTokenScopes(@NotNull GithubConnection connection, @NotNull GithubAuthorization token, @NotNull Collection<String> scopes) throws IOException {
        GithubAuthorization githubAuthorization;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "updateTokenScopes"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/plugins/github/api/GithubApiUtil", "updateTokenScopes"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "org/jetbrains/plugins/github/api/GithubApiUtil", "updateTokenScopes"));
        }
        try {
            String path = "/authorizations/" + token.getId();
            GithubAuthorizationUpdateRequest request = new GithubAuthorizationUpdateRequest(new ArrayList<String>(scopes));
            githubAuthorization = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(connection.patchRequest(path, gson.toJson((Object)request), ACCEPT_V3_JSON), GithubAuthorizationRaw.class), GithubAuthorization.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't update token: scopes - " + scopes);
            throw e;
        }
        if (githubAuthorization == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "updateTokenScopes"));
        }
        return githubAuthorization;
    }

    @NotNull
    private static GithubAuthorization getNewScopedToken(@NotNull GithubConnection connection, @NotNull Collection<String> scopes, @NotNull String note) throws IOException {
        GithubAuthorization githubAuthorization;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getNewScopedToken"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "org/jetbrains/plugins/github/api/GithubApiUtil", "getNewScopedToken"));
        }
        if (note == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "note", "org/jetbrains/plugins/github/api/GithubApiUtil", "getNewScopedToken"));
        }
        try {
            String path = "/authorizations";
            GithubAuthorizationCreateRequest request = new GithubAuthorizationCreateRequest(new ArrayList<String>(scopes), note, null);
            githubAuthorization = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(connection.postRequest(path, gson.toJson((Object)request), ACCEPT_V3_JSON), GithubAuthorizationRaw.class), GithubAuthorization.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create token: scopes - " + scopes + " - note " + note);
            throw e;
        }
        if (githubAuthorization == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getNewScopedToken"));
        }
        return githubAuthorization;
    }

    @NotNull
    private static List<GithubAuthorization> getAllTokens(@NotNull GithubConnection connection) throws IOException {
        List<GithubAuthorization> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getAllTokens"));
        }
        try {
            String path = "/authorizations";
            GithubConnection.PagedRequest<GithubAuthorization> request = new GithubConnection.PagedRequest<GithubAuthorization>(path, GithubAuthorization.class, GithubAuthorizationRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(connection);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get available tokens");
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getAllTokens"));
        }
        return list;
    }

    @NotNull
    public static String getMasterToken(@NotNull GithubConnection connection, @NotNull String note) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getMasterToken"));
        }
        if (note == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "note", "org/jetbrains/plugins/github/api/GithubApiUtil", "getMasterToken"));
        }
        List<String> scopes = Arrays.asList("repo", "gist");
        String string = GithubApiUtil.getScopedToken(connection, scopes, note);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getMasterToken"));
        }
        return string;
    }

    @NotNull
    public static String getTasksToken(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String note) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getTasksToken"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getTasksToken"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getTasksToken"));
        }
        if (note == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "note", "org/jetbrains/plugins/github/api/GithubApiUtil", "getTasksToken"));
        }
        GithubRepoDetailed repository = GithubApiUtil.getDetailedRepoInfo(connection, user, repo);
        List<String> scopes = repository.isPrivate() ? Collections.singletonList("repo") : Collections.singletonList("public_repo");
        String string = GithubApiUtil.getScopedToken(connection, scopes, note);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getTasksToken"));
        }
        return string;
    }

    @NotNull
    public static GithubUser getCurrentUser(@NotNull GithubConnection connection) throws IOException {
        GithubUser githubUser;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCurrentUser"));
        }
        try {
            JsonElement result = connection.getRequest("/user", ACCEPT_V3_JSON);
            githubUser = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubUserRaw.class), GithubUser.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user info");
            throw e;
        }
        if (githubUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCurrentUser"));
        }
        return githubUser;
    }

    @NotNull
    public static GithubUserDetailed getCurrentUserDetailed(@NotNull GithubConnection connection) throws IOException {
        GithubUserDetailed githubUserDetailed;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCurrentUserDetailed"));
        }
        try {
            JsonElement result = connection.getRequest("/user", ACCEPT_V3_JSON);
            githubUserDetailed = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubUserRaw.class), GithubUserDetailed.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user info");
            throw e;
        }
        if (githubUserDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCurrentUserDetailed"));
        }
        return githubUserDetailed;
    }

    @NotNull
    public static List<GithubRepo> getUserRepos(@NotNull GithubConnection connection) throws IOException {
        List<GithubRepo> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getUserRepos"));
        }
        try {
            String path = "/user/repos?per_page=100";
            GithubConnection.PagedRequest<GithubRepo> request = new GithubConnection.PagedRequest<GithubRepo>(path, GithubRepo.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(connection);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user repositories");
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getUserRepos"));
        }
        return list;
    }

    @NotNull
    public static List<GithubRepo> getUserRepos(@NotNull GithubConnection connection, @NotNull String user) throws IOException {
        List<GithubRepo> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getUserRepos"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getUserRepos"));
        }
        try {
            String path = "/users/" + user + "/repos?" + PER_PAGE;
            GithubConnection.PagedRequest<GithubRepo> request = new GithubConnection.PagedRequest<GithubRepo>(path, GithubRepo.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(connection);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user repositories: " + user);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getUserRepos"));
        }
        return list;
    }

    @NotNull
    public static List<GithubRepo> getAvailableRepos(@NotNull GithubConnection connection) throws IOException {
        ArrayList<GithubRepo> arrayList;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getAvailableRepos"));
        }
        try {
            ArrayList<GithubRepo> repos = new ArrayList<GithubRepo>();
            repos.addAll(GithubApiUtil.getUserRepos(connection));
            try {
                repos.addAll(GithubApiUtil.getMembershipRepos(connection));
            }
            catch (GithubStatusCodeException githubStatusCodeException) {
                // empty catch block
            }
            try {
                repos.addAll(GithubApiUtil.getWatchedRepos(connection));
            }
            catch (GithubStatusCodeException githubStatusCodeException) {
                // empty catch block
            }
            arrayList = repos;
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get available repositories");
            throw e;
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getAvailableRepos"));
        }
        return arrayList;
    }

    @NotNull
    public static List<GithubRepoOrg> getMembershipRepos(@NotNull GithubConnection connection) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getMembershipRepos"));
        }
        String orgsPath = "/user/orgs?per_page=100";
        GithubConnection.PagedRequest<GithubOrg> orgsRequest = new GithubConnection.PagedRequest<GithubOrg>(orgsPath, GithubOrg.class, GithubOrgRaw[].class, new Header[0]);
        ArrayList<GithubRepoOrg> repos = new ArrayList<GithubRepoOrg>();
        for (GithubOrg org : orgsRequest.getAll(connection)) {
            String path = "/orgs/" + org.getLogin() + "/repos?type=member&" + PER_PAGE;
            GithubConnection.PagedRequest<GithubRepoOrg> request = new GithubConnection.PagedRequest<GithubRepoOrg>(path, GithubRepoOrg.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
            repos.addAll(request.getAll(connection));
        }
        ArrayList<GithubRepoOrg> arrayList = repos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getMembershipRepos"));
        }
        return arrayList;
    }

    @NotNull
    public static List<GithubRepo> getWatchedRepos(@NotNull GithubConnection connection) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getWatchedRepos"));
        }
        String pathWatched = "/user/subscriptions?per_page=100";
        GithubConnection.PagedRequest<GithubRepo> requestWatched = new GithubConnection.PagedRequest<GithubRepo>(pathWatched, GithubRepo.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
        List<GithubRepo> list = requestWatched.getAll(connection);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getWatchedRepos"));
        }
        return list;
    }

    @NotNull
    public static GithubRepoDetailed getDetailedRepoInfo(@NotNull GithubConnection connection, @NotNull String owner, @NotNull String name) throws IOException {
        GithubRepoDetailed githubRepoDetailed;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getDetailedRepoInfo"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/plugins/github/api/GithubApiUtil", "getDetailedRepoInfo"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/github/api/GithubApiUtil", "getDetailedRepoInfo"));
        }
        try {
            String request = "/repos/" + owner + "/" + name;
            JsonElement jsonObject = connection.getRequest(request, ACCEPT_V3_JSON);
            githubRepoDetailed = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(jsonObject, GithubRepoRaw.class), GithubRepoDetailed.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get repository info: " + owner + "/" + name);
            throw e;
        }
        if (githubRepoDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getDetailedRepoInfo"));
        }
        return githubRepoDetailed;
    }

    public static void deleteGithubRepository(@NotNull GithubConnection connection, @NotNull String username, @NotNull String repo) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteGithubRepository"));
        }
        if (username == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "username", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteGithubRepository"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteGithubRepository"));
        }
        try {
            String path = "/repos/" + username + "/" + repo;
            connection.deleteRequest(path, new Header[0]);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't delete repository: " + username + "/" + repo);
            throw e;
        }
    }

    public static void deleteGist(@NotNull GithubConnection connection, @NotNull String id) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteGist"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteGist"));
        }
        try {
            String path = "/gists/" + id;
            connection.deleteRequest(path, new Header[0]);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't delete gist: id - " + id);
            throw e;
        }
    }

    @NotNull
    public static GithubGist getGist(@NotNull GithubConnection connection, @NotNull String id) throws IOException {
        GithubGist githubGist;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getGist"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/github/api/GithubApiUtil", "getGist"));
        }
        try {
            String path = "/gists/" + id;
            JsonElement result = connection.getRequest(path, ACCEPT_V3_JSON);
            githubGist = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubGistRaw.class), GithubGist.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get gist info: id " + id);
            throw e;
        }
        if (githubGist == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getGist"));
        }
        return githubGist;
    }

    @NotNull
    public static GithubGist createGist(@NotNull GithubConnection connection, @NotNull List<GithubGist.FileContent> contents, @NotNull String description, boolean isPrivate) throws IOException {
        GithubGist githubGist;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "createGist"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "org/jetbrains/plugins/github/api/GithubApiUtil", "createGist"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/plugins/github/api/GithubApiUtil", "createGist"));
        }
        try {
            String request = gson.toJson((Object)new GithubGistRequest(contents, description, !isPrivate));
            githubGist = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(connection.postRequest("/gists", request, ACCEPT_V3_JSON), GithubGistRaw.class), GithubGist.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create gist");
            throw e;
        }
        if (githubGist == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "createGist"));
        }
        return githubGist;
    }

    @NotNull
    public static List<GithubRepo> getForks(@NotNull GithubConnection connection, @NotNull String owner, @NotNull String name) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getForks"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/plugins/github/api/GithubApiUtil", "getForks"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/github/api/GithubApiUtil", "getForks"));
        }
        String path = "/repos/" + owner + "/" + name + "/forks?" + PER_PAGE;
        GithubConnection.PagedRequest<GithubRepo> requestWatched = new GithubConnection.PagedRequest<GithubRepo>(path, GithubRepo.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
        List<GithubRepo> list = requestWatched.getAll(connection);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getForks"));
        }
        return list;
    }

    @NotNull
    public static GithubPullRequest createPullRequest(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String title, @NotNull String description, @NotNull String head, @NotNull String base) throws IOException {
        GithubPullRequest githubPullRequest;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (head == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "head", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        try {
            String request = gson.toJson((Object)new GithubPullRequestRequest(title, description, head, base));
            githubPullRequest = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(connection.postRequest("/repos/" + user + "/" + repo + "/pulls", request, ACCEPT_V3_JSON), GithubPullRequestRaw.class), GithubPullRequest.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create pull request");
            throw e;
        }
        if (githubPullRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        return githubPullRequest;
    }

    @NotNull
    public static GithubRepo createRepo(@NotNull GithubConnection connection, @NotNull String name, @NotNull String description, boolean isPrivate) throws IOException {
        GithubRepo githubRepo;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "createRepo"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/github/api/GithubApiUtil", "createRepo"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/plugins/github/api/GithubApiUtil", "createRepo"));
        }
        try {
            String path = "/user/repos";
            GithubRepoRequest request = new GithubRepoRequest(name, description, isPrivate);
            githubRepo = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(connection.postRequest(path, gson.toJson((Object)request), ACCEPT_V3_JSON), GithubRepoRaw.class), GithubRepo.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create repository: " + name);
            throw e;
        }
        if (githubRepo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "createRepo"));
        }
        return githubRepo;
    }

    @NotNull
    public static List<GithubIssue> getIssuesAssigned(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @Nullable String assigned, int max, boolean withClosed) throws IOException {
        ArrayList<GithubIssue> arrayList;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesAssigned"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesAssigned"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesAssigned"));
        }
        try {
            String state = "state=" + (withClosed ? "all" : "open");
            String path = StringUtil.isEmptyOrSpaces((String)assigned) ? "/repos/" + user + "/" + repo + "/issues?" + PER_PAGE + "&" + state : "/repos/" + user + "/" + repo + "/issues?assignee=" + assigned + "&" + PER_PAGE + "&" + state;
            GithubConnection.PagedRequest<GithubIssue> request = new GithubConnection.PagedRequest<GithubIssue>(path, GithubIssue.class, GithubIssueRaw[].class, ACCEPT_V3_JSON);
            ArrayList<GithubIssue> result = new ArrayList<GithubIssue>();
            while (request.hasNext() && max > result.size()) {
                result.addAll(request.next(connection));
            }
            arrayList = result;
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get assigned issues: " + user + "/" + repo + " - " + assigned);
            throw e;
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesAssigned"));
        }
        return arrayList;
    }

    @NotNull
    public static List<GithubIssue> getIssuesQueried(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @Nullable String assignedUser, @Nullable String query, boolean withClosed) throws IOException {
        List<GithubIssue> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesQueried"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesQueried"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesQueried"));
        }
        try {
            String state = withClosed ? "" : " state:open";
            String assignee = StringUtil.isEmptyOrSpaces((String)assignedUser) ? "" : " assignee:" + assignedUser;
            query = URLEncoder.encode("repo:" + user + "/" + repo + state + assignee + " " + query, "UTF-8");
            String path = "/search/issues?q=" + query;
            JsonElement result = connection.getRequest(path, ACCEPT_V3_JSON);
            list = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubIssuesSearchResultRaw.class), GithubIssuesSearchResult.class).getIssues();
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get queried issues: " + user + "/" + repo + " - " + query);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesQueried"));
        }
        return list;
    }

    @NotNull
    public static GithubIssue getIssue(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String id) throws IOException {
        GithubIssue githubIssue;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssue"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssue"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssue"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssue"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/issues/" + id;
            JsonElement result = connection.getRequest(path, ACCEPT_V3_JSON);
            githubIssue = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubIssueRaw.class), GithubIssue.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get issue info: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (githubIssue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssue"));
        }
        return githubIssue;
    }

    @NotNull
    public static List<GithubIssueComment> getIssueComments(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubIssueComment> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssueComments"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssueComments"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssueComments"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/issues/" + id + "/comments?" + PER_PAGE;
            GithubConnection.PagedRequest<GithubIssueComment> request = new GithubConnection.PagedRequest<GithubIssueComment>(path, GithubIssueComment.class, GithubIssueCommentRaw[].class, ACCEPT_V3_JSON_HTML_MARKUP);
            list = request.getAll(connection);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get issue comments: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssueComments"));
        }
        return list;
    }

    public static void setIssueState(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String id, boolean open) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "setIssueState"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "setIssueState"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "setIssueState"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/github/api/GithubApiUtil", "setIssueState"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/issues/" + id;
            GithubChangeIssueStateRequest request = new GithubChangeIssueStateRequest(open ? "open" : "closed");
            JsonElement result = connection.patchRequest(path, gson.toJson((Object)request), ACCEPT_V3_JSON);
            GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubIssueRaw.class), GithubIssue.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't set issue state: " + user + "/" + repo + " - " + id + "@" + (open ? "open" : "closed"));
            throw e;
        }
    }

    @NotNull
    public static GithubCommitDetailed getCommit(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String sha) throws IOException {
        GithubCommitDetailed githubCommitDetailed;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommit"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommit"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommit"));
        }
        if (sha == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sha", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommit"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/commits/" + sha;
            JsonElement result = connection.getRequest(path, ACCEPT_V3_JSON);
            githubCommitDetailed = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubCommitRaw.class), GithubCommitDetailed.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get commit info: " + user + "/" + repo + " - " + sha);
            throw e;
        }
        if (githubCommitDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommit"));
        }
        return githubCommitDetailed;
    }

    @NotNull
    public static List<GithubCommitComment> getCommitComments(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String sha) throws IOException {
        List<GithubCommitComment> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommitComments"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommitComments"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommitComments"));
        }
        if (sha == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sha", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommitComments"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/commits/" + sha + "/comments";
            GithubConnection.PagedRequest<GithubCommitComment> request = new GithubConnection.PagedRequest<GithubCommitComment>(path, GithubCommitComment.class, GithubCommitCommentRaw[].class, ACCEPT_V3_JSON_HTML_MARKUP);
            list = request.getAll(connection);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get commit comments: " + user + "/" + repo + " - " + sha);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommitComments"));
        }
        return list;
    }

    @NotNull
    public static List<GithubCommitComment> getPullRequestComments(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubCommitComment> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestComments"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestComments"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestComments"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id + "/comments";
            GithubConnection.PagedRequest<GithubCommitComment> request = new GithubConnection.PagedRequest<GithubCommitComment>(path, GithubCommitComment.class, GithubCommitCommentRaw[].class, ACCEPT_V3_JSON_HTML_MARKUP);
            list = request.getAll(connection);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request comments: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestComments"));
        }
        return list;
    }

    @NotNull
    public static GithubPullRequest getPullRequest(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, int id) throws IOException {
        GithubPullRequest githubPullRequest;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequest"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequest"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequest"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id;
            githubPullRequest = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(connection.getRequest(path, ACCEPT_V3_JSON_HTML_MARKUP), GithubPullRequestRaw.class), GithubPullRequest.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request info: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (githubPullRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequest"));
        }
        return githubPullRequest;
    }

    @NotNull
    public static List<GithubPullRequest> getPullRequests(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo) throws IOException {
        List<GithubPullRequest> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls?" + PER_PAGE;
            GithubConnection.PagedRequest<GithubPullRequest> request = new GithubConnection.PagedRequest<GithubPullRequest>(path, GithubPullRequest.class, GithubPullRequestRaw[].class, ACCEPT_V3_JSON_HTML_MARKUP);
            list = request.getAll(connection);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull requests" + user + "/" + repo);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        return list;
    }

    @NotNull
    public static GithubConnection.PagedRequest<GithubPullRequest> getPullRequests(@NotNull String user, @NotNull String repo) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        String path = "/repos/" + user + "/" + repo + "/pulls?" + PER_PAGE;
        GithubConnection.PagedRequest<GithubPullRequest> pagedRequest = new GithubConnection.PagedRequest<GithubPullRequest>(path, GithubPullRequest.class, GithubPullRequestRaw[].class, ACCEPT_V3_JSON_HTML_MARKUP);
        if (pagedRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        return pagedRequest;
    }

    @NotNull
    public static List<GithubCommit> getPullRequestCommits(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubCommit> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestCommits"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestCommits"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestCommits"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id + "/commits?" + PER_PAGE;
            GithubConnection.PagedRequest<GithubCommit> request = new GithubConnection.PagedRequest<GithubCommit>(path, GithubCommit.class, GithubCommitRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(connection);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request commits: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestCommits"));
        }
        return list;
    }

    @NotNull
    public static List<GithubFile> getPullRequestFiles(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubFile> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestFiles"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestFiles"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestFiles"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id + "/files?" + PER_PAGE;
            GithubConnection.PagedRequest<GithubFile> request = new GithubConnection.PagedRequest<GithubFile>(path, GithubFile.class, GithubFileRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(connection);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request files: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestFiles"));
        }
        return list;
    }

    @NotNull
    public static List<GithubBranch> getRepoBranches(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo) throws IOException {
        List<GithubBranch> list;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRepoBranches"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRepoBranches"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRepoBranches"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/branches?" + PER_PAGE;
            GithubConnection.PagedRequest<GithubBranch> request = new GithubConnection.PagedRequest<GithubBranch>(path, GithubBranch.class, GithubBranchRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(connection);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get repository branches: " + user + "/" + repo);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRepoBranches"));
        }
        return list;
    }

    @Nullable
    public static GithubRepo findForkByUser(@NotNull GithubConnection connection, @NotNull String user, @NotNull String repo, @NotNull String forkUser) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubApiUtil", "findForkByUser"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/api/GithubApiUtil", "findForkByUser"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/api/GithubApiUtil", "findForkByUser"));
        }
        if (forkUser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forkUser", "org/jetbrains/plugins/github/api/GithubApiUtil", "findForkByUser"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/forks?" + PER_PAGE;
            GithubConnection.PagedRequest<GithubRepo> request = new GithubConnection.PagedRequest<GithubRepo>(path, GithubRepo.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
            while (request.hasNext()) {
                for (GithubRepo fork : request.next(connection)) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)fork.getUserName(), (CharSequence)forkUser)) continue;
                    return fork;
                }
            }
            return null;
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't find fork by user: " + user + "/" + repo + " - " + forkUser);
            throw e;
        }
    }
}

