/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidApkBuilderConfigState;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;

public class AndroidApkBuilderConfigStateStorage
extends AbstractStateStorage<String, AndroidApkBuilderConfigState> {
    private AndroidApkBuilderConfigStateStorage(@NotNull File dataStorageRoot, @NotNull String storageName) throws IOException {
        if (dataStorageRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStorageRoot", "org/jetbrains/jps/android/AndroidApkBuilderConfigStateStorage", "<init>"));
        }
        if (storageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageName", "org/jetbrains/jps/android/AndroidApkBuilderConfigStateStorage", "<init>"));
        }
        super(AndroidJpsUtil.getStorageFile(dataStorageRoot, storageName), (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)new MyDataExternalizer());
    }

    public static class Provider
    extends StorageProvider<AndroidApkBuilderConfigStateStorage> {
        private final String myStorageName;

        public Provider(@NotNull String storageName) {
            if (storageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageName", "org/jetbrains/jps/android/AndroidApkBuilderConfigStateStorage$Provider", "<init>"));
            }
            this.myStorageName = storageName;
        }

        @NotNull
        public AndroidApkBuilderConfigStateStorage createStorage(File targetDataDir) throws IOException {
            AndroidApkBuilderConfigStateStorage androidApkBuilderConfigStateStorage = new AndroidApkBuilderConfigStateStorage(targetDataDir, this.myStorageName);
            if (androidApkBuilderConfigStateStorage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidApkBuilderConfigStateStorage$Provider", "createStorage"));
            }
            return androidApkBuilderConfigStateStorage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Provider provider = (Provider)((Object)o);
            return this.myStorageName.equals(provider.myStorageName);
        }

        public int hashCode() {
            return this.myStorageName.hashCode();
        }
    }

    private static class MyDataExternalizer
    implements DataExternalizer<AndroidApkBuilderConfigState> {
        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, AndroidApkBuilderConfigState value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/android/AndroidApkBuilderConfigStateStorage$MyDataExternalizer", "save"));
            }
            value.save(out);
        }

        public AndroidApkBuilderConfigState read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/android/AndroidApkBuilderConfigStateStorage$MyDataExternalizer", "read"));
            }
            return new AndroidApkBuilderConfigState(in);
        }
    }
}

