/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidAarDepsBuildTarget
extends AndroidBuildTarget {
    public AndroidAarDepsBuildTarget(JpsModule module) {
        super(MyTargetType.INSTANCE, module);
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        Set libraries = JpsJavaExtensionService.getInstance().enumerateDependencies(Collections.singleton(this.myModule)).runtimeOnly().productionOnly().getLibraries();
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        for (JpsLibrary library : libraries) {
            Pair<File, List<File>> pair = AndroidJpsUtil.getResDirAndJarsIfAar(library);
            List jars = pair != null ? (List)pair.getSecond() : null;
            if (jars == null) continue;
            for (File jar : jars) {
                result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, jar));
            }
        }
        ArrayList<BuildRootDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget", "doComputeRootDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        Set<File> set = Collections.singleton(this.getOutputFile(context));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget", "getOutputRoots"));
        }
        return set;
    }

    @NotNull
    public File getOutputFile(CompileContext context) {
        File file = this.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget", "getOutputFile"));
        }
        return file;
    }

    @NotNull
    public File getOutputFile(BuildDataPaths dataPaths) {
        JpsModule module = this.myModule;
        File file = AndroidAarDepsBuildTarget.getOutputFile(module, dataPaths);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget", "getOutputFile"));
        }
        return file;
    }

    @NotNull
    public static File getOutputFile(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget", "getOutputFile"));
        }
        if (dataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPaths", "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget", "getOutputFile"));
        }
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, module);
        File file = new File(dir, "aar_deps.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget", "getOutputFile"));
        }
        return file;
    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidAarDepsBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        MyTargetType() {
            super("android-aar-deps", "AAR Dependencies Packaging");
        }

        @Override
        @Nullable
        public AndroidAarDepsBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget$MyTargetType", "createBuildTarget"));
            }
            return !extension.isLibrary() ? new AndroidAarDepsBuildTarget(extension.getModule()) : null;
        }
    }
}

