/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.groovy.GreclipseSettings;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;

public class GreclipseJpsCompilerSettings
extends JpsCompositeElementBase<GreclipseJpsCompilerSettings> {
    public static final JpsElementChildRole<GreclipseJpsCompilerSettings> ROLE = JpsElementChildRoleBase.create((String)"Greclipse Compiler Configuration");
    private GreclipseSettings mySettings;

    public GreclipseJpsCompilerSettings(@NotNull GreclipseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/jps/incremental/groovy/GreclipseJpsCompilerSettings", "<init>"));
        }
        this.mySettings = settings;
    }

    @NotNull
    public GreclipseJpsCompilerSettings createCopy() {
        GreclipseJpsCompilerSettings greclipseJpsCompilerSettings = new GreclipseJpsCompilerSettings(this.mySettings);
        if (greclipseJpsCompilerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GreclipseJpsCompilerSettings", "createCopy"));
        }
        return greclipseJpsCompilerSettings;
    }

    public void applyChanges(@NotNull GreclipseJpsCompilerSettings modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/incremental/groovy/GreclipseJpsCompilerSettings", "applyChanges"));
        }
        this.mySettings = modified.mySettings;
    }

    @Nullable
    public static GreclipseSettings getSettings(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/incremental/groovy/GreclipseJpsCompilerSettings", "getSettings"));
        }
        GreclipseJpsCompilerSettings extension = (GreclipseJpsCompilerSettings)project.getContainer().getChild(ROLE);
        return extension != null ? extension.mySettings : null;
    }
}

