/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Objects;
import org.testng.internal.ClassHelper;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.testng.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlClass
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8885360896966149897L;
    private List<XmlInclude> m_includedMethods = Lists.newArrayList();
    private List<String> m_excludedMethods = Lists.newArrayList();
    private String m_name = null;
    private Class m_class = null;
    private int m_index;
    private boolean m_loadClasses = true;
    private Map<String, String> m_parameters = Maps.newHashMap();
    private XmlTest m_xmlTest;

    public XmlClass() {
        this.init("", null, 0, false);
    }

    public XmlClass(String name) {
        this.init(name, null, 0);
    }

    public XmlClass(String name, boolean loadClasses) {
        this.init(name, null, 0, loadClasses);
    }

    public XmlClass(Class cls) {
        this.init(cls.getName(), cls, 0, true);
    }

    public XmlClass(Class cls, boolean loadClasses) {
        this.init(cls.getName(), cls, 0, loadClasses);
    }

    public XmlClass(String className, int index) {
        this.init(className, null, index, true);
    }

    public XmlClass(String className, int index, boolean loadClasses) {
        this.init(className, null, index, loadClasses);
    }

    private void init(String className, Class cls, int index) {
        this.init(className, cls, index, true);
    }

    private void init(String className, Class cls, int index, boolean resolveClass) {
        this.m_name = className;
        this.m_class = cls;
        this.m_index = index;
        if (null == this.m_class && resolveClass) {
            this.loadClass();
        }
    }

    private void loadClass() {
        this.m_class = ClassHelper.forName(this.m_name);
        if (null == this.m_class) {
            throw new TestNGException("Cannot find class in classpath: " + this.m_name);
        }
    }

    public Class getSupportClass() {
        if (this.m_class == null) {
            this.loadClass();
        }
        return this.m_class;
    }

    public void setClass(Class className) {
        this.m_class = className;
    }

    public List<String> getExcludedMethods() {
        return this.m_excludedMethods;
    }

    public void setExcludedMethods(List<String> excludedMethods) {
        this.m_excludedMethods = excludedMethods;
    }

    public List<XmlInclude> getIncludedMethods() {
        return this.m_includedMethods;
    }

    public void setIncludedMethods(List<XmlInclude> includedMethods) {
        this.m_includedMethods = includedMethods;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean loadClasses() {
        return this.m_loadClasses;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("class", this.m_name).toString();
    }

    public String toXml(String indent) {
        boolean hasParameters;
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        Properties prop = new Properties();
        prop.setProperty("name", this.getName());
        boolean hasMethods = !this.m_includedMethods.isEmpty() || !this.m_excludedMethods.isEmpty();
        boolean bl = hasParameters = !this.m_parameters.isEmpty();
        if (hasParameters || hasMethods) {
            xsb.push("class", prop);
            XmlUtils.dumpParameters(xsb, this.m_parameters);
            if (hasMethods) {
                xsb.push("methods");
                for (XmlInclude xmlInclude : this.getIncludedMethods()) {
                    xsb.getStringBuffer().append(xmlInclude.toXml(indent + "    "));
                }
                for (String string : this.getExcludedMethods()) {
                    Properties p = new Properties();
                    p.setProperty("name", string);
                    xsb.addEmptyElement("exclude", p);
                }
                xsb.pop("methods");
            }
            xsb.pop("class");
        } else {
            xsb.addEmptyElement("class", prop);
        }
        return xsb.toXML();
    }

    public static String listToString(List<Integer> invocationNumbers) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (Integer n : invocationNumbers) {
            if (i++ > 0) {
                result.append(" ");
            }
            result.append(n);
        }
        return result.toString();
    }

    public Object clone() {
        XmlClass result = new XmlClass(this.getName(), this.getIndex(), this.loadClasses());
        result.setExcludedMethods(this.getExcludedMethods());
        result.setIncludedMethods(this.getIncludedMethods());
        return result;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_class == null ? 0 : this.m_class.hashCode());
        result = 31 * result + (this.m_loadClasses ? 1 : 0);
        result = 31 * result + (this.m_excludedMethods == null ? 0 : this.m_excludedMethods.hashCode());
        result = 31 * result + (this.m_includedMethods == null ? 0 : this.m_includedMethods.hashCode());
        result = 31 * result + this.m_index;
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != obj.getClass()) {
            return XmlSuite.f();
        }
        XmlClass other = (XmlClass)obj;
        if (this.m_class == null) {
            if (other.m_class != null) {
                return false;
            }
        } else {
            if (this.m_class != null && other.m_class != null && !this.m_class.equals(other.m_class)) {
                return false;
            }
            if (other.m_loadClasses != this.m_loadClasses) {
                return false;
            }
            if (!this.m_excludedMethods.equals(other.m_excludedMethods)) {
                return false;
            }
        }
        if (this.m_includedMethods == null ? other.m_includedMethods != null : !this.m_includedMethods.equals(other.m_includedMethods)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return XmlSuite.f();
        }
        return true;
    }

    public void setParameters(Map<String, String> parameters) {
        this.m_parameters.clear();
        this.m_parameters.putAll(parameters);
    }

    public Map<String, String> getAllParameters() {
        Map<String, String> result = Maps.newHashMap();
        Map<String, String> parameters = this.m_xmlTest.getLocalParameters();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            result.put(parameter.getKey(), parameter.getValue());
        }
        for (String key : this.m_parameters.keySet()) {
            result.put(key, this.m_parameters.get(key));
        }
        return result;
    }

    public Map<String, String> getLocalParameters() {
        return this.m_parameters;
    }

    @Deprecated
    public Map<String, String> getParameters() {
        return this.getAllParameters();
    }

    public void setXmlTest(XmlTest test) {
        this.m_xmlTest = test;
    }
}

