/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.capitalization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateCapitalizationIntention
implements IntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/capitalization/AnnotateCapitalizationIntention", "isAvailable"));
        }
        PsiModifierListOwner element = AnnotateCapitalizationIntention.getElement(editor, file);
        return element != null && (ApplicationManager.getApplication().isUnitTestMode() || !element.getManager().isInProject((PsiElement)element)) && AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (String[])new String[]{Nls.class.getName()}) == null;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/capitalization/AnnotateCapitalizationIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Annotate capitalization type" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/capitalization/AnnotateCapitalizationIntention", "getFamilyName"));
        }
        return "Annotate capitalization type";
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/capitalization/AnnotateCapitalizationIntention", "invoke"));
        }
        final PsiModifierListOwner modifierListOwner = AnnotateCapitalizationIntention.getElement(editor, file);
        if (modifierListOwner == null) {
            throw new IncorrectOperationException();
        }
        BaseListPopupStep<Nls.Capitalization> step = new BaseListPopupStep<Nls.Capitalization>(null, new Nls.Capitalization[]{Nls.Capitalization.Title, Nls.Capitalization.Sentence}){

            public PopupStep onChosen(final Nls.Capitalization selectedValue, boolean finalChoice) {
                new WriteCommandAction.Simple(project, new PsiFile[0]){

                    protected void run() throws Throwable {
                        String nls = Nls.class.getName();
                        PsiAnnotation annotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@" + nls + "(capitalization = " + nls + ".Capitalization." + selectedValue.toString() + ")", (PsiElement)modifierListOwner);
                        new AddAnnotationFix(Nls.class.getName(), modifierListOwner, annotation.getParameterList().getAttributes(), new String[0]).applyFix();
                    }
                }.execute();
                return FINAL_CHOICE;
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static PsiModifierListOwner getElement(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
        if (parameter == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class);
        if (method == null) {
            return null;
        }
        PsiType type = parameter.getType();
        return type.equalsToText("java.lang.String") ? parameter : null;
    }
}

