/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.uiDesigner.binding.FormReferencesSearcher;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FormClassIndex
extends ScalarIndexExtension<String> {
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FormClassIndex");
    private final EnumeratorStringDescriptor myKeyDescriptor = new EnumeratorStringDescriptor();
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/FormClassIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        MyDataIndexer myDataIndexer = this.myDataIndexer;
        if (myDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/FormClassIndex", "getIndexer"));
        }
        return myDataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = this.myKeyDescriptor;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/FormClassIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.GUI_DESIGNER_FORM});
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/FormClassIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    public static List<PsiFile> findFormsBoundToClass(Project project, String className) {
        return FormClassIndex.findFormsBoundToClass(project, className, ProjectScope.getAllScope((Project)project));
    }

    public static List<PsiFile> findFormsBoundToClass(final Project project, final String className, final GlobalSearchScope scope) {
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<PsiFile>>(){

            public List<PsiFile> compute() {
                Collection files;
                try {
                    files = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)className, GlobalSearchScope.projectScope((Project)project).intersectWith(scope));
                }
                catch (IndexNotReadyException e) {
                    return Collections.emptyList();
                }
                if (files.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<PsiFile> result = new ArrayList<PsiFile>();
                for (VirtualFile file : files) {
                    PsiFile psiFile;
                    if (!file.isValid() || (psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) continue;
                    result.add(psiFile);
                }
                return result;
            }
        });
    }

    public static List<PsiFile> findFormsBoundToClass(Project project, @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/uiDesigner/binding/FormClassIndex", "findFormsBoundToClass"));
        }
        String qName = FormReferencesSearcher.getQualifiedName(psiClass);
        if (qName == null) {
            return Collections.emptyList();
        }
        return FormClassIndex.findFormsBoundToClass(project, qName);
    }

    public static List<PsiFile> findFormsBoundToClass(Project project, PsiClass psiClass, GlobalSearchScope scope) {
        String qName = FormReferencesSearcher.getQualifiedName(psiClass);
        if (qName == null) {
            return Collections.emptyList();
        }
        return FormClassIndex.findFormsBoundToClass(project, qName, scope);
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/uiDesigner/binding/FormClassIndex$MyDataIndexer", "map"));
            }
            String className = null;
            try {
                className = Utils.getBoundClassName((String)inputData.getContentAsText().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (className != null) {
                Map<String, Object> map = Collections.singletonMap(className, null);
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/FormClassIndex$MyDataIndexer", "map"));
                }
                return map;
            }
            Map<String, Void> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/FormClassIndex$MyDataIndexer", "map"));
            }
            return map;
        }
    }
}

