/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtilBase;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.uiDesigner.binding.ReferenceInForm;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class ResourceBundleKeyReference
extends ReferenceInForm {
    private final String myBundleName;

    public ResourceBundleKeyReference(PsiPlainTextFile file, String bundleName, TextRange keyNameRange) {
        super(file, keyNameRange);
        this.myBundleName = bundleName;
    }

    public PsiElement resolve() {
        Project project = this.myFile.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile formVirtualFile = this.myFile.getVirtualFile();
        if (formVirtualFile == null) {
            return null;
        }
        Module module = fileIndex.getModuleForFile(formVirtualFile);
        if (module == null) {
            return null;
        }
        PropertiesFile propertiesFile = PropertiesUtilBase.getPropertiesFile((String)this.myBundleName, (Module)module, null);
        if (propertiesFile == null) {
            return null;
        }
        IProperty property = propertiesFile.findPropertyByKey(this.getRangeText());
        return property == null ? null : property.getPsiElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/uiDesigner/binding/ResourceBundleKeyReference", "bindToElement"));
        }
        if (!(element instanceof IProperty)) {
            throw new IncorrectOperationException();
        }
        this.updateRangeText(((IProperty)element).getUnescapedKey());
        return this.myFile;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof IProperty)) {
            return false;
        }
        IProperty property = (IProperty)element;
        String baseName = ResourceBundleManager.getInstance((Project)element.getProject()).getFullName(property.getPropertiesFile());
        return baseName != null && this.myBundleName.equals(baseName.replace('.', '/')) && this.getRangeText().equals(property.getUnescapedKey());
    }
}

