/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.GridDropLocation;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.util.Collections;

public class GridReplaceDropLocation
extends GridDropLocation {
    public GridReplaceDropLocation(RadContainer container, int row, int column) {
        super(container, row, column);
    }

    @Override
    public boolean canDrop(ComponentDragObject dragObject) {
        if (dragObject.getComponentCount() != 1) {
            return false;
        }
        return super.canDrop(dragObject);
    }

    @Override
    protected RadComponent findOverlappingComponent(int startRow, int startCol, int rowSpan, int colSpan) {
        if (rowSpan == 1 && colSpan == 1) {
            return null;
        }
        return super.findOverlappingComponent(startRow, startCol, rowSpan, colSpan);
    }

    @Override
    public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
        RadComponent c = this.myContainer.getComponentAtGrid(this.myRow, this.myColumn);
        if (c != null) {
            FormEditingUtil.deleteComponents(Collections.singletonList(c), false);
        }
        super.processDrop(editor, components, constraintsToAdjust, dragObject);
    }
}

