/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.SourceInstrumentingCompiler;
import com.intellij.openapi.compiler.TimestampValidityState;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.make.BindingsCache;
import com.intellij.uiDesigner.make.FormElementNavigatable;
import com.intellij.uiDesigner.make.FormSourceCodeGenerator;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.java.CopyResourcesUtil;

public final class Form2SourceCompiler
implements SourceInstrumentingCompiler {
    private static VirtualFile findSourceFile(CompileContext context, VirtualFile formFile, String className) {
        Module module = context.getModuleByFile(formFile);
        if (module == null) {
            return null;
        }
        PsiClass aClass = FormEditingUtil.findClassToBind(module, className);
        if (aClass == null) {
            return null;
        }
        PsiFile containingFile = aClass.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        return containingFile.getVirtualFile();
    }

    @NotNull
    public String getDescription() {
        String string = UIDesignerBundle.message("component.gui.designer.form.to.source.compiler", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/make/Form2SourceCompiler", "getDescription"));
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        final Project project = context.getProject();
        if (GuiDesignerConfiguration.getInstance((Project)project).INSTRUMENT_CLASSES) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/make/Form2SourceCompiler", "getProcessingItems"));
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        final ArrayList items = new ArrayList();
        DumbService.getInstance((Project)project).runReadActionInSmartMode(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompileScope scope = context.getCompileScope();
                CompileScope projectScope = context.getProjectCompileScope();
                VirtualFile[] formFiles = projectScope.getFiles(StdFileTypes.GUI_DESIGNER_FORM, true);
                CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
                try (BindingsCache bindingsCache = new BindingsCache(project);){
                    HashMap<String, VirtualFile> class2form = new HashMap<String, VirtualFile>();
                    for (VirtualFile formFile : formFiles) {
                        String classToBind;
                        if (compilerManager.isExcludedFromCompilation(formFile)) continue;
                        try {
                            classToBind = bindingsCache.getBoundClassName(formFile);
                        }
                        catch (AlienFormFileException e) {
                            continue;
                        }
                        catch (Exception e) {
                            Form2SourceCompiler.addError(context, new FormErrorInfo(null, UIDesignerBundle.message("error.cannot.process.form.file", e)), formFile);
                            continue;
                        }
                        if (classToBind == null) continue;
                        VirtualFile sourceFile = Form2SourceCompiler.findSourceFile(context, formFile, classToBind);
                        if (sourceFile == null) {
                            if (!scope.belongs(formFile.getUrl())) continue;
                            Form2SourceCompiler.addError(context, new FormErrorInfo(null, UIDesignerBundle.message("error.class.to.bind.does.not.exist", classToBind)), formFile);
                            continue;
                        }
                        boolean inScope = scope.belongs(sourceFile.getUrl()) || scope.belongs(formFile.getUrl());
                        VirtualFile alreadyProcessedForm = (VirtualFile)class2form.get(classToBind);
                        if (alreadyProcessedForm != null) {
                            if (!inScope) continue;
                            Form2SourceCompiler.addError(context, new FormErrorInfo(null, UIDesignerBundle.message("error.duplicate.bind", classToBind, alreadyProcessedForm.getPresentableUrl())), formFile);
                            continue;
                        }
                        class2form.put(classToBind, formFile);
                        if (!inScope) continue;
                        items.add(new MyInstrumentationItem(sourceFile, formFile));
                    }
                }
            }
        });
        FileProcessingCompiler.ProcessingItem[] processingItemArray = items.toArray(new FileProcessingCompiler.ProcessingItem[items.size()]);
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/make/Form2SourceCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    public FileProcessingCompiler.ProcessingItem[] process(final CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        final ArrayList compiledItems = new ArrayList();
        context.getProgressIndicator().setText(UIDesignerBundle.message("progress.compiling.ui.forms", new Object[0]));
        int formsProcessed = 0;
        final Project project = context.getProject();
        final FormSourceCodeGenerator generator = new FormSourceCodeGenerator(project);
        final HashSet processedModules = new HashSet();
        final ArrayList filesToRefresh = new ArrayList();
        for (FileProcessingCompiler.ProcessingItem item1 : items) {
            context.getProgressIndicator().setFraction((double)(++formsProcessed) / (double)items.length);
            final MyInstrumentationItem item = (MyInstrumentationItem)item1;
            final VirtualFile formFile = item.getFormFile();
            if (GuiDesignerConfiguration.getInstance((Project)project).COPY_FORMS_RUNTIME_TO_OUTPUT) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)formFile, (Project)project);
                        if (module != null && !processedModules.contains(module)) {
                            processedModules.add(module);
                            String moduleOutputPath = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false);
                            try {
                                String testsOutputPath;
                                if (moduleOutputPath != null) {
                                    filesToRefresh.addAll(CopyResourcesUtil.copyFormsRuntime((String)moduleOutputPath, (boolean)false));
                                }
                                if ((testsOutputPath = CompilerPaths.getModuleOutputPath((Module)module, (boolean)true)) != null && !testsOutputPath.equals(moduleOutputPath)) {
                                    filesToRefresh.addAll(CopyResourcesUtil.copyFormsRuntime((String)testsOutputPath, (boolean)false));
                                }
                            }
                            catch (IOException e) {
                                Form2SourceCompiler.addError(context, new FormErrorInfo(null, UIDesignerBundle.message("error.cannot.copy.gui.designer.form.runtime", module.getName(), e.toString())), null);
                            }
                        }
                    }
                });
            }
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                                    generator.generate(formFile);
                                    ArrayList<FormErrorInfo> errors = generator.getErrors();
                                    if (errors.size() == 0) {
                                        compiledItems.add(item);
                                    } else {
                                        for (FormErrorInfo e : errors) {
                                            Form2SourceCompiler.addError(context, e, formFile);
                                        }
                                    }
                                }
                            });
                        }
                    }, "", null);
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
            }, ModalityState.NON_MODAL);
        }
        CompilerUtil.refreshIOFiles(filesToRefresh);
        return compiledItems.toArray(new FileProcessingCompiler.ProcessingItem[compiledItems.size()]);
    }

    private static void addError(CompileContext context, FormErrorInfo e, VirtualFile formFile) {
        if (formFile != null) {
            FormElementNavigatable navigatable = new FormElementNavigatable(context.getProject(), formFile, e.getComponentId());
            context.addMessage(CompilerMessageCategory.ERROR, formFile.getPresentableUrl() + ": " + e.getErrorMessage(), formFile.getUrl(), -1, -1, (Navigatable)navigatable);
        } else {
            context.addMessage(CompilerMessageCategory.ERROR, e.getErrorMessage(), null, -1, -1);
        }
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return TimestampValidityState.load((DataInput)in);
    }

    private static final class MyInstrumentationItem
    implements FileProcessingCompiler.ProcessingItem {
        @NotNull
        private final VirtualFile mySourceFile;
        private final VirtualFile myFormFile;
        private final TimestampValidityState myState;

        public MyInstrumentationItem(@NotNull VirtualFile sourceFile, VirtualFile formFile) {
            if (sourceFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/uiDesigner/make/Form2SourceCompiler$MyInstrumentationItem", "<init>"));
            }
            this.mySourceFile = sourceFile;
            this.myFormFile = formFile;
            this.myState = new TimestampValidityState(formFile.getTimeStamp());
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.mySourceFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/make/Form2SourceCompiler$MyInstrumentationItem", "getFile"));
            }
            return virtualFile;
        }

        public VirtualFile getFormFile() {
            return this.myFormFile;
        }

        public ValidityState getValidityState() {
            return this.myState;
        }
    }
}

