/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class BooleanEditor
extends PropertyEditor<Boolean> {
    private final JCheckBox myCheckBox = new JCheckBox();
    private boolean myInsideChange;

    public BooleanEditor() {
        this.myCheckBox.addActionListener(new MyActionListener());
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.myCheckBox);
    }

    @Override
    public Boolean getValue() throws Exception {
        return this.myCheckBox.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent getComponent(RadComponent ignored, Boolean value, InplaceContext inplaceContext) {
        this.myInsideChange = true;
        try {
            this.myCheckBox.setBackground(UIUtil.getTableBackground());
            this.myCheckBox.setSelected(value != null && value != false);
            JCheckBox jCheckBox = this.myCheckBox;
            return jCheckBox;
        }
        finally {
            this.myInsideChange = false;
        }
    }

    private final class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BooleanEditor.this.myInsideChange) {
                BooleanEditor.this.fireValueCommitted(true, false);
            }
        }
    }
}

