/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.EnumEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public class IntroEnumProperty
extends IntrospectedProperty<Enum> {
    private final Class myEnumClass;
    private LabelPropertyRenderer<Enum> myRenderer;
    private EnumEditor myEditor;

    public IntroEnumProperty(String name, Method readMethod, Method writeMethod, boolean storeAsClient, Class enumClass) {
        super(name, readMethod, writeMethod, storeAsClient);
        this.myEnumClass = enumClass;
    }

    @Override
    @NotNull
    public PropertyRenderer<Enum> getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new LabelPropertyRenderer();
        }
        LabelPropertyRenderer<Enum> labelPropertyRenderer = this.myRenderer;
        if (labelPropertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/IntroEnumProperty", "getRenderer"));
        }
        return labelPropertyRenderer;
    }

    @Override
    public PropertyEditor<Enum> getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new EnumEditor(this.myEnumClass);
        }
        return this.myEditor;
    }
}

