/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.FileSystem;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.IFileSystem;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class CvsFileSystem
implements ICvsFileSystem {
    private final IFileSystem localFileSystem;
    private final IFileSystem adminFileSystem;
    private final String repository;

    public CvsFileSystem(File rootDirectory, String repository) {
        this(rootDirectory, rootDirectory, repository);
    }

    public CvsFileSystem(File localRootDirectory, File adminRootDirectory, String repository) {
        BugLog.getInstance().assertNotNull((Object)localRootDirectory);
        BugLog.getInstance().assertNotNull((Object)adminRootDirectory);
        BugLog.getInstance().assertNotNull((Object)repository);
        this.localFileSystem = new FileSystem(localRootDirectory);
        this.adminFileSystem = new FileSystem(adminRootDirectory);
        this.repository = FileUtils.ensureTrailingSlash((String)repository).replace('\\', '/');
    }

    public FileObject getFileObject(String relativeLocalDirectoryPath, String repositoryFilePath) {
        BugLog.getInstance().assertTrue(!relativeLocalDirectoryPath.startsWith("/"), "relativeLocalDirectory '" + relativeLocalDirectoryPath + "' must not start with /");
        BugLog.getInstance().assertTrue(relativeLocalDirectoryPath.endsWith("/"), "relativeLocalDirectory '" + relativeLocalDirectoryPath + "' must end with /");
        BugLog.getInstance().assertTrue(!repositoryFilePath.endsWith("/"), "repositoryFilePath '" + repositoryFilePath + "' must not end with /");
        BugLog.getInstance().assertTrue(repositoryFilePath.indexOf(47) >= 0, "repositoryFileName '" + repositoryFilePath + "' must contain a /");
        if (relativeLocalDirectoryPath.equals("./")) {
            relativeLocalDirectoryPath = "";
        }
        String fileName = CvsFileSystem.getFileNameFromRepositoryPath(repositoryFilePath);
        return FileObject.createInstance((String)('/' + relativeLocalDirectoryPath + fileName));
    }

    public DirectoryObject getDirectoryObject(String relativeLocalDirectoryPath, String repositoryDirectoryPath) {
        BugLog.getInstance().assertTrue(!relativeLocalDirectoryPath.startsWith("/"), "relativeLocalDirectoryPath '" + relativeLocalDirectoryPath + "' must not start with /");
        BugLog.getInstance().assertTrue(relativeLocalDirectoryPath.endsWith("/"), "relativeLocalDirectoryPath '" + relativeLocalDirectoryPath + "' must end with /");
        BugLog.getInstance().assertTrue(repositoryDirectoryPath.endsWith("/"), "repositoryDirectoryPath '" + repositoryDirectoryPath + "' must end with /");
        if (relativeLocalDirectoryPath.equals("./")) {
            relativeLocalDirectoryPath = "";
        }
        return DirectoryObject.createInstance((String)('/' + FileUtils.removeTrailingSlash((String)relativeLocalDirectoryPath)));
    }

    public IFileSystem getLocalFileSystem() {
        return this.localFileSystem;
    }

    public IFileSystem getAdminFileSystem() {
        return this.adminFileSystem;
    }

    public String getRelativeRepositoryPath(String repositoryPath) {
        if (repositoryPath.startsWith(this.repository)) {
            String relativeRepositoryPath = repositoryPath.substring(this.repository.length());
            if ((relativeRepositoryPath = FileUtils.removeTrailingSlash((String)relativeRepositoryPath)).length() == 0) {
                relativeRepositoryPath = ".";
            }
            return relativeRepositoryPath;
        }
        return FileUtils.removeTrailingSlash((String)repositoryPath);
    }

    public String getRepositoryForDirectory(DirectoryObject directoryObject, IAdminReader adminReader) {
        try {
            return adminReader.getRepositoryForDirectory(directoryObject, this.repository, (ICvsFileSystem)this);
        }
        catch (IOException ex) {
            return FileUtils.removeTrailingSlash((String)this.repository) + directoryObject.getPath();
        }
    }

    public FileObject unixFileNameToFileObject(String unixFileName) {
        return FileObject.createInstance((String)('/' + unixFileName));
    }

    private static String getFileNameFromRepositoryPath(String repositoryFilePath) {
        int lastSlashIndex = repositoryFilePath.lastIndexOf(47);
        return repositoryFilePath.substring(lastSlashIndex + 1);
    }
}

