/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSLock;

public class SimpleFSLockFactory
extends LockFactory {
    private File lockDir;

    SimpleFSLockFactory() throws IOException {
        this((File)null);
    }

    public SimpleFSLockFactory(File lockDir) throws IOException {
        this.setLockDir(lockDir);
    }

    public SimpleFSLockFactory(String lockDirName) throws IOException {
        this.lockDir = new File(lockDirName);
        this.setLockDir(this.lockDir);
    }

    void setLockDir(File lockDir) throws IOException {
        this.lockDir = lockDir;
    }

    public Lock makeLock(String lockName) {
        if (this.lockPrefix != null) {
            lockName = this.lockPrefix + "-" + lockName;
        }
        return new SimpleFSLock(this.lockDir, lockName);
    }

    public void clearLock(String lockName) throws IOException {
        if (this.lockDir.exists()) {
            File lockFile;
            if (this.lockPrefix != null) {
                lockName = this.lockPrefix + "-" + lockName;
            }
            if ((lockFile = new File(this.lockDir, lockName)).exists() && !lockFile.delete()) {
                throw new IOException("Cannot delete " + lockFile);
            }
        }
    }
}

