/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxDefaultPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxStaticSetterAttributeDescriptor;

public class JavaFxExpandAttributeIntention
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFxExpandAttributeIntention.class.getName()));

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiType fieldType;
        PsiType itemType;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxExpandAttributeIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxExpandAttributeIntention", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return;
        }
        XmlAttribute attr = (XmlAttribute)element.getParent();
        String name = attr.getName();
        XmlAttributeDescriptor descriptor = attr.getDescriptor();
        LOG.assertTrue(descriptor != null);
        String value = attr.getValue();
        PsiElement declaration = descriptor.getDeclaration();
        if (declaration instanceof PsiField && (itemType = JavaGenericsUtil.getCollectionItemType((PsiType)(fieldType = ((PsiField)declaration).getType()), (GlobalSearchScope)declaration.getResolveScope())) != null) {
            final String typeNode = itemType.getPresentableText();
            JavaFxPsiUtil.insertImportWhenNeeded((XmlFile)attr.getContainingFile(), typeNode, itemType.getCanonicalText());
            Object[] vals = value.split(",");
            value = StringUtil.join((Object[])vals, (Function)new Function<String, String>(){

                public String fun(String s) {
                    return "<" + typeNode + " " + "fx:value" + "=\"" + s.trim() + "\"/>";
                }
            }, (String)"\n");
        }
        XmlTag childTag = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)("<" + name + ">" + value + "</" + name + ">"));
        attr.getParent().add((PsiElement)childTag);
        attr.delete();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        XmlAttributeDescriptor descriptor;
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxExpandAttributeIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxExpandAttributeIntention", "isAvailable"));
        }
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_NAME && (parent = element.getParent()) instanceof XmlAttribute && (descriptor = ((XmlAttribute)parent).getDescriptor()) instanceof JavaFxPropertyAttributeDescriptor && !(descriptor instanceof JavaFxDefaultPropertyAttributeDescriptor)) {
            PsiParameter[] parameters;
            PsiType tagType = null;
            PsiElement declaration = descriptor.getDeclaration();
            if (declaration instanceof PsiField) {
                tagType = ((PsiField)declaration).getType();
            } else if (declaration instanceof PsiMethod && (parameters = ((PsiMethod)declaration).getParameterList().getParameters()).length == 1) {
                tagType = parameters[0].getType();
            }
            PsiClass tagClass = PsiUtil.resolveClassInType((PsiType)(tagType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)tagType).getBoxedType(parent) : tagType));
            if (tagClass != null && JavaFxPsiUtil.isAbleToInstantiate(tagClass) == null || descriptor instanceof JavaFxStaticSetterAttributeDescriptor) {
                this.setText("Expand '" + ((XmlAttribute)parent).getName() + "' to tag");
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Expand attribute to tag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxExpandAttributeIntention", "getFamilyName"));
        }
        return "Expand attribute to tag";
    }
}

